/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.editparts.ConnectionEditPart;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.application.editparts.UntypedSubAppInterfaceElementEditPart;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class ExpandedInterfacePositionMap {
    private static final String PREFERENCE_STORE = "org.eclipse.fordiac.ide.gef";
    private final SubAppForFBNetworkEditPart ep;
    private Rectangle clientArea = null;
    public Map<IFigure, Integer> inputPositions = null;
    public Map<IFigure, Integer> outputPositions = null;
    public Map<IFigure, Integer> directPositions = null;
    public Map<IFigure, InterfaceEditPart> editPartMap = new HashMap<IFigure, InterfaceEditPart>();
    public Map<IFigure, Integer> sizes = null;
    private int inputUnconnectedStart = Integer.MAX_VALUE;
    private int outputUnconnectedStart = Integer.MAX_VALUE;
    private int inputDirectEnd;
    private int outputDirectEnd;
    private int inputDirectEndWithoutEvents;
    private int outputDirectEndWithoutEvents;

    public ExpandedInterfacePositionMap(SubAppForFBNetworkEditPart ep) {
        this.ep = ep;
    }

    public int getInputUnconnectedStart() {
        return this.inputUnconnectedStart;
    }

    public int getOutputUnconnectedStart() {
        return this.outputUnconnectedStart;
    }

    public void refreshParent() {
        this.ep.getChildren().stream().filter(InterfaceEditPart.class::isInstance).forEach(EditPart::refresh);
    }

    public int getInputDirectEnd() {
        return this.inputDirectEnd;
    }

    public int getOutputDirectEnd() {
        return this.outputDirectEnd;
    }

    public int getInputDirectEndWithoutEvents() {
        return this.inputDirectEndWithoutEvents;
    }

    public int getOutputDirectEndWithoutEvents() {
        return this.outputDirectEndWithoutEvents;
    }

    public void calculate() {
        this.editPartMap.clear();
        Map<Boolean, List<InterfaceEditPart>> interfaceMap = this.ep.getChildren().stream().filter(InterfaceEditPart.class::isInstance).map(InterfaceEditPart.class::cast).collect(Collectors.groupingBy(InterfaceEditPart::isInput));
        List<InterfaceEditPart> inputList = interfaceMap.getOrDefault(Boolean.TRUE, new ArrayList());
        List<InterfaceEditPart> outputList = interfaceMap.getOrDefault(Boolean.FALSE, new ArrayList());
        this.clientArea = ExpandedInterfacePositionMap.getClientArea(inputList, outputList);
        if (this.clientArea == null) {
            return;
        }
        this.sizes = this.getPinSizes(inputList, outputList);
        boolean directFlag = Platform.getPreferencesService().getBoolean(PREFERENCE_STORE, "ExpandedInterfaceOldDirectBehaviour", false, null);
        this.directPositions = directFlag ? this.calculateDirectPositionsStack(inputList, outputList) : this.calculateDirectPositions(inputList);
        ScrollPane inputScrollPane = !inputList.isEmpty() ? (ScrollPane)((InterfaceEditPart)inputList.get(0)).getFigure().getParent().getParent().getParent() : null;
        ScrollPane outputScrollPane = !outputList.isEmpty() ? (ScrollPane)((InterfaceEditPart)outputList.get(0)).getFigure().getParent().getParent().getParent() : null;
        inputList = inputList.stream().filter(ie -> !this.directPositions.containsKey(ie.getFigure())).toList();
        outputList = outputList.stream().filter(ie -> !this.directPositions.containsKey(ie.getFigure())).toList();
        Map<IFigure, Integer> inputMap = this.calculateInput(inputList);
        Map<IFigure, Integer> outputMap = this.calculateOutput(outputList);
        this.resolveCollisions(inputMap);
        this.resolveCollisions(outputMap);
        this.inputUnconnectedStart = this.calculateUnconnectedStartPositions(inputMap);
        this.outputUnconnectedStart = this.calculateUnconnectedStartPositions(outputMap);
        if (this.inputUnconnectedStart == Integer.MAX_VALUE && !this.directPositions.isEmpty()) {
            this.inputUnconnectedStart = this.inputDirectEnd;
        }
        if (this.outputUnconnectedStart == Integer.MAX_VALUE && !this.directPositions.isEmpty()) {
            this.outputUnconnectedStart = this.outputDirectEnd;
        }
        this.inputPositions = inputMap;
        this.outputPositions = outputMap;
        this.stackToFit(this.clientArea, this.inputPositions, true);
        this.stackToFit(this.clientArea, this.outputPositions, false);
        this.applyScrollOffset(inputScrollPane, outputScrollPane);
    }

    private void applyScrollOffset(ScrollPane inputScrollPane, ScrollPane outputScrollPane) {
        int outputScrollValue;
        int inputScrollValue = inputScrollPane != null ? inputScrollPane.getVerticalScrollBar().getValue() : 0;
        int n = outputScrollValue = outputScrollPane != null ? outputScrollPane.getVerticalScrollBar().getValue() : 0;
        if (inputScrollValue != 0) {
            this.inputDirectEnd -= inputScrollValue;
            this.inputUnconnectedStart -= inputScrollValue;
            for (Map.Entry<IFigure, Integer> entry : this.inputPositions.entrySet()) {
                this.inputPositions.put(entry.getKey(), entry.getValue() - inputScrollValue);
            }
        }
        if (outputScrollValue != 0) {
            this.outputDirectEnd -= outputScrollValue;
            this.outputUnconnectedStart -= outputScrollValue;
            for (Map.Entry<IFigure, Integer> entry : this.outputPositions.entrySet()) {
                this.outputPositions.put(entry.getKey(), entry.getValue() - outputScrollValue);
            }
        }
        for (Map.Entry<IFigure, Integer> entry : this.directPositions.entrySet()) {
            if (this.editPartMap.get(entry.getKey()).isInput()) {
                this.directPositions.put(entry.getKey(), entry.getValue() - inputScrollValue);
                continue;
            }
            this.directPositions.put(entry.getKey(), entry.getValue() - outputScrollValue);
        }
    }

    private Map<IFigure, Integer> calculateDirectPositionsStack(List<InterfaceEditPart> inputList, List<InterfaceEditPart> outputList) {
        List<ConnectionEditPart> direct = inputList.stream().map(AbstractGraphicalEditPart::getSourceConnections).flatMap(Collection::stream).map(ConnectionEditPart.class::cast).filter(ExpandedInterfacePositionMap::isSkipConnection).toList();
        HashMap<IFigure, Integer> pos = new HashMap<IFigure, Integer>();
        ArrayList<InterfaceEditPart> input = new ArrayList<InterfaceEditPart>();
        ArrayList<InterfaceEditPart> output = new ArrayList<InterfaceEditPart>();
        for (ConnectionEditPart conn : direct) {
            InterfaceEditPart source = (InterfaceEditPart)conn.getSource();
            InterfaceEditPart target = (InterfaceEditPart)conn.getTarget();
            if (!input.contains(source)) {
                input.add(source);
            }
            if (output.contains(source)) continue;
            output.add(target);
        }
        boolean eventFlag = Platform.getPreferencesService().getBoolean(PREFERENCE_STORE, "ExpandedInterfaceEventsTop", false, null);
        int y = this.clientArea.top();
        for (InterfaceEditPart pin : input) {
            y = this.applySize(pos, y, pin);
        }
        this.inputDirectEndWithoutEvents = y;
        if (eventFlag) {
            for (InterfaceEditPart pin : ExpandedInterfacePositionMap.getEvents(inputList, input)) {
                y = this.applySize(pos, y, pin);
            }
        }
        this.inputDirectEnd = y;
        y = this.clientArea.top();
        for (InterfaceEditPart pin : output) {
            y = this.applySize(pos, y, pin);
        }
        this.outputDirectEndWithoutEvents = y;
        if (eventFlag) {
            for (InterfaceEditPart pin : ExpandedInterfacePositionMap.getEvents(outputList, output)) {
                y = this.applySize(pos, y, pin);
            }
        }
        this.outputDirectEnd = y;
        return pos;
    }

    private static List<InterfaceEditPart> getEvents(List<InterfaceEditPart> eventPins, List<InterfaceEditPart> directPins) {
        return eventPins.stream().filter(ie -> ie.getModel() instanceof Event).filter(Predicate.not(directPins::contains)).toList();
    }

    private int applySize(Map<IFigure, Integer> pos, int y, InterfaceEditPart pin) {
        pos.put(pin.getFigure(), y);
        return y + this.sizes.get(pin.getFigure());
    }

    private Map<IFigure, Integer> getPinSizes(List<InterfaceEditPart> inputList, List<InterfaceEditPart> outputList) {
        HashMap<IFigure, Integer> newSizes = new HashMap<IFigure, Integer>();
        for (InterfaceEditPart pin : inputList) {
            this.prozessInterfacEditPartSize(newSizes, pin);
        }
        for (InterfaceEditPart pin : outputList) {
            this.prozessInterfacEditPartSize(newSizes, pin);
        }
        return newSizes;
    }

    protected void prozessInterfacEditPartSize(HashMap<IFigure, Integer> sizes, InterfaceEditPart pin) {
        UntypedSubAppInterfaceElementEditPart subAppPinEP;
        this.editPartMap.put(pin.getFigure(), pin);
        if (pin instanceof UntypedSubAppInterfaceElementEditPart && (subAppPinEP = (UntypedSubAppInterfaceElementEditPart)pin).isOverflow()) {
            subAppPinEP.setOverflow(false);
            subAppPinEP.refresh();
            sizes.put(subAppPinEP.getFigure(), subAppPinEP.getUncollapsedFigureHeight());
        } else {
            sizes.put(pin.getFigure(), pin.getFigure().getBounds().height);
        }
    }

    private static Rectangle getClientArea(List<InterfaceEditPart> inputList, List<InterfaceEditPart> outputList) {
        if (!inputList.isEmpty()) {
            return inputList.get(0).getFigure().getParent().getBounds();
        }
        if (!outputList.isEmpty()) {
            return outputList.get(0).getFigure().getParent().getBounds();
        }
        return null;
    }

    private void stackToFit(Rectangle clientArea, Map<IFigure, Integer> positions, boolean isInput) {
        int y;
        if (positions.isEmpty()) {
            return;
        }
        List entryList = positions.entrySet().stream().filter(e -> !this.directPositions.containsKey(e.getKey())).collect(Collectors.toList());
        entryList.sort(Comparator.comparing(Map.Entry::getValue));
        int bottom = clientArea.bottom() - 10;
        int i = entryList.size() - 1;
        int totalSize = 0;
        while (i >= 0) {
            Map.Entry entry = (Map.Entry)entryList.get(i);
            if ((Integer)entry.getValue() != Integer.MAX_VALUE) break;
            totalSize += this.sizes.get(entry.getKey()).intValue();
            --i;
        }
        if (i < 0) {
            return;
        }
        if (isInput ? this.inputUnconnectedStart + totalSize < bottom : this.outputUnconnectedStart + totalSize < bottom) {
            return;
        }
        int lastY = -1;
        while (i >= 0) {
            IFigure fig = (IFigure)((Map.Entry)entryList.get(i)).getKey();
            InterfaceEditPart pinEp = this.editPartMap.get(fig);
            int size = 0;
            int collapsedSize = 0;
            if (pinEp instanceof UntypedSubAppInterfaceElementEditPart) {
                UntypedSubAppInterfaceElementEditPart untypeSubappPinEP = (UntypedSubAppInterfaceElementEditPart)pinEp;
                untypeSubappPinEP.setOverflow(true);
                untypeSubappPinEP.refresh();
                size = untypeSubappPinEP.getCollapsedFigureHeight();
                collapsedSize = untypeSubappPinEP.getUncollapsedFigureHeight();
            } else {
                collapsedSize = size = pinEp.getFigure().getBounds().height;
            }
            this.sizes.put(fig, size);
            int y2 = (Integer)((Map.Entry)entryList.get(i)).getValue();
            int collapsedY = y2 + (collapsedSize - size) / 2;
            if ((totalSize += size) + collapsedY < bottom) {
                lastY = collapsedY;
                break;
            }
            --i;
        }
        if (i == -1) {
            i = 0;
            y = isInput ? this.inputDirectEnd : this.outputDirectEnd;
        } else {
            y = lastY;
        }
        while (i < entryList.size()) {
            if ((Integer)((Map.Entry)entryList.get(i)).getValue() == Integer.MAX_VALUE) break;
            IFigure fig = (IFigure)((Map.Entry)entryList.get(i)).getKey();
            positions.put(fig, y);
            Integer newSize = this.sizes.get(fig);
            y += newSize != null ? newSize : fig.getBounds().height;
            ++i;
        }
        if (isInput) {
            this.inputUnconnectedStart = y;
        } else {
            this.outputUnconnectedStart = y;
        }
    }

    private Map<IFigure, Integer> calculateDirectPositions(List<InterfaceEditPart> inputList) {
        List<ConnectionEditPart> connections = inputList.stream().map(AbstractGraphicalEditPart::getSourceConnections).flatMap(Collection::stream).map(ConnectionEditPart.class::cast).filter(ExpandedInterfacePositionMap::isSkipConnection).toList();
        HashMap<IFigure, Integer> inputMap = new HashMap<IFigure, Integer>();
        HashMap<IFigure, Integer> outputMap = new HashMap<IFigure, Integer>();
        int inputY = this.clientArea.top();
        for (ConnectionEditPart conn : connections) {
            IFigure inputFigure = ((GraphicalEditPart)conn.getSource()).getFigure();
            IFigure outputFigure = ((GraphicalEditPart)conn.getTarget()).getFigure();
            if (!inputMap.containsKey(inputFigure)) {
                inputMap.put(inputFigure, inputY);
                inputY += inputFigure.getBounds().height + 1;
            }
            if (outputMap.containsKey(outputFigure)) continue;
            int connStart = inputMap.get(inputFigure) + inputFigure.getBounds().height / 2;
            int outputY = connStart - outputFigure.getBounds().height / 2;
            outputMap.put(outputFigure, Math.max(outputY, this.clientArea.top()));
        }
        this.resolveCollisions(outputMap);
        this.inputDirectEnd = inputY;
        Optional max = outputMap.entrySet().stream().max((e1, e2) -> Integer.compare((Integer)e1.getValue(), (Integer)e2.getValue()));
        this.outputDirectEnd = max.isPresent() ? (Integer)((Map.Entry)max.get()).getValue() + ((IFigure)((Map.Entry)max.get()).getKey()).getBounds().height : this.clientArea.top();
        inputMap.putAll(outputMap);
        return inputMap;
    }

    private int calculateUnconnectedStartPositions(Map<IFigure, Integer> map) {
        Optional<Map.Entry> inputOptional = map.entrySet().stream().filter(entry -> (Integer)entry.getValue() != Integer.MAX_VALUE).max((entry1, entry2) -> Integer.compare((Integer)entry1.getValue(), (Integer)entry2.getValue()));
        if (inputOptional.isPresent()) {
            Map.Entry entry3 = inputOptional.get();
            return (Integer)entry3.getValue() + this.sizes.get(entry3.getKey());
        }
        return Integer.MAX_VALUE;
    }

    private Map<IFigure, Integer> calculateInput(List<InterfaceEditPart> inputList) {
        HashMap<IFigure, Integer> map = new HashMap<IFigure, Integer>();
        for (InterfaceEditPart ie : inputList) {
            List connections = ie.getSourceConnections();
            Optional max = connections.stream().min((conn1, conn2) -> Integer.compare(((ConnectionEditPart)conn1).getConnectionFigure().getEnd().y, ((ConnectionEditPart)conn2).getConnectionFigure().getEnd().y));
            if (max.isPresent()) {
                ConnectionEditPart connEp = (ConnectionEditPart)((Object)max.get());
                EditPart editPart = connEp.getSource();
                if (!(editPart instanceof GraphicalEditPart)) continue;
                GraphicalEditPart graphicalEditPart = (GraphicalEditPart)editPart;
                Point end = connEp.getConnectionFigure().getEnd();
                int y = end.y - this.sizes.get(graphicalEditPart.getFigure()) / 2;
                if (ExpandedInterfacePositionMap.isSkipConnection(connEp)) continue;
                map.put(ie.getFigure(), Math.max(y, this.inputDirectEnd));
                continue;
            }
            map.put(ie.getFigure(), Integer.MAX_VALUE);
        }
        return map;
    }

    private Map<IFigure, Integer> calculateOutput(List<InterfaceEditPart> outputList) {
        HashMap<IFigure, Integer> map = new HashMap<IFigure, Integer>();
        for (InterfaceEditPart ie : outputList) {
            List connections = ie.getTargetConnections();
            Optional max = connections.stream().min((conn1, conn2) -> Integer.compare(((ConnectionEditPart)conn1).getConnectionFigure().getStart().y, ((ConnectionEditPart)conn2).getConnectionFigure().getStart().y));
            if (max.isPresent()) {
                ConnectionEditPart connEp = (ConnectionEditPart)((Object)max.get());
                EditPart editPart = connEp.getTarget();
                if (!(editPart instanceof GraphicalEditPart)) continue;
                GraphicalEditPart graphicalEditPart = (GraphicalEditPart)editPart;
                Point start = connEp.getConnectionFigure().getStart();
                int y = start.y - this.sizes.get(graphicalEditPart.getFigure()) / 2;
                if (ExpandedInterfacePositionMap.isSkipConnection(connEp)) continue;
                map.put(ie.getFigure(), Math.max(y, this.outputDirectEnd));
                continue;
            }
            map.put(ie.getFigure(), Integer.MAX_VALUE);
        }
        return map;
    }

    private static boolean isSkipConnection(ConnectionEditPart ep) {
        if (ep.getSource() != null && ep.getTarget() != null) {
            IInterfaceElement sourceModel = (IInterfaceElement)ep.getSource().getModel();
            IInterfaceElement targetModel = (IInterfaceElement)ep.getTarget().getModel();
            EObject eObject = sourceModel.eContainer().eContainer();
            if (eObject instanceof SubApp) {
                SubApp targetSub;
                SubApp sourceSub = (SubApp)eObject;
                EObject eObject2 = targetModel.eContainer().eContainer();
                if (eObject2 instanceof SubApp && sourceSub == (targetSub = (SubApp)eObject2)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private void resolveCollisions(Map<IFigure, Integer> positions) {
        ArrayList<Map.Entry<IFigure, Integer>> entryList = new ArrayList<Map.Entry<IFigure, Integer>>(positions.entrySet());
        entryList.sort(Comparator.comparing(Map.Entry::getValue));
        int i = 1;
        while (i < entryList.size()) {
            Map.Entry<IFigure, Integer> prevEntry = entryList.get(i - 1);
            Map.Entry<IFigure, Integer> currEntry = entryList.get(i);
            int prev = prevEntry.getValue();
            int curr = currEntry.getValue();
            int prevHeight = this.sizes.get(prevEntry.getKey());
            if (curr == Integer.MAX_VALUE) break;
            if (prev + prevHeight > curr) {
                int newPos = prev + prevHeight;
                positions.put(currEntry.getKey(), newPos);
            }
            ++i;
        }
    }
}

