/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.formatting2;

import java.util.Objects;
import org.eclipse.fordiac.ide.structuredtextcore.formatting2.FormatterUtil;
import org.eclipse.fordiac.ide.structuredtextcore.formatting2.STCoreFormatterPreferenceKeys;
import org.eclipse.xtext.formatting2.FormatterPreferenceKeys;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.internal.SinglelineCommentReplacer;
import org.eclipse.xtext.formatting2.internal.WhitespaceReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPart;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.preferences.TypedPreferenceKey;

public class STCoreSinglelineCommentReplacer
extends SinglelineCommentReplacer {
    protected STCoreSinglelineCommentReplacer(IComment comment, String prefix) {
        super(comment, prefix);
    }

    public void configureWhitespace(WhitespaceReplacer leading, WhitespaceReplacer trailing) {
        FormatterUtil.configureCommentWhitespace(leading.getFormatting(), trailing.getFormatting());
        leading.getFormatting().setSpace(" ");
    }

    public ITextReplacerContext createReplacements(ITextReplacerContext context) {
        String body;
        String stripped;
        String wrapped;
        String prefixed;
        String replacement;
        String lineSeparator = (String)context.getFormatter().getPreference((TypedPreferenceKey)FormatterPreferenceKeys.lineSeparator);
        Integer maxCommentWidth = (Integer)context.getFormatter().getPreference((TypedPreferenceKey)STCoreFormatterPreferenceKeys.maxCommentWidth);
        int consecutiveIndendationChars = Math.max(0, this.getConsecutiveIndendationChars(context));
        String consecutiveIndendation = " ".repeat(consecutiveIndendationChars);
        int lengthBeforeComment = context.getLeadingCharsInLineCount() + consecutiveIndendationChars;
        String indendationString = context.getIndentationString() + " ".repeat(Math.max(0, lengthBeforeComment - FormatterUtil.getIndendationChars(context)));
        int commentLineLength = maxCommentWidth - this.getPrefix().length() - 1;
        if (commentLineLength < 1) {
            return context;
        }
        String text = this.getComment().getText();
        if (!Objects.equals(text, replacement = consecutiveIndendation + (prefixed = FormatterUtil.prefixLines(wrapped = FormatterUtil.wrapLines(stripped = (body = text.substring(this.getPrefix().length())).strip(), commentLineLength, lineSeparator), indendationString + this.getPrefix(), lineSeparator)).strip() + lineSeparator)) {
            context.addReplacement(this.getComment().replaceWith(replacement));
        }
        return context;
    }

    protected int getConsecutiveIndendationChars(ITextReplacerContext context) {
        ITextReplacerContext first = this.getFirstSinglelineCommentReplacerContext(context);
        if (first != null && first.getReplacer() != this) {
            return first.getLeadingCharsInLineCount() - FormatterUtil.getIndendationChars(first);
        }
        return 0;
    }

    protected ITextReplacerContext getFirstSinglelineCommentReplacerContext(ITextReplacerContext context) {
        ITextReplacerContext result = null;
        while (this.isSameHiddenRegion(context)) {
            WhitespaceReplacer replacer;
            ITextReplacer iTextReplacer;
            if (context.getReplacer() instanceof SinglelineCommentReplacer) {
                result = context;
            }
            if ((iTextReplacer = context.getReplacer()) instanceof WhitespaceReplacer && (replacer = (WhitespaceReplacer)iTextReplacer).getRegion().isMultiline()) break;
            context = context.getPreviousContext();
        }
        return result;
    }

    protected boolean isSameHiddenRegion(ITextReplacerContext context) {
        IHiddenRegionPart part;
        ITextSegment iTextSegment;
        return context.getReplacer() != null && (iTextSegment = context.getReplacer().getRegion()) instanceof IHiddenRegionPart && (part = (IHiddenRegionPart)iTextSegment).getHiddenRegion() == this.getComment().getHiddenRegion();
    }
}

