/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.AbstractCachingDataLayer;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;

public class ColumnCachingDataLayer<T extends Enum<?>>
extends AbstractCachingDataLayer {
    private final List<T> columns;
    private final Set<T> cachedColumns;
    private final List<Object> placeholderValues;

    public ColumnCachingDataLayer(IDataProvider dataProvider, List<T> columns, Set<T> cachedColumns) {
        super(dataProvider);
        this.columns = columns;
        this.cachedColumns = cachedColumns;
        this.placeholderValues = new ArrayList<String>(Collections.nCopies(columns.size(), FordiacMessages.ComputingPlaceholderValue));
    }

    @SafeVarargs
    public ColumnCachingDataLayer(IDataProvider dataProvider, List<T> columns, T ... cachedColumns) {
        super(dataProvider);
        this.columns = columns;
        this.cachedColumns = Set.of(cachedColumns);
        this.placeholderValues = new ArrayList<String>(Collections.nCopies(columns.size(), FordiacMessages.ComputingPlaceholderValue));
    }

    public ColumnCachingDataLayer(IDataProvider dataProvider, int defaultColumnWidth, int defaultRowHeight, List<T> columns, Set<T> cachedColumns) {
        super(dataProvider, defaultColumnWidth, defaultRowHeight);
        this.columns = columns;
        this.cachedColumns = cachedColumns;
        this.placeholderValues = new ArrayList<String>(Collections.nCopies(columns.size(), FordiacMessages.ComputingPlaceholderValue));
    }

    @Override
    protected boolean isCachedValue(int columnIndex, int rowIndex) {
        return this.cachedColumns.contains(this.columns.get(columnIndex));
    }

    @Override
    protected Object getPlaceholderValue(int columnIndex, int rowIndex) {
        return this.placeholderValues.get(columnIndex);
    }

    public void setPlaceholderValue(int columnIndex, Object value) {
        this.placeholderValues.set(columnIndex, value);
    }

    public void setPlaceholderValues(Object value) {
        Collections.fill(this.placeholderValues, value);
    }
}

