/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.comments;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.elk.core.comments.IDataProvider;
import org.eclipse.elk.core.comments.IFilter;

public class TextPrefixFilter<C>
implements IFilter<C> {
    private Function<C, String> commentTextProvider = null;
    private List<String> prefixes = Lists.newArrayList();
    private boolean rejectCommentOnPrefixMatch = true;
    private boolean caseSensitive = false;

    public TextPrefixFilter<C> withCommentTextProvider(Function<C, String> f) {
        Objects.requireNonNull(f, "Comment text function cannot be null.");
        this.commentTextProvider = f;
        return this;
    }

    public TextPrefixFilter<C> withPrefixMatchRequiredForEligibility() {
        this.rejectCommentOnPrefixMatch = false;
        return this;
    }

    public TextPrefixFilter<C> withCaseSensitiveMatching() {
        this.caseSensitive = true;
        return this;
    }

    public TextPrefixFilter<C> addPrefix(String prefix) {
        if (Strings.isNullOrEmpty((String)prefix)) {
            throw new IllegalArgumentException("Prefix cannot be null or empty. Wouldn't make sense.");
        }
        this.prefixes.add(prefix);
        return this;
    }

    private void checkConfiguration() {
        if (this.commentTextProvider == null) {
            throw new IllegalStateException("A comment text provider is required.");
        }
        if (this.prefixes.isEmpty()) {
            throw new IllegalStateException("At least one prefix is required.");
        }
    }

    @Override
    public void preprocess(IDataProvider<C, ?> dataProvider, boolean includeHierarchy) {
        this.checkConfiguration();
    }

    @Override
    public boolean eligibleForAttachment(C comment) {
        String commentText = this.commentTextProvider.apply(comment);
        if (!Strings.isNullOrEmpty((String)commentText)) {
            for (String prefix : this.prefixes) {
                boolean startsWithPrefix;
                if (commentText.length() < prefix.length()) continue;
                String commentPrefix = commentText.substring(0, prefix.length());
                boolean bl = startsWithPrefix = this.caseSensitive ? commentPrefix.equals(prefix) : commentPrefix.equalsIgnoreCase(prefix);
                if (!startsWithPrefix) continue;
                return !this.rejectCommentOnPrefixMatch;
            }
        }
        return this.rejectCommentOnPrefixMatch;
    }
}

