/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.application.editors.NewInstanceDirectEditManager;
import org.eclipse.fordiac.ide.application.editparts.ErrorMarkerInterfaceEditPart;
import org.eclipse.fordiac.ide.application.editparts.HiddenPinIndicator;
import org.eclipse.fordiac.ide.application.editparts.HiddenPinIndicatorEditPart;
import org.eclipse.fordiac.ide.application.editparts.InstanceName;
import org.eclipse.fordiac.ide.application.editparts.InstanceNameEditPart;
import org.eclipse.fordiac.ide.application.figures.FBNetworkElementFigure;
import org.eclipse.fordiac.ide.application.policies.DeleteFBNElementEditPolicy;
import org.eclipse.fordiac.ide.application.policies.FBNElementSelectionPolicy;
import org.eclipse.fordiac.ide.gef.annotation.AnnotableGraphicalEditPart;
import org.eclipse.fordiac.ide.gef.annotation.FordiacAnnotationUtil;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModelEvent;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationStyles;
import org.eclipse.fordiac.ide.gef.editparts.AbstractPositionableElementEditPart;
import org.eclipse.fordiac.ide.gef.editparts.AbstractViewEditPart;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.gef.listeners.DiagramFontChangeListener;
import org.eclipse.fordiac.ide.gef.listeners.IFontUpdateListener;
import org.eclipse.fordiac.ide.gef.policies.DragHighlightEditPolicy;
import org.eclipse.fordiac.ide.model.commands.change.UpdateFBTypeCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.ColorizableElement;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.HiddenElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.fordiac.ide.ui.preferences.UIPreferenceConstants;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractFBNElementEditPart
extends AbstractPositionableElementEditPart
implements AnnotableGraphicalEditPart {
    private ColorizableElement referencedDevice;
    private DiagramFontChangeListener fontChangeListener;
    private Adapter interfaceAdapter;
    private final Adapter colorChangeListener = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            if (notification.getFeature() == LibraryElementPackage.eINSTANCE.getColorizableElement_Color()) {
                AbstractFBNElementEditPart.this.backgroundColorChanged((IFigure)AbstractFBNElementEditPart.this.getFigure());
            }
        }
    };
    private IPropertyChangeListener listener;
    private InstanceName instanceName;
    private HiddenPinIndicator inputPinIndicator;
    private HiddenPinIndicator outputPinIndicator;

    protected AbstractFBNElementEditPart() {
    }

    private Adapter getInterfaceAdapter() {
        if (this.interfaceAdapter == null) {
            this.interfaceAdapter = this.createInterfaceAdapter();
            Assert.isNotNull((Object)this.interfaceAdapter);
        }
        return this.interfaceAdapter;
    }

    protected Adapter createInterfaceAdapter() {
        return new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                if (!notification.isTouch()) {
                    Display.getDefault().execute(() -> {
                        AbstractFBNElementEditPart.this.refreshChildren();
                        AbstractFBNElementEditPart.this.getParent().refresh();
                    });
                }
            }
        };
    }

    public FBNetworkElementFigure getFigure() {
        return (FBNetworkElementFigure)super.getFigure();
    }

    protected Adapter createContentAdapter() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                AbstractFBNElementEditPart.this.refreshToolTip();
                if (notification.getFeature() == LibraryElementPackage.eINSTANCE.getFBNetworkElement_Mapping()) {
                    AbstractFBNElementEditPart.this.updateDeviceListener();
                }
            }
        };
    }

    protected void updateDeviceListener() {
        ColorizableElement device = this.findDevice();
        if (device != this.referencedDevice) {
            if (this.referencedDevice != null) {
                this.referencedDevice.eAdapters().remove((Object)this.colorChangeListener);
            }
            this.referencedDevice = device;
            if (this.referencedDevice != null) {
                this.referencedDevice.eAdapters().add((Object)this.colorChangeListener);
            }
            this.backgroundColorChanged((IFigure)this.getFigure());
        }
    }

    public void activate() {
        super.activate();
        this.updateDeviceListener();
        JFaceResources.getFontRegistry().addListener(this.getFontChangeListener());
        if (this.getColorChangeListener() != null) {
            JFaceResources.getColorRegistry().addListener(this.getColorChangeListener());
        }
        if (this.getModel() != null && !this.getModel().getInterface().eAdapters().contains((Object)this.getInterfaceAdapter())) {
            this.getModel().getInterface().eAdapters().add((Object)this.getInterfaceAdapter());
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.referencedDevice != null) {
            this.referencedDevice.eAdapters().remove((Object)this.colorChangeListener);
        }
        JFaceResources.getFontRegistry().removeListener(this.getFontChangeListener());
        if (this.getColorChangeListener() != null) {
            JFaceResources.getColorRegistry().removeListener(this.getColorChangeListener());
        }
        if (this.getModel() != null) {
            this.getModel().getInterface().eAdapters().remove((Object)this.getInterfaceAdapter());
        }
    }

    private IPropertyChangeListener getFontChangeListener() {
        if (this.fontChangeListener == null) {
            this.fontChangeListener = new DiagramFontChangeListener((IFontUpdateListener)this.getFigure());
        }
        return this.fontChangeListener;
    }

    public boolean isOnlyThisOrNothingSelected() {
        List selection = this.getViewer().getSelectedEditParts();
        if (selection.size() > 1) {
            return false;
        }
        if (selection.size() == 1) {
            return selection.get(0) == this;
        }
        return true;
    }

    protected void refreshToolTip() {
        this.getFigure().refreshToolTips();
    }

    protected void refreshComment() {
        this.refreshToolTip();
    }

    public <T> T getAdapter(Class<T> key) {
        if (key == FBNetworkElement.class) {
            return key.cast(this.getModel());
        }
        return (T)super.getAdapter(key);
    }

    public FBNetworkElement getModel() {
        return (FBNetworkElement)super.getModel();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeleteFBNElementEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new FBNElementSelectionPolicy());
        this.removeEditPolicy("DirectEditPolicy");
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new TypeDirectEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new DragHighlightEditPolicy());
    }

    public IPropertyChangeListener getColorChangeListener() {
        if (this.listener == null) {
            this.listener = event -> {
                if (event.getProperty().equals("org.eclipse.fordiac.ide.ui.EventConnectionConnectorColor") || UIPreferenceConstants.isDataConnectorProperty((String)event.getProperty()) || event.getProperty().equals("org.eclipse.fordiac.ide.ui.AdapterConnectionConnectorColor")) {
                    this.getFigure().repaint();
                }
            };
        }
        return this.listener;
    }

    protected void backgroundColorChanged(IFigure figure) {
        ColorizableElement dev;
        Color color = null;
        if (this.getModel() != null && (dev = this.findDevice()) != null) {
            color = LibraryElementFactory.eINSTANCE.createColor();
            color.setRed(dev.getColor().getRed());
            color.setGreen(dev.getColor().getGreen());
            color.setBlue(dev.getColor().getBlue());
        }
        this.setColor(figure, color);
    }

    protected ColorizableElement findDevice() {
        Resource res = null;
        if (this.getModel() != null && this.getModel().isMapped()) {
            res = this.getModel().getResource();
        }
        return res != null ? res.getDevice() : null;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (childEditPart instanceof InterfaceEditPart) {
            InterfaceEditPart interfaceEditPart = (InterfaceEditPart)childEditPart;
            this.getTargetFigure(interfaceEditPart).add(child, this.getInterfaceElementIndex(interfaceEditPart));
        } else if (childEditPart instanceof HiddenPinIndicatorEditPart) {
            HiddenPinIndicatorEditPart hiddenPinIndicatorEditPart = (HiddenPinIndicatorEditPart)childEditPart;
            this.addPinIndicatorFigure(hiddenPinIndicatorEditPart, child);
        } else {
            this.getFigure().add(child, new GridData(64), index);
        }
    }

    private void addPinIndicatorFigure(HiddenPinIndicatorEditPart indicatorEditPart, IFigure indicatorFigure) {
        if (((HiddenPinIndicator)indicatorEditPart.getModel()).isInput()) {
            this.getFigure().getPinIndicatorInput().add(indicatorFigure);
        } else {
            this.getFigure().getPinIndicatorOutput().add(indicatorFigure);
        }
    }

    private IFigure getTargetFigure(InterfaceEditPart interfaceEditPart) {
        if (interfaceEditPart.isInput()) {
            return this.getTargetInputFigure(interfaceEditPart);
        }
        return this.getTargetOutputFigure(interfaceEditPart);
    }

    private IFigure getTargetInputFigure(InterfaceEditPart interfaceEditPart) {
        if (interfaceEditPart.isEvent()) {
            return this.getFigure().getEventInputs();
        }
        if (interfaceEditPart.isAdapter()) {
            return this.getFigure().getSockets();
        }
        if (interfaceEditPart.isVariable()) {
            if (((VarDeclaration)interfaceEditPart.getModel()).isInOutVar()) {
                return this.getFigure().getVarInOutInputs();
            }
            return this.getFigure().getDataInputs();
        }
        if (interfaceEditPart instanceof ErrorMarkerInterfaceEditPart || interfaceEditPart.getModel() instanceof ErrorMarkerInterface) {
            return this.getFigure().getErrorMarkerInput();
        }
        return this.getFigure();
    }

    private IFigure getTargetOutputFigure(InterfaceEditPart interfaceEditPart) {
        if (interfaceEditPart.isEvent()) {
            return this.getFigure().getEventOutputs();
        }
        if (interfaceEditPart.isAdapter()) {
            return this.getFigure().getPlugs();
        }
        if (interfaceEditPart.isVariable()) {
            if (((VarDeclaration)interfaceEditPart.getModel()).isInOutVar()) {
                return this.getFigure().getVarInOutOutputs();
            }
            return this.getFigure().getDataOutputs();
        }
        if (interfaceEditPart instanceof ErrorMarkerInterfaceEditPart || interfaceEditPart.getModel() instanceof ErrorMarkerInterface) {
            return this.getFigure().getErrorMarkerOutput();
        }
        return this.getFigure();
    }

    private int getInterfaceElementIndex(InterfaceEditPart interfaceEditPart) {
        InterfaceList interfaceList = this.getModel().getInterface();
        if (interfaceEditPart.isInput()) {
            return AbstractFBNElementEditPart.getInterfaceInputElementIndex(interfaceEditPart, interfaceList);
        }
        return AbstractFBNElementEditPart.getInterfaceOutputElementIndex(interfaceEditPart, interfaceList);
    }

    private static int getInterfaceInputElementIndex(InterfaceEditPart interfaceEditPart, InterfaceList interfaceList) {
        if (interfaceEditPart.isEvent()) {
            return interfaceList.getEventInputs().indexOf((Object)interfaceEditPart.getModel());
        }
        if (interfaceEditPart.isAdapter()) {
            return interfaceList.getSockets().indexOf((Object)interfaceEditPart.getModel());
        }
        if (interfaceEditPart.isVariable()) {
            VarDeclaration varDecl = (VarDeclaration)interfaceEditPart.getModel();
            if (varDecl.isInOutVar()) {
                return interfaceList.getInOutVars().stream().filter(HiddenElement::isVisible).toList().indexOf(varDecl);
            }
            return interfaceList.getVisibleInputVars().indexOf(varDecl);
        }
        if (interfaceEditPart instanceof ErrorMarkerInterfaceEditPart) {
            return AbstractFBNElementEditPart.calcErrorMarkerINdex(interfaceEditPart, interfaceList);
        }
        return -1;
    }

    private static int getInterfaceOutputElementIndex(InterfaceEditPart interfaceEditPart, InterfaceList interfaceList) {
        if (interfaceEditPart.isEvent()) {
            return interfaceList.getEventOutputs().indexOf((Object)interfaceEditPart.getModel());
        }
        if (interfaceEditPart.isAdapter()) {
            return interfaceList.getPlugs().indexOf((Object)interfaceEditPart.getModel());
        }
        if (interfaceEditPart.isVariable()) {
            VarDeclaration varDecl = (VarDeclaration)interfaceEditPart.getModel();
            if (varDecl.isInOutVar()) {
                return interfaceList.getOutMappedInOutVars().stream().filter(HiddenElement::isVisible).toList().indexOf(varDecl);
            }
            return interfaceList.getVisibleOutputVars().indexOf(varDecl);
        }
        if (interfaceEditPart instanceof ErrorMarkerInterfaceEditPart) {
            return AbstractFBNElementEditPart.calcErrorMarkerINdex(interfaceEditPart, interfaceList);
        }
        return -1;
    }

    private static int calcErrorMarkerINdex(InterfaceEditPart interfaceEditPart, InterfaceList interfaceList) {
        int indexOf = interfaceList.getErrorMarker().indexOf((Object)interfaceEditPart.getModel());
        return indexOf - (int)interfaceList.getErrorMarker().subList(0, indexOf).stream().filter(e -> interfaceEditPart.isInput() ? !e.isIsInput() : e.isIsInput()).count();
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (childEditPart instanceof InterfaceEditPart) {
            InterfaceEditPart interfaceEditPart = (InterfaceEditPart)childEditPart;
            if (this.getTargetFigure(interfaceEditPart).getChildren().contains(child)) {
                this.getTargetFigure(interfaceEditPart).remove(child);
            } else {
                child.getParent().remove(child);
            }
        } else if (childEditPart instanceof HiddenPinIndicatorEditPart) {
            HiddenPinIndicatorEditPart hiddenPinIndicatorEditPart = (HiddenPinIndicatorEditPart)childEditPart;
            this.removePinIndicatorFigure(hiddenPinIndicatorEditPart, child);
        } else {
            super.removeChildVisual(childEditPart);
        }
    }

    private void removePinIndicatorFigure(HiddenPinIndicatorEditPart indicatorEditPart, IFigure indicatorFigure) {
        if (((HiddenPinIndicator)indicatorEditPart.getModel()).isInput()) {
            this.getFigure().getPinIndicatorInput().remove(indicatorFigure);
        } else {
            this.getFigure().getPinIndicatorOutput().remove(indicatorFigure);
        }
    }

    protected List<Object> getModelChildren() {
        ArrayList<Object> elements = new ArrayList<Object>();
        this.addBasicElements(elements);
        this.removeInvisibleInOutVars(elements);
        this.removeInvisibleInputOutputVars(elements);
        this.addPinIndicators(elements);
        return elements;
    }

    private void addBasicElements(List<Object> elements) {
        elements.add(this.getInstanceName());
        elements.addAll((Collection<Object>)this.getModel().getInterface().getAllInterfaceElements());
    }

    private void removeInvisibleInOutVars(List<Object> elements) {
        List<VarDeclaration> inoutInRemovalList = this.getModel().getInterface().getInOutVars().stream().filter(it -> !it.isVisible()).toList();
        List<VarDeclaration> inoutOutRemovalList = this.getModel().getInterface().getOutMappedInOutVars().stream().filter(it -> !it.isVisible()).toList();
        elements.removeAll(inoutInRemovalList);
        elements.removeAll(inoutOutRemovalList);
    }

    private void removeInvisibleInputOutputVars(List<Object> elements) {
        List<VarDeclaration> inputRemovalList = this.getModel().getInterface().getInputVars().stream().filter(it -> !it.isVisible()).toList();
        List<VarDeclaration> outputRemovalList = this.getModel().getInterface().getOutputVars().stream().filter(it -> !it.isVisible()).toList();
        elements.removeAll(inputRemovalList);
        elements.removeAll(outputRemovalList);
    }

    private void addPinIndicators(List<Object> elements) {
        boolean hasInvisibleInputs = !this.getModel().getInterface().getInputVars().stream().filter(it -> !it.isVisible()).toList().isEmpty() || !this.getModel().getInterface().getInOutVars().stream().filter(it -> !it.isVisible()).toList().isEmpty();
        boolean hasInvisibleOutputs = !this.getModel().getInterface().getOutputVars().stream().filter(it -> !it.isVisible()).toList().isEmpty() || !this.getModel().getInterface().getOutMappedInOutVars().stream().filter(it -> !it.isVisible()).toList().isEmpty();
        elements.addAll(this.getPinIndicators(hasInvisibleInputs, hasInvisibleOutputs));
    }

    protected List<Object> getPinIndicators(boolean input, boolean output) {
        ArrayList<Object> indicators = new ArrayList<Object>(2);
        if (input) {
            if (this.inputPinIndicator == null) {
                this.inputPinIndicator = new HiddenPinIndicator(this.getModel(), true);
            }
            indicators.add(this.inputPinIndicator);
        }
        if (output) {
            if (this.outputPinIndicator == null) {
                this.outputPinIndicator = new HiddenPinIndicator(this.getModel(), false);
            }
            indicators.add(this.outputPinIndicator);
        }
        return indicators;
    }

    protected InstanceName getInstanceName() {
        if (this.instanceName == null) {
            this.instanceName = new InstanceName(this.getModel());
        }
        return this.instanceName;
    }

    public INamedElement getINamedElement() {
        return this.getModel();
    }

    protected PositionableElement getPositionableElement() {
        return this.getModel();
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" || request.getType() == "open") {
            if (request.getType() == "open") {
                this.selectPropertySheet();
            }
            this.getChildren().stream().filter(InstanceNameEditPart.class::isInstance).forEach(e -> ((InstanceNameEditPart)((Object)e)).performRequest(request));
            return;
        }
        super.performRequest(request);
    }

    public void selectPropertySheet() {
        if (this.getViewer() != null) {
            this.getViewer().flush();
            EditorUtils.refreshPropertySheetWithSelection((IEditorPart)EditorUtils.getCurrentActiveEditor(), (EditPartViewer)this.getViewer(), (Object)((Object)this));
        }
    }

    public void performDirectEdit() {
        NewInstanceDirectEditManager directEditManager = this.createDirectEditManager();
        directEditManager.updateRefPosition(this.getRefPoint());
        directEditManager.show(this.getModel().getTypeName());
    }

    private org.eclipse.swt.graphics.Point getRefPoint() {
        Point typeLabelTopLeft = this.getFigure().getTypeLabel().getBounds().getTopLeft().scale(this.getZoomManager().getZoom());
        FigureCanvas viewerControl = (FigureCanvas)this.getViewer().getControl();
        Point location = viewerControl.getViewport().getViewLocation();
        return new org.eclipse.swt.graphics.Point(typeLabelTopLeft.x - location.x, typeLabelTopLeft.y - location.y);
    }

    private ZoomManager getZoomManager() {
        return ((ZoomScalableFreeformRootEditPart)this.getRoot()).getZoomManager();
    }

    public Label getNameLabel() {
        return null;
    }

    protected void refreshName() {
    }

    protected NewInstanceDirectEditManager createDirectEditManager() {
        return new NewInstanceDirectEditManager((GraphicalEditPart)this, this.getTypeLibrary(), true);
    }

    private TypeLibrary getTypeLibrary() {
        return TypeLibraryManager.INSTANCE.getTypeLibraryFromContext((EObject)this.getModel());
    }

    public void setTransparency(int value) {
        for (GraphicalEditPart ep : this.getChildren()) {
            if (!(ep instanceof AbstractViewEditPart)) continue;
            AbstractViewEditPart avep = (AbstractViewEditPart)ep;
            avep.setTransparency(value);
        }
        super.setTransparency(value);
    }

    public void updateAnnotations(GraphicalAnnotationModelEvent event) {
        GraphicalAnnotationStyles.updateAnnotationFeedback((IFigure)this.getFigure(), (Object)this.getModel(), (GraphicalAnnotationModelEvent)event, FordiacAnnotationUtil::showOnTarget);
        GraphicalAnnotationStyles.updateAnnotationFeedback((IFigure)this.getFigure().getTypeLabel(), (Object)this.getModel(), (GraphicalAnnotationModelEvent)event, FordiacAnnotationUtil::showOnTargetType);
        this.getChildren().stream().filter(InstanceNameEditPart.class::isInstance).map(InstanceNameEditPart.class::cast).forEach(child -> child.updateAnnotations(event));
    }

    protected static final class TypeDirectEditPolicy
    extends DirectEditPolicy {
        protected TypeDirectEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            Object value = request.getCellEditor().getValue();
            if (value instanceof TypeEntry) {
                TypeEntry te = (TypeEntry)value;
                return new UpdateFBTypeCommand(this.getHost().getModel(), te);
            }
            return null;
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
        }

        public AbstractFBNElementEditPart getHost() {
            return (AbstractFBNElementEditPart)super.getHost();
        }
    }
}

