/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.contracts.DefineContractDecisionDialog;
import org.eclipse.fordiac.ide.contracts.Messages;
import org.eclipse.fordiac.ide.contracts.PrepareContractCommand;
import org.eclipse.fordiac.ide.contracts.model.helpers.ContractUtils;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class DefineFbInterfaceConstraintHandler
extends AbstractHandler {
    public static final String DEFAULT_TIME = "10";
    private static final String DEFAULT_OFFSET = "0";
    private static final int CANCEL = -1;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ArrayList<Event> pins;
        List<Event> eventPins = DefineFbInterfaceConstraintHandler.getSelectedPins(event);
        ArrayList<Event> iPins = new ArrayList<Event>();
        ArrayList<Event> oPins = new ArrayList<Event>();
        for (Event pin : eventPins) {
            if (pin.isIsInput()) {
                iPins.add(pin);
                continue;
            }
            oPins.add(pin);
        }
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (iPins.size() == 0 && oPins.size() == 0) {
            MessageDialog.openError((Shell)shell, (String)Messages.NoPinSelectedErrorDialog_Title, (String)Messages.NoPinSelectedErrorDialog_Info);
            return Status.CANCEL_STATUS;
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> templates = new ArrayList<String>();
        ArrayList<Event> arrayList = pins = iPins.size() == 0 ? oPins : iPins;
        if (iPins.size() == 1 && oPins.size() == 1) {
            names.add(Messages.ContractRuleCausalReaction);
            templates.add(ContractUtils.createCausalReaction((Event)iPins.get(0), (Event)oPins.get(0), DEFAULT_TIME));
            names.add(Messages.ContractRuleCausalAge);
            templates.add(ContractUtils.createCausalAge((Event)iPins.get(0), (Event)oPins.get(0), DEFAULT_TIME));
        } else if (iPins.size() == 0 || oPins.size() == 0) {
            names.add(Messages.ContractRuleSingleEvent);
            templates.add(ContractUtils.createSingleEvent(pins, DEFAULT_TIME));
            names.add(Messages.ContractRuleRepetition);
            templates.add(ContractUtils.createRepetition(pins, DEFAULT_TIME, DEFAULT_OFFSET));
        }
        if (iPins.size() >= 1 && oPins.size() >= 1) {
            names.add(Messages.ContractRuleReaction);
            templates.add(ContractUtils.createReaction(iPins, oPins, DEFAULT_TIME));
            names.add(Messages.ContractRuleAge);
            templates.add(ContractUtils.createAge(iPins, oPins, DEFAULT_TIME));
        }
        names.add(Messages.ContractRuleEmpty);
        templates.add("// TODO");
        DefineContractDecisionDialog dialog = new DefineContractDecisionDialog(shell, names, templates);
        if (dialog.open() != -1) {
            FBNetworkElement fbElem = ((Event)pins.get(0)).getFBNetworkElement();
            IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            CommandStack cmdStack = (CommandStack)editor.getAdapter(CommandStack.class);
            cmdStack.execute((Command)new PrepareContractCommand(fbElem, iPins, oPins, dialog.getTemplate()));
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private static List<Event> getSelectedPins(ExecutionEvent event) {
        ArrayList<Event> pins = new ArrayList<Event>();
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object selected;
            Object obj = selected = iterator.next();
            if (selected instanceof EditPart) {
                EditPart selectedEP = (EditPart)selected;
                obj = selectedEP.getModel();
            }
            if (!(obj instanceof Event)) continue;
            Event eventPin = (Event)obj;
            pins.add(eventPin);
        }
        boolean sameFb = pins.stream().filter(ev -> ev.getFBNetworkElement() != null).allMatch(ev -> ev.getFBNetworkElement().equals(((Event)pins.get(0)).getFBNetworkElement()));
        if (sameFb) {
            return pins;
        }
        return Collections.emptyList();
    }
}

