/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.commands.Command;

public class EvaluateContractCommand
extends Command {
    private final SubApp subapp;
    private ChangeCommentCommand cccmd;

    EvaluateContractCommand(SubApp subapp) {
        if (subapp == null) {
            throw new IllegalArgumentException();
        }
        this.subapp = subapp;
    }

    public void execute() {
        if (this.subapp.getName().startsWith("_CONTRACT")) {
            String oldComment = this.subapp.getComment();
            int pos = oldComment.indexOf("ConstractState");
            if (pos == -1) {
                pos = oldComment.length();
            }
            StringBuilder comment = new StringBuilder();
            comment.append(oldComment.subSequence(0, pos));
            comment.append("ConstractState");
            if (this.evaluate(this.subapp)) {
                comment.append(" TRUE");
            } else {
                comment.append(" FALSE");
            }
            this.cccmd = new ChangeCommentCommand((INamedElement)this.subapp, comment.toString());
            if (this.cccmd.canExecute()) {
                this.cccmd.execute();
            }
        }
    }

    private boolean evaluate(SubApp subappToEvaluate) {
        FBNetwork fBNetwork = subappToEvaluate.getSubAppNetwork();
        EList fBNetworkElements = fBNetwork.getNetworkElements();
        BasicEList subApps = new BasicEList();
        for (FBNetworkElement element : fBNetworkElements) {
            if (element instanceof SubApp) {
                SubApp containedSubapp = (SubApp)element;
                EvaluateContractCommand eccmd = new EvaluateContractCommand(containedSubapp);
                if (eccmd.canExecute()) {
                    eccmd.execute();
                }
                if (!EvaluateContractCommand.hasValidContract(containedSubapp)) {
                    return false;
                }
                subApps.add((Object)containedSubapp);
            }
            if (!subApps.isEmpty()) continue;
            return EvaluateContractCommand.hasValidContract(this.subapp);
        }
        return this.evaluteContainedSubapps((EList<SubApp>)subApps);
    }

    private boolean evaluteContainedSubapps(EList<SubApp> subApps) {
        int[] times = new int[2];
        EvaluateContractCommand.extractAssumptionNumbers(times, this.subapp);
        for (SubApp containdSubApp : subApps) {
            int[] timesContained = new int[2];
            EvaluateContractCommand.extractAssumptionNumbers(timesContained, containdSubApp);
            if (times[0] < timesContained[0] || times[1] > timesContained[1]) {
                return false;
            }
            times[0] = timesContained[0];
            times[1] = timesContained[1];
            EvaluateContractCommand.extractGuaranteeNumbers(timesContained, containdSubApp);
            times[0] = times[0] + timesContained[0];
            times[1] = times[1] + timesContained[1];
        }
        int[] timesGuarantee = new int[2];
        EvaluateContractCommand.extractGuaranteeNumbers(timesGuarantee, this.subapp);
        return times[0] >= timesGuarantee[0] && times[1] <= timesGuarantee[1];
    }

    private static void extractGuaranteeNumbers(int[] times, SubApp source) {
        String[] parts = source.getComment().split("ms");
        parts = parts[1].split(" ");
        if ((parts = parts[parts.length - 1].split("ms")).length == 1) {
            times[1] = Integer.parseInt(parts[0]);
            times[0] = 0;
        }
        if (parts.length == 2) {
            String first = parts[0].substring(1);
            String second = parts[1].substring(0, parts[1].length() - 1);
            times[0] = Integer.parseInt(first);
            times[1] = Integer.parseInt(second);
        }
    }

    private static void extractAssumptionNumbers(int[] times, SubApp source) {
        String[] parts = source.getComment().split("ms");
        parts = parts[0].split(" ");
        if ((parts = parts[parts.length - 1].split(",")).length == 1) {
            times[1] = Integer.parseInt(parts[0]);
            times[0] = 0;
        }
        if (parts.length == 2) {
            String first = parts[0].substring(1);
            String second = parts[1].substring(0, parts[1].length() - 1);
            times[0] = Integer.parseInt(first);
            times[1] = Integer.parseInt(second);
        }
    }

    private static boolean hasValidContract(SubApp contract) {
        return contract.getComment().startsWith(" TRUE") || contract.getComment().startsWith("ASSUMPTION") && contract.getComment().contains("GUARANTEE");
    }

    public void undo() {
        this.cccmd.undo();
    }

    public void redo() {
        this.cccmd.redo();
    }
}

