/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts.model.helpers;

import java.util.List;
import org.eclipse.fordiac.ide.contracts.model.ContractElement;
import org.eclipse.fordiac.ide.contracts.model.helpers.ContractElementBuilder;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;

public final class ContractUtils {
    private ContractUtils() {
    }

    public static boolean isContractSubapp(FBNetworkElement element) {
        SubApp containedSubapp;
        return element instanceof SubApp && (containedSubapp = (SubApp)element).getName().startsWith("_CONTRACT");
    }

    public static boolean isInterval(String[] parts, int pos, CharSequence div) {
        return parts[pos].contains(div);
    }

    public static String createInterval(ContractElement source) {
        StringBuilder interval = new StringBuilder();
        interval.append("[");
        interval.append(source.getMin());
        interval.append(",");
        interval.append(source.getMax());
        interval.append("]");
        return interval.toString();
    }

    public static int getStartPosition(String[] parts, int posTime) {
        return parts[posTime].length() - "ms".length();
    }

    public static String createSingleEvent(List<Event> pins, String time) {
        ContractElementBuilder cb = new ContractElementBuilder();
        cb.addEventList(pins).addSpace().addOccurs().addWithin().add(time).addMs();
        return cb.getString();
    }

    public static String createRepetition(List<Event> pins, String time, String offset) {
        ContractElementBuilder cb = new ContractElementBuilder();
        cb.addEventList(pins).addSpace().addOccurs().addEvery().add(time).addMs();
        cb.addSpace().addWith().addOffet().add(offset).addMs();
        return cb.getString();
    }

    public static String createReaction(List<Event> iPins, List<Event> oPins, String time) {
        ContractElementBuilder cb = new ContractElementBuilder();
        cb.addWhenever().addEventExpr(iPins).addOccurs().addThen();
        cb.addEventExpr(oPins).addOccurs().addWithin().add(time).addMs();
        return cb.getString();
    }

    public static String createAge(List<Event> iPins, List<Event> oPins, String time) {
        ContractElementBuilder cb = new ContractElementBuilder();
        cb.addWhenever().addEventExpr(oPins).addOccurs().addThen();
        cb.addEventExpr(iPins).addHasOccurred().addWithin().add(time).addMs();
        return cb.getString();
    }

    public static String createCausalReaction(Event iPin, Event oPin, String time) {
        ContractElementBuilder cb = new ContractElementBuilder();
        cb.addReaction().addEOpen().add(iPin.getName()).addComma().add(oPin.getName()).addEClose();
        cb.addWithin().add(time).addMs();
        return cb.getString();
    }

    public static String createCausalAge(Event iPin, Event oPin, String time) {
        ContractElementBuilder cb = new ContractElementBuilder();
        cb.addAge().addEOpen().add(oPin.getName()).addComma().add(iPin.getName()).addEClose();
        cb.addWithin().add(time).addMs();
        return cb.getString();
    }

    public static String createAssumptionString(String event, String time) {
        ContractElementBuilder elementStr = new ContractElementBuilder();
        elementStr.addEventSpace(event).addOccurs().addEvery().addTime(time).addTimeUnit();
        return elementStr.getString();
    }

    public static String createOffsetString(String time) {
        ContractElementBuilder elementStr = new ContractElementBuilder();
        elementStr.addWith().addOffet().addTime(time).addTimeUnit();
        return elementStr.getString();
    }

    public static String createReactionString(String inputEvent, String outputEvent, String time) {
        ContractElementBuilder elementStr = new ContractElementBuilder();
        elementStr.addReaction().addEOpen().addEvent(inputEvent).addComma().addEvent(outputEvent).addEClose();
        elementStr.addWithin().addTime(time).addTimeUnit();
        return elementStr.getString();
    }

    public static String createGuaranteeString(String inputEvent, String outputEvent, String time) {
        ContractElementBuilder elementStr = new ContractElementBuilder();
        elementStr.addWhenever().addEventSpace(inputEvent).addOccurs();
        elementStr.addThen().addEventSpace(outputEvent).addOccurs().addWithin().addTime(time).addTimeUnit();
        return elementStr.getString();
    }

    public static String createGuaranteeTwoEvents(String inputEvent, String outputEvent, String secondOutputEvent, String time) {
        ContractElementBuilder elementStr = new ContractElementBuilder();
        elementStr.addWhenever().addEventSpace(inputEvent).addOccurs();
        elementStr.addThen().addEOpen().addEvent(outputEvent).addComma().addEvent(secondOutputEvent);
        elementStr.addEClose().addOccurs().addWithin().addTime(time).addTimeUnit();
        return elementStr.getString();
    }
}

