/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.utils;

import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.swt.graphics.Color;

public class ContractScanner
implements Iterable<Token> {
    public static final Color NORMAL = new Color(0, 0, 0);
    public static final Color KEYWORD = new Color(127, 0, 85);
    public static final Color COMMENT = new Color(63, 127, 95);
    private static final Set<String> KEYWORDS = Set.of("Age", "Clock", "FIFO", "ID", "LIFO", "Reaction", "and", "clock", "drift", "every", "has", "jitter", "maxdiff", "ms", "ns", "occurred", "occurs", "of", "offset", "once", "out", "resolution", "s", "skew", "then", "times", "us", "using", "whenever", "with", "within");
    private final StringReader reader;
    private final StringBuilder sb;
    private int ch;
    private TokenType tt;
    private boolean hasNext = true;

    public ContractScanner(String string) {
        this.reader = new StringReader(string);
        this.sb = new StringBuilder();
        this.nextChar();
    }

    @Override
    public Iterator<Token> iterator() {
        return new Iterator<Token>(){

            @Override
            public boolean hasNext() {
                return ContractScanner.this.hasNext;
            }

            @Override
            public Token next() {
                if (ContractScanner.this.ch == 47) {
                    ContractScanner.this.sb.append((char)ContractScanner.this.ch);
                    ContractScanner.this.nextChar();
                    if (ContractScanner.this.ch == 47) {
                        ContractScanner.this.readSingleLineComment();
                    } else if (ContractScanner.this.ch == 42) {
                        ContractScanner.this.readMultiLineComment();
                    } else {
                        ContractScanner.this.readOther();
                    }
                } else if (Character.isLetter((char)ContractScanner.this.ch)) {
                    ContractScanner.this.readWord();
                } else {
                    ContractScanner.this.readOther();
                }
                ContractScanner.this.readWhitespace();
                String tv = ContractScanner.this.sb.toString();
                ContractScanner.this.sb.setLength(0);
                return new Token(ContractScanner.this.tt, tv);
            }
        };
    }

    private void nextChar() {
        try {
            this.ch = this.reader.read();
            if (this.ch < 0) {
                this.hasNext = false;
            }
        }
        catch (IOException e) {
            this.ch = -1;
            this.hasNext = false;
        }
    }

    private void readWhitespace() {
        while (this.ch >= 0 && Character.isWhitespace((char)this.ch)) {
            this.sb.append((char)this.ch);
            this.nextChar();
        }
    }

    private void readWord() {
        while (this.ch >= 0 && Character.isLetterOrDigit((char)this.ch)) {
            this.sb.append((char)this.ch);
            this.nextChar();
        }
        String v = this.sb.toString();
        this.tt = KEYWORDS.contains(v) ? TokenType.KEYWORD : TokenType.NORMAL;
    }

    private void readOther() {
        while (this.ch >= 0 && !Character.isLetter((char)this.ch) && this.ch != 47) {
            this.sb.append((char)this.ch);
            this.nextChar();
        }
        this.tt = TokenType.NORMAL;
    }

    private void readSingleLineComment() {
        while (this.ch >= 0 && this.ch != 10) {
            this.sb.append((char)this.ch);
            this.nextChar();
        }
        this.tt = TokenType.COMMENT;
    }

    private void readMultiLineComment() {
        int prev = this.ch;
        while (prev >= 0 && this.ch >= 0 && (prev != 42 || this.ch != 47)) {
            this.sb.append((char)this.ch);
            prev = this.ch;
            this.nextChar();
        }
        this.sb.append((char)this.ch);
        this.nextChar();
        this.tt = TokenType.COMMENT;
    }

    public record Token(TokenType type, String value) {
    }

    public static enum TokenType {
        NORMAL,
        KEYWORD,
        COMMENT;

    }
}

