/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.iec61499.executors;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.fordiac.ide.application.commands.CreateSubAppCrossingConnectionsCommand;
import org.eclipse.fordiac.ide.application.commands.NewSubAppCommand;
import org.eclipse.fordiac.ide.deployment.IDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.data.FBDeploymentData;
import org.eclipse.fordiac.ide.deployment.devResponse.Connection;
import org.eclipse.fordiac.ide.deployment.devResponse.Response;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.iec61499.Messages;
import org.eclipse.fordiac.ide.deployment.iec61499.ResponseMapping;
import org.eclipse.fordiac.ide.deployment.iec61499.executors.DeploymentExecutor;
import org.eclipse.fordiac.ide.deployment.iec61499.handlers.QueryResponseHandler;
import org.eclipse.fordiac.ide.export.forte_lua.ForteLuaExportFilter;
import org.eclipse.fordiac.ide.model.Annotations;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStructCommand;
import org.eclipse.fordiac.ide.model.commands.create.FBCreateCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.systemconfiguration.commands.ResourceCreateCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Display;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DynamicTypeLoadDeploymentExecutor
extends DeploymentExecutor {
    private static final String CREATE_FB_TYPE = "<Request ID=\"{0}\" Action=\"CREATE\"><FBType Name=\"{1}\">{2}</FBType></Request>";
    private static final String CREATE_ADAPTER_TYPE = "<Request ID=\"{0}\" Action=\"CREATE\"><AdapterType Name=\"{1}\">{2}</AdapterType></Request>";
    private static final String QUERY_FB_TYPES = "<Request ID=\"{0}\" Action=\"QUERY\"><FBType Name=\"*\" /></Request>";
    private static final String QUERY_FB_TYPE = "<Request ID=\"{0}\" Action=\"QUERY\"><FBType Name=\"{1}\" /></Request>";
    private static final String QUERY_ADAPTER_TYPES = "<Request ID=\"{0}\" Action=\"QUERY\"><AdapterType Name=\"*\" /></Request>";
    private static final String QUERY_ADAPTER_TYPE = "<Request ID=\"{0}\" Action=\"QUERY\"><AdapterType Name=\"{1}\" /></Request>";
    private static final String QUERY_CONNECTIONS = "<Request ID=\"{0}\" Action=\"QUERY\"><Connection Source=\"{1}\" Destination=\"{2}\"/></Request>";
    private static final String QUERY_PARAMETER = "<Request ID=\"{0}\" Action=\"READ\"><Connection Source=\"{1}\" Destination=\"*\" /></Request>";
    private static final Logger logger = Logger.getLogger(DynamicTypeLoadDeploymentExecutor.class);
    private final ResponseMapping respMapping = new ResponseMapping();

    public DynamicTypeLoadDeploymentExecutor(Device dev, IDeviceManagementCommunicationHandler overrideHandler) {
        super(dev, overrideHandler);
    }

    public void connect() throws DeploymentException {
        super.connect();
        this.queryFBTypes();
        this.queryAdapterTypes();
    }

    @Override
    public void createFBInstance(FBDeploymentData fbData, Resource res) throws DeploymentException {
        Map<String, AdapterType> adapters = DynamicTypeLoadDeploymentExecutor.getAdapterTypes(fbData.getFb().getType().getInterfaceList());
        if (!adapters.isEmpty()) {
            this.createAdapterTypes(adapters);
        }
        this.checkCreateFBType(fbData.getFb().getType());
        super.createFBInstance(fbData, res);
    }

    private static Map<String, AdapterType> getAdapterTypes(InterfaceList interfaceList) {
        HashMap<String, AdapterType> list = new HashMap<String, AdapterType>();
        interfaceList.getPlugs().forEach(e -> {
            AdapterType adapterType = list.put(e.getTypeName(), (AdapterType)EcoreUtil.copy((EObject)e.getType()));
        });
        interfaceList.getSockets().forEach(e -> {
            AdapterType adapterType = list.put(e.getTypeName(), (AdapterType)EcoreUtil.copy((EObject)e.getType()));
        });
        return list;
    }

    private void checkCreateFBType(FBType fbType) {
        if (!this.getTypes().contains(fbType.getName())) {
            try {
                this.createFBType(fbType);
            }
            catch (DeploymentException ce) {
                logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_CreateTypeFailed, fbType.getName()), (Throwable)ce);
            }
        }
    }

    public void createFBType(FBType fbType) throws DeploymentException {
        DynamicTypeLoadDeploymentExecutor.setAttribute(this.getDevice(), "FBType", this.getTypes());
        if (fbType instanceof BasicFBType || fbType instanceof CompositeFBType) {
            if (fbType instanceof CompositeFBType) {
                this.createFBTypesOfCFB(fbType);
            }
            String request = this.createLuaXmlRequestMessage(fbType);
            this.sendCreateFBTypeREQ(fbType, request);
        }
    }

    private void sendCreateFBTypeREQ(FBType fbType, String request) throws DeploymentException {
        try {
            String result = this.sendREQ("", request);
            if (result.contains("Reason")) {
                throw new DeploymentException(MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_LUAScriptForFBTypeNotExecuted, fbType.getName()));
            }
            this.getTypes().add(fbType.getName());
        }
        catch (IOException e) {
            logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_CreateTypeFailed, "LUA script"), (Throwable)e);
        }
    }

    private void createFBTypesOfCFB(FBType fbType) throws DeploymentException {
        for (FBNetworkElement netelem : ((CompositeFBType)fbType).getFBNetwork().getNetworkElements()) {
            if (this.getTypes().contains(netelem.getTypeName())) continue;
            Map<String, AdapterType> adapters = DynamicTypeLoadDeploymentExecutor.getAdapterTypes(netelem.getInterface());
            if (!adapters.isEmpty()) {
                this.createAdapterTypes(adapters);
            }
            this.createFBType(netelem.getType());
        }
    }

    private String createLuaXmlRequestMessage(FBType fbType) {
        ForteLuaExportFilter luaFilter = new ForteLuaExportFilter();
        String escapedLuaScript = DynamicTypeLoadDeploymentExecutor.escapeXmlCharacters(luaFilter.createLUA((LibraryElement)fbType));
        return MessageFormat.format(CREATE_FB_TYPE, this.getNextId(), fbType.getName(), escapedLuaScript);
    }

    private static String escapeXmlCharacters(String luaScript) {
        luaScript = luaScript.replace("&", "&amp;");
        luaScript = luaScript.replace("<", "&lt;");
        luaScript = luaScript.replace(">", "&gt;");
        luaScript = luaScript.replace("\"", "&quot;");
        return luaScript.replace("'", "&apos;");
    }

    private static boolean isAttribute(Device device, String fbTypeName, String attributeType) {
        if (device.getAttribute(attributeType) != null) {
            String[] stringArray = device.getAttributeValue(attributeType).split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (fbTypeName.equals(s.trim())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static void setAttribute(Device device, String string, Set<String> hashSet) {
        Display.getDefault().asyncExec(() -> device.setAttribute(string, (DataType)IecTypes.ElementaryTypes.STRING, String.join((CharSequence)", ", hashSet), "created during deployment"));
    }

    public void createAdapterType(String adapterKey, Map<String, AdapterType> adapters) throws DeploymentException {
        DynamicTypeLoadDeploymentExecutor.setAttribute(this.getDevice(), "AdapterType", this.getAdapterTypes());
        if (!this.getAdapterTypes().contains(adapterKey) || !DynamicTypeLoadDeploymentExecutor.isAttribute(this.getDevice(), adapterKey, "AdapterType")) {
            ForteLuaExportFilter luaFilter = new ForteLuaExportFilter();
            String luaSkript = luaFilter.createLUA((LibraryElement)adapters.get(adapterKey));
            String request = MessageFormat.format(CREATE_ADAPTER_TYPE, this.getNextId(), adapterKey, luaSkript);
            this.sendCreateAdapterTypeREQ(adapterKey, request);
        }
    }

    private void sendCreateAdapterTypeREQ(String adapterKey, String request) throws DeploymentException {
        try {
            String result = this.sendREQ("", request);
            if (result.contains("Reason")) {
                throw new DeploymentException(MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_LUAScriptForAdapterTypeNotExecuted, adapterKey));
            }
            this.getAdapterTypes().add(adapterKey);
        }
        catch (IOException e) {
            logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_CreateTypeFailed, "Adapter"), (Throwable)e);
        }
    }

    public void queryResourcesWithNetwork(Device dev) {
        try {
            for (org.eclipse.fordiac.ide.deployment.devResponse.Resource resource : this.queryResources()) {
                ResourceCreateCommand cmd = new ResourceCreateCommand(DynamicTypeLoadDeploymentExecutor.getResourceType(dev, resource.getType()), dev, false);
                cmd.execute();
                cmd.getResource().setName(resource.getName());
                dev.getResource().add((Object)cmd.getResource());
                this.queryFBNetwork(cmd.getResource());
                this.queryConnections(cmd.getResource());
                this.queryParameters(cmd.getResource());
            }
        }
        catch (Exception e) {
            logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_QueryFailed, "Resources"), (Throwable)e);
        }
    }

    private void queryParameters(Resource res) {
        for (FBNetworkElement fb : res.getFBNetwork().getNetworkElements()) {
            for (VarDeclaration inVar : fb.getInterface().getInputVars()) {
                if (!inVar.getInputConnections().isEmpty()) continue;
                this.queryParameter(res, fb, inVar);
            }
        }
    }

    private void queryParameter(Resource res, FBNetworkElement fb, VarDeclaration inVar) {
        String request = MessageFormat.format(QUERY_PARAMETER, this.getNextId(), fb.getName() + "." + inVar.getName());
        try {
            String result = this.sendREQ(res.getName(), request);
            if (result != null) {
                DynamicTypeLoadDeploymentExecutor.createParameter(inVar, this.parseResponse(result));
            }
        }
        catch (Exception e) {
            logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_QueryFailed, "Parameter"), (Throwable)e);
        }
    }

    private static void createParameter(VarDeclaration inVar, Response response) {
        if (response.getConnection() != null) {
            Value value = LibraryElementFactory.eINSTANCE.createValue();
            value.setValue(response.getConnection().getDestination());
            inVar.setValue(value);
        }
    }

    private void queryConnections(Resource res) {
        String request = MessageFormat.format(QUERY_CONNECTIONS, this.getNextId(), "*", "*");
        try {
            String result = this.sendREQ(res.getName(), request);
            if (result != null) {
                DynamicTypeLoadDeploymentExecutor.createConnections(res, this.parseResponse(result));
            }
        }
        catch (Exception e) {
            logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_QueryFailed, "Connections"), (Throwable)e);
        }
    }

    private static void createConnections(Resource res, Response response) {
        if (response.getEndpointlist() != null) {
            for (Connection connection : response.getEndpointlist().getConnection()) {
                FB dstFB;
                FB srcFB;
                String[] src = connection.getSource().split("\\.");
                if (src.length > 2) {
                    SubApp srcSubapp = DynamicTypeLoadDeploymentExecutor.findSubAppOfFB(Arrays.asList(src).subList(0, src.length - 2).stream().collect(Collectors.joining(".")), res.getFBNetwork());
                    srcFB = srcSubapp.getSubAppNetwork().getFBNamed(src[src.length - 2]);
                } else {
                    srcFB = Annotations.getFBNamed((FBNetwork)res.getFBNetwork(), (String)src[0]);
                }
                IInterfaceElement srcIE = srcFB.getInterfaceElement(src[src.length - 1]);
                String[] dst = connection.getDestination().split("\\.");
                if (dst.length > 2) {
                    SubApp dstFBSubApp = DynamicTypeLoadDeploymentExecutor.findSubAppOfFB(Arrays.asList(dst).subList(0, dst.length - 2).stream().collect(Collectors.joining(".")), res.getFBNetwork());
                    dstFB = dstFBSubApp.getSubAppNetwork().getFBNamed(dst[dst.length - 2]);
                } else {
                    dstFB = Annotations.getFBNamed((FBNetwork)res.getFBNetwork(), (String)dst[0]);
                }
                IInterfaceElement dstIE = dstFB.getInterfaceElement(dst[dst.length - 1]);
                DynamicTypeLoadDeploymentExecutor.createConnectionCommand(res.getFBNetwork(), srcIE, dstIE);
            }
        }
    }

    private static void createConnectionCommand(FBNetwork fbNet, IInterfaceElement srcIE, IInterfaceElement dstIE) {
        Command cmd = CreateSubAppCrossingConnectionsCommand.createProcessBorderCrossingConnection((IInterfaceElement)srcIE, (IInterfaceElement)dstIE);
        if (cmd != null && cmd.canExecute()) {
            cmd.execute();
        }
    }

    private void queryFBNetwork(Resource res) {
        String request = MessageFormat.format("<Request ID=\"{0}\" Action=\"QUERY\"><FB Name=\"*\" Type=\"*\"/></Request>", this.getNextId());
        try {
            String result = this.sendREQ(res.getName(), request);
            if (result != null) {
                InputSource source = new InputSource(new StringReader(result));
                XMLResourceImpl xmlResource = new XMLResourceImpl();
                xmlResource.load(source, this.respMapping.getLoadOptions());
                this.createFBNetwork(res, (XMLResource)xmlResource);
            }
        }
        catch (Exception e) {
            logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_QueryFailed, "Networks"), (Throwable)e);
        }
    }

    private void createFBNetwork(Resource res, XMLResource xmlResource) {
        for (EObject object : xmlResource.getContents()) {
            if (!(object instanceof Response)) continue;
            this.createNotExistingAdapterTypes(res);
            this.addFBNetworkElements(res, (Response)object);
        }
    }

    private void createNotExistingAdapterTypes(Resource res) {
        for (String entryName : this.getAdapterTypes()) {
            if (res.getDevice().getAutomationSystem().getTypeLibrary().getAdapterTypeEntry(entryName) != null) continue;
            this.addTypeToTypelib(res, entryName, "adp", QUERY_ADAPTER_TYPE);
        }
    }

    private void addFBNetworkElements(Resource res, Response object) {
        int i = 0;
        for (org.eclipse.fordiac.ide.deployment.devResponse.FB fbresult : object.getFblist().getFbs()) {
            ChangeStructCommand changeStructCmd;
            FBCreateCommand fbcmd;
            if ("E_RESTART".equals(fbresult.getType())) continue;
            FBTypeEntry entry = res.getDevice().getAutomationSystem().getTypeLibrary().getFBTypeEntry(DynamicTypeLoadDeploymentExecutor.getPlainType(fbresult));
            if (entry == null) {
                this.addTypeToTypelib(res, fbresult.getType(), "FBT", QUERY_FB_TYPE);
                entry = res.getDevice().getAutomationSystem().getTypeLibrary().getFBTypeEntry(fbresult.getType());
            }
            if (fbresult.getName().contains(".")) {
                SubApp parent = DynamicTypeLoadDeploymentExecutor.findSubAppOfFB(fbresult.getName().substring(0, fbresult.getName().lastIndexOf(".")), res.getFBNetwork());
                fbcmd = new FBCreateCommand(entry, parent.getSubAppNetwork(), 10, 10);
            } else {
                fbcmd = new FBCreateCommand(entry, res.getFBNetwork(), 100 * i, 10);
            }
            if (fbcmd.canExecute()) {
                fbcmd.execute();
                if (fbresult.getName().contains(".")) {
                    fbcmd.getFB().setName(fbresult.getName().substring(fbresult.getName().lastIndexOf(".") + 1, fbresult.getName().length()));
                } else {
                    fbcmd.getFB().setName(fbresult.getName());
                }
            }
            if (fbcmd.getFB() instanceof StructManipulator && DynamicTypeLoadDeploymentExecutor.getStructFromMultiplexer(res, fbresult) != null && (changeStructCmd = new ChangeStructCommand((StructManipulator)fbcmd.getFB(), (DataType)DynamicTypeLoadDeploymentExecutor.getStructFromMultiplexer(res, fbresult))).canExecute()) {
                changeStructCmd.execute();
            }
            ++i;
        }
    }

    private static String getPlainType(org.eclipse.fordiac.ide.deployment.devResponse.FB fb) {
        if (fb.getType().contains("STRUCT_MUX")) {
            return "STRUCT_MUX";
        }
        if (fb.getType().contains("STRUCT_DEMUX")) {
            return "STRUCT_DEMUX";
        }
        return fb.getType();
    }

    private static StructuredType getStructFromMultiplexer(Resource res, org.eclipse.fordiac.ide.deployment.devResponse.FB devFB) {
        Matcher matcher = Pattern.compile("[^0-9]*([0-9]+).*").matcher(devFB.getType());
        if (matcher.matches()) {
            DataTypeLibrary library = res.getDevice().getAutomationSystem().getTypeLibrary().getDataTypeLibrary();
            return library.getStructuredType(devFB.getType().substring(devFB.getType().indexOf(matcher.group(1)) + 1));
        }
        return null;
    }

    private void addTypeToTypelib(Resource res, String typeName, String extension, String messageType) {
        String request = MessageFormat.format(messageType, this.getNextId(), typeName);
        try {
            String result = this.sendREQ(res.getName(), request);
            if (result != null) {
                result = result.replaceFirst("<Response ID=\"\\d+\">\n", "");
                if (!(result = result.replaceFirst("</Response>", "")).contains("Reason=\"UNSUPPORTED_TYPE\"") && !result.contains("Reason=\"UNSUPPORTED_CMD\"")) {
                    AutomationSystem system = res.getDevice().getAutomationSystem();
                    IFile sysFile = system.getTypeEntry().getFile();
                    Path path = Paths.get(String.valueOf(sysFile.getLocation()) + File.separator + "generated" + File.separator + typeName + "." + extension, new String[0]);
                    File file = new File(path.toString());
                    file.getParentFile().mkdirs();
                    Files.write(path, result.getBytes(), StandardOpenOption.CREATE);
                    TypeLibraryManager.INSTANCE.getTypeLibrary(sysFile.getProject()).refresh();
                }
            }
        }
        catch (Exception e) {
            if (messageType.equals(QUERY_ADAPTER_TYPE)) {
                logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_QueryFailed, "Adapter Type"), (Throwable)e);
            }
            logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_QueryFailed, "FB Type"), (Throwable)e);
        }
    }

    private static SubApp findSubAppOfFB(String path, FBNetwork network) {
        String[] paths = path.split("\\.");
        SubApp subapp = null;
        if (paths.length > 0) {
            subapp = network.getSubAppNamed(paths[0]);
            if (subapp == null) {
                subapp = DynamicTypeLoadDeploymentExecutor.createSubApp(network, paths[0]);
            }
            int i = 1;
            while (i < paths.length) {
                SubApp newSubapp = subapp.getSubAppNetwork().getSubAppNamed(paths[i]);
                subapp = newSubapp == null ? DynamicTypeLoadDeploymentExecutor.createSubApp(subapp.getSubAppNetwork(), paths[i]) : newSubapp;
                ++i;
            }
        }
        return subapp;
    }

    private static SubApp createSubApp(FBNetwork network, String name) {
        NewSubAppCommand subapp = new NewSubAppCommand(network, Collections.emptyList(), 10, 10);
        if (subapp.canExecute()) {
            subapp.execute();
            subapp.getElement().setName(name);
        }
        return subapp.getElement();
    }

    private static ResourceTypeEntry getResourceType(Device device, String resTypeName) {
        return device.getTypeEntry().getTypeLibrary().getResourceTypeEntry(resTypeName);
    }

    private void queryFBTypes() {
        String request = MessageFormat.format(QUERY_FB_TYPES, this.getNextId());
        try {
            QueryResponseHandler queryResp = this.sendQUERY("", request);
            this.setTypes(queryResp.getQueryResult());
        }
        catch (Exception e) {
            logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_QueryFailed, "FB Types"), (Throwable)e);
        }
    }

    private void queryAdapterTypes() {
        String request = MessageFormat.format(QUERY_ADAPTER_TYPES, this.getNextId());
        try {
            QueryResponseHandler queryResp = this.sendQUERY("", request);
            this.setAdapterTypes(queryResp.getQueryResult());
        }
        catch (Exception e) {
            logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_QueryFailed, "Adapter Types"), (Throwable)e);
        }
    }

    private void createAdapterTypes(Map<String, AdapterType> adapters) {
        adapters.keySet().forEach(e -> {
            try {
                this.createAdapterType((String)e, adapters);
            }
            catch (DeploymentException ce) {
                logger.error((Object)MessageFormat.format(Messages.DynamicTypeLoadDeploymentExecutor_CreateTypeFailed, e), (Throwable)ce);
            }
        });
    }

    private QueryResponseHandler sendQUERY(String destination, String request) throws IOException, ParserConfigurationException, SAXException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxParserFactory.newSAXParser();
        saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        QueryResponseHandler handler = new QueryResponseHandler();
        String response = this.sendREQ(destination, request);
        saxParser.parse(new InputSource(new StringReader(response)), (DefaultHandler)handler);
        return handler;
    }
}

