/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng.language;

import com.google.common.collect.Iterables;
import java.nio.file.Path;
import java.util.List;
import org.eclipse.fordiac.ide.export.forte_ng.ForteNgExportTemplate;
import org.eclipse.fordiac.ide.export.language.ILanguageSupport;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class LanguageImplTemplate
extends ForteNgExportTemplate {
    private final ILanguageSupport languageSupport;

    public LanguageImplTemplate(ILanguageSupport languageSupport, String name, Path prefix) {
        super(name, prefix);
        this.languageSupport = languageSupport;
    }

    public CharSequence generate() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateHeader = this.generateHeader();
        _builder.append((Object)_generateHeader);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateImplIncludes = this.generateImplIncludes();
        _builder.append((Object)_generateImplIncludes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateLanguage = this.generateLanguage();
        _builder.append((Object)_generateLanguage);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateLanguage() {
        try {
            StringConcatenation _builder = new StringConcatenation();
            CharSequence _generate = null;
            if (this.languageSupport != null) {
                _generate = this.languageSupport.generate(CollectionLiterals.emptyMap());
            }
            _builder.append(_generate);
            _builder.newLineIfNotEmpty();
            return _builder;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected CharSequence generateHeader() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*************************************************************************");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*** FORTE Language Element");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("***");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*** This file was generated using the 4DIAC FORTE Export Filter V1.0.x NG!");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("***");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*** Name: ");
        String _fileBasename = this.getFileBasename();
        _builder.append(_fileBasename, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*************************************************************************/");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateImplIncludes() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#include \"");
        String _fileBasename = this.getFileBasename();
        _builder.append(_fileBasename);
        _builder.append(".h\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#ifdef FORTE_ENABLE_GENERATED_SOURCE_CPP");
        _builder.newLine();
        _builder.append("#include \"");
        String _fileBasename_1 = this.getFileBasename();
        _builder.append(_fileBasename_1);
        _builder.append("_gen.cpp\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateDependencyInclude = this.generateDependencyInclude("core/iec61131_functions.h");
        _builder.append((Object)_generateDependencyInclude);
        _builder.newLineIfNotEmpty();
        if (this.languageSupport != null) {
            CharSequence _generateDependencyIncludes = this.generateDependencyIncludes(this.languageSupport.getDependencies(CollectionLiterals.emptyMap()));
            _builder.append((Object)_generateDependencyIncludes);
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public List<String> getErrors() {
        List _xifexpression = null;
        if (this.languageSupport != null) {
            List _errors = this.languageSupport.getErrors();
            _xifexpression = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)this.errors, (Iterable)_errors));
        } else {
            _xifexpression = this.errors;
        }
        return _xifexpression;
    }

    public List<String> getWarnings() {
        List _xifexpression = null;
        if (this.languageSupport != null) {
            List _warnings = this.languageSupport.getWarnings();
            _xifexpression = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)this.warnings, (Iterable)_warnings));
        } else {
            _xifexpression = this.warnings;
        }
        return _xifexpression;
    }

    public List<String> getInfos() {
        List _xifexpression = null;
        if (this.languageSupport != null) {
            List _infos = this.languageSupport.getInfos();
            _xifexpression = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)this.infos, (Iterable)_infos));
        } else {
            _xifexpression = this.infos;
        }
        return _xifexpression;
    }
}

