/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.export.ICompareEditorOpener;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public final class CompareEditorOpenerUtil {
    private CompareEditorOpenerUtil() {
    }

    public static Map<String, ICompareEditorOpener> getCompareEditorOpeners() {
        IConfigurationElement[] elems;
        HashMap<String, ICompareEditorOpener> openers = new HashMap<String, ICompareEditorOpener>(2);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.export.openCompareEditor");
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object object = element.createExecutableExtension("class");
                String name = element.getAttribute("name");
                if (object instanceof ICompareEditorOpener) {
                    ICompareEditorOpener compareEditorOpener = (ICompareEditorOpener)object;
                    openers.put(name, compareEditorOpener);
                }
            }
            catch (CoreException corex) {
                FordiacLogHelper.logError((String)"Error loading Compareeditor", (Throwable)corex);
            }
            ++n2;
        }
        return openers;
    }

    public static ICompareEditorOpener getOpener() {
        String compareEditor = Platform.getPreferencesService().getString("org.eclipse.fordiac.ide.export", "compareeditor", "", null);
        Map<String, ICompareEditorOpener> openers = CompareEditorOpenerUtil.getCompareEditorOpeners();
        ICompareEditorOpener opener = openers.get(compareEditor);
        if (opener == null && openers.size() >= 1) {
            opener = (ICompareEditorOpener)openers.values().toArray()[0];
        }
        return opener;
    }
}

