/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbrtlauncher;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.fordiac.ide.fbrtlauncher.Messages;
import org.eclipse.fordiac.ide.runtime.RuntimeLaunchTab;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.preferences.FixedScopedPreferenceStore;
import org.eclipse.fordiac.ide.ui.widget.FileChooserControl;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class FBRTLaunchTab
extends RuntimeLaunchTab {
    private static final String DEFAULT_FBRT_PORT = "61500";
    private static final String ATTR_FBRT_LOCATION = "org.eclipse.fordiac.ide.fbrtlauncher.location";
    private static final String ATTR_FBRT_DEV_TYPE = "org.eclipse.fordiac.ide.fbrtlauncher.deviceType";
    private static final String ATTR_FBRT_LIB = "org.eclipse.fordiac.ide.fbrtlauncher.lib";
    private static final String ATTR_FBRT_PORT = "org.eclipse.fordiac.ide.fbrtlauncher.port";
    private static final String[] FBRT_DEV_TYPES = new String[]{"RMT_FRAME", "RMT_DEV"};
    private static final String DEFAULT_FBRT_DEV_TYPE = FBRT_DEV_TYPES[0];
    private FileChooserControl fbrtChooser;
    private Text library;
    private Combo devType;

    public void createControl(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)parent);
        Composite comp = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(comp);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)comp);
        this.setControl((Control)comp);
        this.fbrtChooser = new FileChooserControl(comp, 0, Messages.FBRTPreferencePage_FBRTLocation, true);
        this.fbrtChooser.addChooserValueChangedListener(newVal -> this.scheduleUpdateJob());
        this.createLibrary(comp);
        this.createDevType(comp);
        this.createPortSelection(comp);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", FBRTLaunchTab.getJavaRte());
        FixedScopedPreferenceStore store = new FixedScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.fordiac.ide.fbrtlauncher");
        String fbrtPath = store.getString("pathPreference");
        configuration.setAttribute(ATTR_FBRT_LOCATION, fbrtPath != null && !fbrtPath.isBlank() ? fbrtPath : "");
        configuration.setAttribute(ATTR_FBRT_LIB, store.getString("libPreference"));
        configuration.setAttribute(ATTR_FBRT_DEV_TYPE, DEFAULT_FBRT_DEV_TYPE);
        configuration.setAttribute(ATTR_FBRT_PORT, DEFAULT_FBRT_PORT);
        FBRTLaunchTab.updateLaunchArguments(configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fbrtChooser.setValue(configuration.getAttribute(ATTR_FBRT_LOCATION, ""));
            this.library.setText(configuration.getAttribute(ATTR_FBRT_LIB, ""));
            this.devType.select(FBRTLaunchTab.getSelectedDevTypeIndex(configuration.getAttribute(ATTR_FBRT_DEV_TYPE, DEFAULT_FBRT_DEV_TYPE)));
            this.setPortValue(configuration.getAttribute(ATTR_FBRT_PORT, DEFAULT_FBRT_PORT));
        }
        catch (CoreException e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)((Object)e));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(ATTR_FBRT_LOCATION, this.fbrtChooser.getValue());
        configuration.setAttribute(ATTR_FBRT_LIB, this.library.getText());
        configuration.setAttribute(ATTR_FBRT_DEV_TYPE, FBRT_DEV_TYPES[this.devType.getSelectionIndex()]);
        configuration.setAttribute(ATTR_FBRT_PORT, this.getPortValue());
        FBRTLaunchTab.updateLaunchArguments(configuration);
    }

    public String getName() {
        return Messages.FBRTLaunchTab_TabName;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (!super.isValid(launchConfig)) {
            return false;
        }
        if (this.fbrtChooser.getValue().isBlank()) {
            this.setErrorMessage(Messages.FBRTLaunchTab_NoFBRTJarSet);
            return false;
        }
        return true;
    }

    private void createLibrary(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.FBRTPreferencePage_FBRTLibrary);
        this.library = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 2).applyTo((Control)this.library);
        this.library.addModifyListener(ev -> this.scheduleUpdateJob());
    }

    private void createDevType(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.FBRTLaunchTab_DeviceType);
        this.devType = new Combo(parent, 2056);
        Arrays.stream(FBRT_DEV_TYPES).forEach(arg_0 -> ((Combo)this.devType).add(arg_0));
        GridDataFactory.fillDefaults().align(1, 2).applyTo((Control)this.devType);
        this.devType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FBRTLaunchTab.this.scheduleUpdateJob();
            }
        });
    }

    private static String getJavaRte() {
        Object javaRte = System.getProperty("java.home");
        if (((String)javaRte).isEmpty()) {
            return "";
        }
        javaRte = (String)javaRte + File.separatorChar + "bin" + File.separatorChar + "java";
        if (Platform.getOS().equalsIgnoreCase("win32")) {
            javaRte = (String)javaRte + ".exe";
        }
        return javaRte;
    }

    private static void updateLaunchArguments(ILaunchConfigurationWorkingCopy configuration) {
        try {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", FBRTLaunchTab.getJavaRte());
            File runtimeFile = FBRTLaunchTab.getRuntimeFile(configuration);
            String portNum = configuration.getAttribute(ATTR_FBRT_PORT, DEFAULT_FBRT_PORT);
            String devType = configuration.getAttribute(ATTR_FBRT_DEV_TYPE, DEFAULT_FBRT_DEV_TYPE);
            Object fbrtPath = "fb.rt.";
            if (FBRT_DEV_TYPES[0].equalsIgnoreCase(devType)) {
                fbrtPath = (String)fbrtPath + "hmi.";
            }
            String arguments = "-noverify -classpath ./lib" + File.pathSeparatorChar + "./" + runtimeFile.getName() + File.pathSeparatorChar + " " + (String)fbrtPath + devType + " -n " + devType + " -s " + portNum + " -p " + configuration.getAttribute(ATTR_FBRT_LIB, "");
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", arguments);
            File parentFile = runtimeFile.getParentFile();
            if (parentFile != null) {
                configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", parentFile.getPath());
            }
        }
        catch (CoreException e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)((Object)e));
        }
    }

    private static int getSelectedDevTypeIndex(String devType) {
        int i = 0;
        while (i < FBRT_DEV_TYPES.length) {
            if (FBRT_DEV_TYPES[i].equals(devType)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private static File getRuntimeFile(ILaunchConfigurationWorkingCopy configuration) throws CoreException {
        return new File(configuration.getAttribute(ATTR_FBRT_LOCATION, ""));
    }
}

