/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editors;

import java.util.function.Consumer;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.gef.editors.XtextEmbeddedFieldEditor;
import org.eclipse.fordiac.ide.model.commands.change.ChangeValueCommand;
import org.eclipse.fordiac.ide.model.edit.helper.InitialValueHelper;
import org.eclipse.fordiac.ide.model.edit.helper.InitialValueRefreshJob;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextalgorithm.ui.editor.embedded.STAlgorithmEmbeddedEditorUtil;
import org.eclipse.fordiac.ide.structuredtextalgorithm.ui.editor.embedded.STAlgorithmInitialValueEditedResourceProvider;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceStoreProvider;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;

public class InitialValueEditor
extends XtextEmbeddedFieldEditor {
    private IInterfaceElement interfaceElement;
    private final InitialValueRefreshJob refreshJob = new InitialValueRefreshJob(null, this::updateInitialValue);

    public InitialValueEditor(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void createControl(Composite parent, int style) {
        super.createControl(parent, style);
        XtextSourceViewer viewer = this.getEmbeddedEditor().getViewer();
        viewer.addTextPresentationListener(textPresentation -> {
            if (!viewer.getUndoManager().undoable() && !InitialValueHelper.hasInitalValue((Object)this.interfaceElement)) {
                textPresentation.replaceStyleRange(new StyleRange(textPresentation.getExtent().getOffset(), textPresentation.getExtent().getLength(), InitialValueHelper.getForegroundColor((Object)this.interfaceElement), this.getControl().getBackground()));
            }
        });
        viewer.getControl().addDisposeListener(event -> {
            boolean bl = this.refreshJob.cancel();
        });
    }

    @Override
    protected IEditedResourceProvider createEditedResourceProvider() {
        return new STAlgorithmInitialValueEditedResourceProvider(null);
    }

    @Override
    public void commit() {
        IInterfaceElement iInterfaceElement = this.interfaceElement;
        if (iInterfaceElement instanceof VarDeclaration) {
            VarDeclaration varDeclaration = (VarDeclaration)iInterfaceElement;
            this.executeCommand((Command)new ChangeValueCommand(varDeclaration, this.getModelAccess().getEditablePart()));
        }
        this.refresh();
    }

    @Override
    public void refresh() {
        this.refreshJob.cancel();
        Consumer<Command> commandExecutorCache = this.getCommandExecutor();
        this.setCommandExecutor(null);
        STAlgorithmEmbeddedEditorUtil.updateEditor((EmbeddedEditor)this.getEmbeddedEditor(), (INamedElement)this.interfaceElement);
        this.getModelAccess().updateModel(FordiacMessages.ComputingPlaceholderValue);
        this.getControl().setSelection(0);
        this.setCommandExecutor(commandExecutorCache);
        this.refreshJob.schedule();
    }

    /*
     * Unable to fully structure code
     */
    protected void updateInitialValue(String value) {
        block2: {
            if (this.getControl().isDisposed() || !FordiacMessages.ComputingPlaceholderValue.equals(this.getModelAccess().getEditablePart())) break block2;
            commandExecutorCache = this.getCommandExecutor();
            this.setCommandExecutor(null);
            var4_3 = EcoreUtil.getRootContainer((EObject)this.getInterfaceElement());
            if (!(var4_3 instanceof LibraryElement)) ** GOTO lbl-1000
            libElem = (LibraryElement)var4_3;
            if (value.length() <= PreferenceStoreProvider.getStore((String)"org.eclipse.fordiac.ide.gef", (IProject)libElem.getTypeLibrary().getProject()).getInt("MaxDefaultValueLength")) {
                this.getModelAccess().updateModel(value);
            } else lbl-1000:
            // 2 sources

            {
                this.getModelAccess().updateModel(FordiacMessages.ValueTooLarge);
            }
            this.getControl().setSelection(0);
            this.setCommandExecutor(commandExecutorCache);
        }
    }

    public IInterfaceElement getInterfaceElement() {
        return this.interfaceElement;
    }

    public void setInterfaceElement(IInterfaceElement interfaceElement) {
        this.interfaceElement = interfaceElement;
        this.refreshJob.setInterfaceElement(interfaceElement);
    }
}

