/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.widgets;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.gef.annotation.TextualAnnotationStyles;
import org.eclipse.fordiac.ide.gef.editparts.ImportCellEditor;
import org.eclipse.fordiac.ide.gef.provider.PackageContentProvider;
import org.eclipse.fordiac.ide.gef.provider.PackageLabelProvider;
import org.eclipse.fordiac.ide.gef.widgets.TypeInfoWidget;
import org.eclipse.fordiac.ide.model.commands.change.ChangeImportNamespaceCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangePackageNameCommand;
import org.eclipse.fordiac.ide.model.commands.create.AddNewImportCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteImportCommand;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.GlobalConstants;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.ui.widgets.PackageSelectionProposalProvider;
import org.eclipse.fordiac.ide.typemanagement.commands.OrganizeImportsCommand;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteWidget;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.StyledTextContentAdapter;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PackageInfoWidget
extends TypeInfoWidget {
    private final Supplier<GraphicalAnnotationModel> annotationModelSupplier;
    private TableViewer packageViewer;
    private StyledText nameText;
    private ContentProposalAdapter nameTextProposalAdapter;
    private AddDeleteWidget buttons;
    private Button organizeImportsButton;
    Composite composite;

    public PackageInfoWidget(FormToolkit widgetFactory, Supplier<GraphicalAnnotationModel> annotationModelSupplier) {
        super(widgetFactory);
        this.annotationModelSupplier = annotationModelSupplier;
    }

    @Override
    public void createControls(Composite leftComposite, Composite rightComposite) {
        super.createControls(leftComposite, rightComposite);
        this.createPackageInfoGroup(rightComposite);
    }

    private void createPackageInfoGroup(Composite parent) {
        Group packageGroup = this.createGroup(parent, FordiacMessages.Package);
        packageGroup.setLayout((Layout)new GridLayout(1, false));
        packageGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.composite = this.getWidgetFactory().createComposite((Composite)packageGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(0, 0).applyTo(this.composite);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.getWidgetFactory().createLabel(this.composite, FordiacMessages.Name + ":");
        this.nameText = this.createGroupStyledText(this.composite, true);
        this.nameText.addModifyListener(e -> {
            if (!this.blockListeners) {
                this.executeCommand((Command)new ChangePackageNameCommand(this.getType(), this.nameText.getText()));
            }
        });
        this.nameTextProposalAdapter = new ContentAssistCommandAdapter((Control)this.nameText, (IControlContentAdapter)new StyledTextContentAdapter(), (IContentProposalProvider)new PackageSelectionProposalProvider(this::getTypeLibrary), null, null, true);
        this.nameTextProposalAdapter.setProposalAcceptanceStyle(2);
        Label importsLabel = new Label((Composite)packageGroup, 0);
        importsLabel.setText(FordiacMessages.Imports + ":");
        importsLabel.setBackground(Display.getDefault().getSystemColor(37));
        Composite compositeBottom = this.getWidgetFactory().createComposite((Composite)packageGroup);
        compositeBottom.setLayout((Layout)new GridLayout(2, false));
        compositeBottom.setLayoutData((Object)new GridData(4, 4, true, true));
        this.buttons = new AddDeleteWidget();
        this.buttons.createControls(compositeBottom, this.getWidgetFactory());
        this.organizeImportsButton = this.getWidgetFactory().createButton(this.buttons.getControl(), "", 8);
        this.organizeImportsButton.setToolTipText(FordiacMessages.PackageInfoWidget_OrganizeImports);
        this.organizeImportsButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_SYNCED"));
        this.organizeImportsButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.organizeImportsButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(ev -> {
            this.executeCommand((Command)new OrganizeImportsCommand(this.getType()));
            this.packageViewer.refresh();
        }));
        Composite tableComposite = new Composite(compositeBottom, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.packageViewer = TableWidgetFactory.createPropertyTableViewer((Composite)tableComposite);
        this.configureImportsTableLayout(this.packageViewer, tableComposite);
        this.packageViewer.setContentProvider((IContentProvider)new PackageContentProvider());
        this.buttons.bindToTableViewer(this.packageViewer, (CommandExecutor)this, ref -> new AddNewImportCommand(this.getType()), ref -> new DeleteImportCommand(this.getType().getCompilerInfo(), (Import)ref));
    }

    private void configureImportsTableLayout(TableViewer viewer, Composite parentComposite) {
        TableViewerColumn nameColumn = new TableViewerColumn(viewer, 4);
        nameColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new PackageLabelProvider(this.annotationModelSupplier)));
        nameColumn.setEditingSupport((EditingSupport)new ImportsEditingSupport(viewer, this::getTypeLibrary, this));
        TableColumn nameTableColumn = nameColumn.getColumn();
        nameTableColumn.setText(FordiacMessages.Name);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)nameTableColumn, (ColumnLayoutData)new ColumnWeightData(100, true));
        parentComposite.setLayout((Layout)tableLayout);
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.packageViewer != null && !this.packageViewer.getControl().isDisposed()) {
            Consumer<Command> commandExecutorBuffer = this.getCommandExecutor();
            this.setCommandExecutor(null);
            if (this.getType() != null) {
                this.nameText.setEditable(!this.isReadonly());
                this.nameText.setEnabled(!this.isReadonly());
                this.nameTextProposalAdapter.refresh();
                this.buttons.setEnabled(!this.isReadonly());
                this.organizeImportsButton.setEnabled(!this.isReadonly());
                this.packageViewer.getTable().setEnabled(!this.isReadonly());
                this.packageViewer.setInput((Object)this.getType());
                this.refreshAnnotations();
            }
            this.setCommandExecutor(commandExecutorBuffer);
        }
    }

    public void refreshAnnotations() {
        Consumer<Command> commandExecutorBuffer = this.getCommandExecutor();
        this.setCommandExecutor(null);
        GraphicalAnnotationModel annotationModel = this.annotationModelSupplier.get();
        CompilerInfo compilerInfo = this.getType().getCompilerInfo();
        StyledString nameStyledString = new StyledString(PackageNameHelper.getPackageName((LibraryElement)this.getType()), annotationModel != null && compilerInfo != null ? TextualAnnotationStyles.getAnnotationStyle(annotationModel.getAnnotations(compilerInfo)) : null);
        if (this.nameText != null && !this.nameText.isDisposed()) {
            int caretOffset = this.nameText.getCaretOffset();
            Point nameTextSelection = this.nameText.getSelection();
            this.nameText.setText(nameStyledString.toString());
            this.nameText.setStyleRanges(nameStyledString.getStyleRanges());
            this.nameText.setSelection(nameTextSelection);
            this.nameText.setCaretOffset(caretOffset);
        }
        if (this.packageViewer != null && !this.packageViewer.getControl().isDisposed()) {
            this.packageViewer.refresh();
        }
        this.setCommandExecutor(commandExecutorBuffer);
    }

    @Override
    public void setEnabled(boolean enablement) {
        super.setEnabled(enablement);
        this.nameText.setEnabled(enablement);
        this.nameTextProposalAdapter.setEnabled(enablement);
        this.buttons.setVisible(enablement);
        this.packageViewer.getTable().setEnabled(enablement);
        this.packageViewer.setCellModifier(null);
    }

    private boolean isReadonly() {
        return this.getType() instanceof FunctionFBType || this.getType() instanceof GlobalConstants;
    }

    protected TypeLibrary getTypeLibrary() {
        LibraryElement type = this.getType();
        if (type != null) {
            return this.getType().getTypeLibrary();
        }
        return null;
    }

    private StyledText createGroupStyledText(Composite group, boolean editable) {
        StyledText text = new StyledText(group, 0x804 | this.getWidgetFactory().getOrientation());
        this.getWidgetFactory().adapt((Control)text, true, false);
        text.setLayoutData((Object)new GridData(4, 0, true, false));
        text.setEditable(editable);
        text.setEnabled(editable);
        return text;
    }

    protected static class ImportsEditingSupport
    extends EditingSupport {
        private final CellEditor cellEditor;
        private final CommandExecutor commandExecutor;

        public ImportsEditingSupport(TableViewer viewer, Supplier<TypeLibrary> supplier, CommandExecutor commandExecutor) {
            super((ColumnViewer)viewer);
            this.commandExecutor = commandExecutor;
            this.cellEditor = new ImportCellEditor((Composite)viewer.getTable(), supplier);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected boolean canEdit(Object element) {
            return element instanceof Import;
        }

        protected Object getValue(Object element) {
            String string;
            if (element instanceof Import) {
                Import imp = (Import)element;
                string = imp.getImportedNamespace();
            } else {
                string = null;
            }
            return string;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof Import) {
                Import imp = (Import)element;
                if (value instanceof String) {
                    String importedNamespace = (String)value;
                    this.commandExecutor.executeCommand((Command)new ChangeImportNamespaceCommand(imp, importedNamespace));
                    this.getViewer().refresh(element);
                }
            }
        }
    }
}

