/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStructCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableMoveFB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.validation.LinkConstraints;

public class StructDataConnectionCreateCommand
extends DataConnectionCreateCommand {
    private ChangeStructCommand changeStructCommand;

    public StructDataConnectionCreateCommand(FBNetwork parent) {
        super(parent);
    }

    @Override
    protected boolean canExecuteConType() {
        IInterfaceElement source = this.getSource();
        IInterfaceElement target = this.getDestination();
        if (StructDataConnectionCreateCommand.isStructPin(source) && StructDataConnectionCreateCommand.isStructPin(target)) {
            return LinkConstraints.canExistDataConnection((IInterfaceElement)this.getSource(), (IInterfaceElement)this.getDestination(), (FBNetwork)this.getParent(), null);
        }
        return false;
    }

    public boolean canRedo() {
        return true;
    }

    @Override
    public void execute() {
        IInterfaceElement target;
        IInterfaceElement source = this.getSource();
        if (StructDataConnectionCreateCommand.shouldChangeStruct(source, target = this.getDestination())) {
            DataType dataType;
            DataType dataType2;
            if (StructDataConnectionCreateCommand.isUnconfiguredStructManipulatorDefPin(source) && (dataType2 = target.getType()) instanceof StructuredType) {
                ChangeStructCommand changeStructCommand;
                StructuredType targetVar = (StructuredType)dataType2;
                FBNetworkElement fBNetworkElement = source.getFBNetworkElement();
                if (fBNetworkElement instanceof ConfigurableMoveFB) {
                    ConfigurableMoveFB cmfb = (ConfigurableMoveFB)fBNetworkElement;
                    changeStructCommand = new ChangeStructCommand((FBNetworkElement)cmfb, (DataType)targetVar);
                } else {
                    changeStructCommand = new ChangeStructCommand((StructManipulator)source.getFBNetworkElement(), (DataType)targetVar);
                }
                this.changeStructCommand = changeStructCommand;
                this.changeStructCommand.execute();
                if (source.getFBNetworkElement() instanceof ConfigurableMoveFB) {
                    this.setSource(this.changeStructCommand.getNewElement().getInterfaceElement(this.getSource().getName()));
                } else {
                    this.setSource(this.changeStructCommand.getNewMux().getInterfaceElement(this.getSource().getName()));
                }
            } else if (StructDataConnectionCreateCommand.isUnconfiguredStructManipulatorDefPin(target) && (dataType = source.getType()) instanceof StructuredType) {
                ChangeStructCommand changeStructCommand;
                StructuredType sourceVar = (StructuredType)dataType;
                FBNetworkElement fBNetworkElement = target.getFBNetworkElement();
                if (fBNetworkElement instanceof ConfigurableMoveFB) {
                    ConfigurableMoveFB cmfb = (ConfigurableMoveFB)fBNetworkElement;
                    changeStructCommand = new ChangeStructCommand((FBNetworkElement)cmfb, (DataType)sourceVar);
                } else {
                    changeStructCommand = new ChangeStructCommand((StructManipulator)target.getFBNetworkElement(), (DataType)sourceVar);
                }
                this.changeStructCommand = changeStructCommand;
                this.changeStructCommand.execute();
                if (target.getFBNetworkElement() instanceof ConfigurableMoveFB) {
                    this.setDestination(this.changeStructCommand.getNewElement().getInterfaceElement(this.getDestination().getName()));
                } else {
                    this.setDestination(this.changeStructCommand.getNewMux().getInterfaceElement(this.getDestination().getName()));
                }
            }
        }
        super.execute();
    }

    private static boolean shouldChangeStruct(IInterfaceElement source, IInterfaceElement target) {
        DataType sourceType = source.getType();
        DataType targetType = target.getType();
        EObject sourceParent = source.eContainer().eContainer();
        EObject targetParent = target.eContainer().eContainer();
        if (sourceType instanceof StructuredType) {
            StructuredType sourceVar = (StructuredType)sourceType;
            if (targetType instanceof StructuredType) {
                StructuredType targetVar = (StructuredType)targetType;
                if (!sourceVar.getName().equals(targetVar.getName())) {
                    return true;
                }
            }
        }
        if (sourceType instanceof StructuredType && targetParent instanceof ConfigurableMoveFB && !source.getName().equals(target.getName())) {
            return true;
        }
        return targetType instanceof StructuredType && sourceParent instanceof ConfigurableMoveFB && !target.getName().equals(source.getName());
    }

    @Override
    public void undo() {
        super.undo();
        if (this.changeStructCommand != null) {
            this.changeStructCommand.undo();
        }
    }

    @Override
    public void redo() {
        if (this.changeStructCommand != null) {
            this.changeStructCommand.redo();
        }
        super.redo();
    }

    private static boolean isStructPin(IInterfaceElement pin) {
        VarDeclaration varDecl;
        return pin instanceof VarDeclaration && !(varDecl = (VarDeclaration)pin).isArray() && (varDecl.getType() instanceof StructuredType || pin.eContainer().eContainer() instanceof ConfigurableMoveFB);
    }

    private static boolean isUnconfiguredStructManipulatorDefPin(IInterfaceElement pin) {
        return AbstractConnectionCreateCommand.isStructManipulatorDefPin(pin) && (IecTypes.GenericTypes.ANY_STRUCT == pin.getType() || IecTypes.GenericTypes.ANY == pin.getType());
    }
}

