/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.fordiac.ide.model.data.RealType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyMagnitudeValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyRealValue;
import org.eclipse.fordiac.ide.model.value.NumericValueConverter;

public final class RealValue
implements AnyRealValue {
    public static final RealValue DEFAULT = new RealValue(0.0f);
    private final float value;

    private RealValue(float value) {
        this.value = value;
    }

    public static RealValue toRealValue(float value) {
        return new RealValue(value);
    }

    public static RealValue toRealValue(Number value) {
        return new RealValue(value.floatValue());
    }

    public static RealValue toRealValue(String value) {
        return RealValue.toRealValue((Number)NumericValueConverter.INSTANCE.toValue(value));
    }

    public static RealValue toRealValue(AnyMagnitudeValue value) {
        return RealValue.toRealValue(value.floatValue());
    }

    public RealType getType() {
        return IecTypes.ElementaryTypes.REAL;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.bigDecimalValue().toBigInteger();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.value);
    }

    public int hashCode() {
        return Float.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RealValue other = (RealValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return Float.toString(this.value);
    }
}

