/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.FBTImporter;
import org.eclipse.fordiac.ide.model.dataimport.SubAppNetworkImporter;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public class SubAppTImporter
extends FBTImporter {
    public SubAppTImporter(IFile typeFile) {
        super(typeFile);
    }

    public SubAppTImporter(CommonElementImporter importer) {
        super(importer);
    }

    public SubAppTImporter(InputStream inputStream, TypeLibrary typeLib) {
        super(inputStream, typeLib);
    }

    @Override
    protected FBType createRootModelElement() {
        SubAppType newType = LibraryElementFactory.eINSTANCE.createSubAppType();
        newType.setService(LibraryElementFactory.eINSTANCE.createService());
        return newType;
    }

    @Override
    public SubAppType getElement() {
        return (SubAppType)super.getElement();
    }

    @Override
    protected String getStartElementName() {
        return "SubAppType";
    }

    @Override
    protected CommonElementImporter.IChildHandler getBaseChildrenHandler() {
        return name -> {
            switch (name) {
                case "Identification": {
                    this.parseIdentification(this.getElement());
                    break;
                }
                case "VersionInfo": {
                    this.parseVersionInfo(this.getElement());
                    break;
                }
                case "CompilerInfo": {
                    this.getElement().setCompilerInfo(this.parseCompilerInfo());
                    break;
                }
                case "SubAppInterfaceList": {
                    this.getElement().setInterfaceList(this.parseInterfaceList("SubAppInterfaceList"));
                    break;
                }
                case "Service": {
                    this.parseService(this.getElement());
                    break;
                }
                case "SubAppNetwork": {
                    SubAppNetworkImporter subAppImporter = new SubAppNetworkImporter(this, this.getElement().getInterfaceList());
                    this.getElement().setFBNetwork(subAppImporter.getFbNetwork());
                    subAppImporter.parseFBNetwork("SubAppNetwork");
                    break;
                }
                case "Attribute": {
                    this.parseGenericAttributeNode(this.getElement());
                    this.proceedToEndElementNamed("Attribute");
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        };
    }

    @Override
    protected String getEventOutputElement() {
        return "SubAppEventOutputs";
    }

    @Override
    protected String getEventInputElement() {
        return "SubAppEventInputs";
    }

    @Override
    protected String getEventElement() {
        return "SubAppEvent";
    }

    @Override
    protected void processWiths() {
    }
}

