/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.libraryElement.impl;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.helpers.ArraySizeHelper;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.impl.NamedElementAnnotations;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public final class InterfaceElementAnnotations {
    private static final String NAMED_ELEMENTS_KEY = InterfaceElementAnnotations.class.getName() + ".NAMED_ELEMENTS";

    public static String getFullTypeName(IInterfaceElement element) {
        return ImportHelper.deresolveImport(element.getType(), element);
    }

    public static String getFullTypeName(VarDeclaration element) {
        String typeName = ImportHelper.deresolveImport(element.getType(), element);
        if (element.isArray() && typeName != null && !typeName.isBlank()) {
            String arraySize = ArraySizeHelper.getArraySize(element);
            if (!arraySize.contains("..")) {
                try {
                    return "ARRAY [0.." + (Integer.parseInt(arraySize) - 1) + "] OF " + typeName;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return "ARRAY [" + arraySize + "] OF " + typeName;
        }
        return typeName;
    }

    public static boolean isInOutVar(VarDeclaration varDecl) {
        return LibraryElementPackage.eINSTANCE.getInterfaceList_InOutVars().equals(varDecl.eContainingFeature()) || LibraryElementPackage.eINSTANCE.getInterfaceList_OutMappedInOutVars().equals(varDecl.eContainingFeature());
    }

    public static boolean validateName(IInterfaceElement element, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (InterfaceElementAnnotations.isErrorMarker(element) || InterfaceElementAnnotations.isInTypedInstance(element)) {
            return true;
        }
        if (!NamedElementAnnotations.validateName(element, diagnostics, context)) {
            return false;
        }
        if (!InterfaceElementAnnotations.isOutMappedInOutVar(element) && !NamedElementAnnotations.validateDuplicateName(element, diagnostics, context, NAMED_ELEMENTS_KEY)) {
            return false;
        }
        if (!"DT".equals(element.getName()) && InterfaceElementAnnotations.existsDataType(InterfaceElementAnnotations.getDataTypeLibrary(element), element.getName())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 22, MessageFormat.format(Messages.InterfaceElementAnnotations_MemberNameCollidesWithDataType, element.getQualifiedName()), FordiacMarkerHelper.getDiagnosticData((EObject)element, (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, element.getQualifiedName())));
            }
            return false;
        }
        return true;
    }

    static boolean isErrorMarker(IInterfaceElement element) {
        return element instanceof ErrorMarkerInterface;
    }

    static boolean isInTypedInstance(IInterfaceElement element) {
        FBNetworkElement fbNetworkElement = element.getFBNetworkElement();
        return fbNetworkElement != null && fbNetworkElement.getTypeEntry() != null;
    }

    static boolean isOutMappedInOutVar(IInterfaceElement element) {
        VarDeclaration varDeclaration;
        return element instanceof VarDeclaration && (varDeclaration = (VarDeclaration)element).isInOutVar() && !varDeclaration.isIsInput();
    }

    static boolean existsDataType(DataTypeLibrary dataTypeLibrary, String name) {
        return dataTypeLibrary != null && dataTypeLibrary.getTypeIfExists(name) != null;
    }

    static DataTypeLibrary getDataTypeLibrary(IInterfaceElement element) {
        LibraryElement libraryElement;
        TypeLibrary typeLibrary;
        EObject eObject = EcoreUtil.getRootContainer((EObject)element);
        if (eObject instanceof LibraryElement && (typeLibrary = (libraryElement = (LibraryElement)eObject).getTypeLibrary()) != null) {
            return typeLibrary.getDataTypeLibrary();
        }
        return null;
    }

    private InterfaceElementAnnotations() {
        throw new UnsupportedOperationException();
    }
}

