/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.contentassist;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCorePackage;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;

public class STCoreImportReplacementTextApplier
implements ConfigurableCompletionProposal.IReplacementTextApplier {
    private final XtextResource resource;
    private final String importedNamespace;
    private final IWhitespaceInformationProvider whitespaceInformationProvider;

    public STCoreImportReplacementTextApplier(XtextResource resource, String importedNamespace, IWhitespaceInformationProvider whitespaceInformationProvider) {
        this.resource = resource;
        this.importedNamespace = importedNamespace;
        this.whitespaceInformationProvider = whitespaceInformationProvider;
    }

    public void apply(IDocument document, ConfigurableCompletionProposal proposal) throws BadLocationException {
        if (document instanceof IDocumentExtension4) {
            IDocumentExtension4 documentExtension = (IDocumentExtension4)document;
            DocumentRewriteSession rewriteSession = documentExtension.startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED_SMALL);
            try {
                this.applyReplacementString(document, proposal);
                this.applyImport(document, proposal);
            }
            finally {
                documentExtension.stopRewriteSession(rewriteSession);
            }
        } else {
            this.applyReplacementString(document, proposal);
            this.applyImport(document, proposal);
        }
    }

    protected void applyReplacementString(IDocument document, ConfigurableCompletionProposal proposal) throws BadLocationException {
        document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), proposal.getReplacementString());
    }

    protected void applyImport(IDocument document, ConfigurableCompletionProposal proposal) throws BadLocationException {
        STSource source = this.getSource();
        StringBuilder importString = this.getImportString();
        String lineSeparator = this.getLineSeparator();
        int offset = this.findImportOffset(source);
        if (offset > 0) {
            importString.insert(0, lineSeparator);
        } else {
            offset = this.findPackageOffset(source);
            if (offset > 0) {
                importString.insert(0, lineSeparator);
                importString.insert(0, lineSeparator);
            } else {
                importString.append(lineSeparator);
                importString.append(lineSeparator);
            }
        }
        document.replace(offset, 0, importString.toString());
        proposal.shiftOffset(importString.length());
    }

    protected StringBuilder getImportString() {
        StringBuilder result = new StringBuilder();
        result.append("IMPORT");
        result.append(' ');
        result.append(this.getImportedNamespace());
        result.append(';');
        return result;
    }

    protected int findPackageOffset(STSource source) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)source, (EStructuralFeature)this.getPackageFeature(source));
        if (!nodes.isEmpty()) {
            INode last = (INode)nodes.get(nodes.size() - 1);
            while (!";".equals(last.getText())) {
                last = last.getNextSibling();
            }
            return last.getEndOffset();
        }
        return 0;
    }

    protected int findImportOffset(STSource source) {
        List importNodes = NodeModelUtils.findNodesForFeature((EObject)source, (EStructuralFeature)this.getImportsFeature(source));
        if (!importNodes.isEmpty()) {
            return ((INode)importNodes.get(importNodes.size() - 1)).getEndOffset();
        }
        return 0;
    }

    protected EStructuralFeature getPackageFeature(STSource source) {
        EStructuralFeature packageFeature = source.eClass().getEStructuralFeature("name");
        if (packageFeature != null && packageFeature.getEType() == EcorePackage.eINSTANCE.getEString() && !packageFeature.isMany()) {
            return packageFeature;
        }
        return null;
    }

    protected EStructuralFeature getImportsFeature(STSource source) {
        EStructuralFeature importsFeature = source.eClass().getEStructuralFeature("imports");
        if (importsFeature != null && importsFeature.getEType() == STCorePackage.eINSTANCE.getSTImport() && importsFeature.isMany()) {
            return importsFeature;
        }
        return null;
    }

    protected String getLineSeparator() {
        return this.whitespaceInformationProvider.getLineSeparatorInformation(this.resource.getURI()).getLineSeparator();
    }

    protected STSource getSource() {
        return this.resource.getContents().stream().filter(STSource.class::isInstance).map(STSource.class::cast).findFirst().orElse(null);
    }

    public XtextResource getResource() {
        return this.resource;
    }

    public String getImportedNamespace() {
        return this.importedNamespace;
    }
}

