/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.objects;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.objects.AuditConditionEventTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.objects.AuditConditionCommentEventType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class AuditConditionCommentEventTypeNode
extends AuditConditionEventTypeNode
implements AuditConditionCommentEventType {
    public AuditConditionCommentEventTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, UByte eventNotifier) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, eventNotifier);
    }

    @Override
    public ByteString getConditionEventId() throws UaException {
        PropertyTypeNode node = this.getConditionEventIdNode();
        return (ByteString)node.getValue().getValue().getValue();
    }

    @Override
    public void setConditionEventId(ByteString conditionEventId) throws UaException {
        PropertyTypeNode node = this.getConditionEventIdNode();
        node.setValue(new Variant((Object)conditionEventId));
    }

    @Override
    public ByteString readConditionEventId() throws UaException {
        try {
            return this.readConditionEventIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeConditionEventId(ByteString conditionEventId) throws UaException {
        try {
            this.writeConditionEventIdAsync(conditionEventId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ByteString> readConditionEventIdAsync() {
        return ((CompletableFuture)this.getConditionEventIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (ByteString)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeConditionEventIdAsync(ByteString conditionEventId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)conditionEventId));
        return this.getConditionEventIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getConditionEventIdNode() throws UaException {
        try {
            return this.getConditionEventIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getConditionEventIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ConditionEventId", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public LocalizedText getComment() throws UaException {
        PropertyTypeNode node = this.getCommentNode();
        return (LocalizedText)node.getValue().getValue().getValue();
    }

    @Override
    public void setComment(LocalizedText comment) throws UaException {
        PropertyTypeNode node = this.getCommentNode();
        node.setValue(new Variant((Object)comment));
    }

    @Override
    public LocalizedText readComment() throws UaException {
        try {
            return this.readCommentAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeComment(LocalizedText comment) throws UaException {
        try {
            this.writeCommentAsync(comment).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends LocalizedText> readCommentAsync() {
        return ((CompletableFuture)this.getCommentNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (LocalizedText)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCommentAsync(LocalizedText comment) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)comment));
        return this.getCommentNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getCommentNode() throws UaException {
        try {
            return this.getCommentNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getCommentNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "Comment", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

