/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.aql.ide.ui.AcceleoUIPlugin;
import org.eclipse.acceleo.aql.ide.ui.module.main.EclipseUIProjectGenerator;
import org.eclipse.acceleo.aql.ide.ui.module.main.StandaloneGenerator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateEclipseUIProjectHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        IRunnableWithProgress generateRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                Iterator it = selection.iterator();
                LinkedHashMap<IProject, List> projectToFiles = new LinkedHashMap<IProject, List>();
                int amountOfWork = 0;
                while (it.hasNext()) {
                    Object selected = it.next();
                    if (!(selected instanceof IFile)) continue;
                    IFile file = (IFile)selected;
                    projectToFiles.computeIfAbsent(file.getProject(), p -> new ArrayList()).add(file);
                    ++amountOfWork;
                }
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(amountOfWork += projectToFiles.size()));
                for (Map.Entry entry : projectToFiles.entrySet()) {
                    for (IFile file : (List)entry.getValue()) {
                        Monitor childMonitor = BasicMonitor.toMonitor((IProgressMonitorWithBlocking)subMonitor.split(1));
                        try {
                            StandaloneGenerator standaloneGenerator = new StandaloneGenerator(file);
                            standaloneGenerator.generate(childMonitor);
                        }
                        finally {
                            childMonitor.done();
                        }
                        if (monitor.isCanceled()) break;
                    }
                    Monitor childMonitor = BasicMonitor.toMonitor((IProgressMonitorWithBlocking)subMonitor.split(1));
                    try {
                        EclipseUIProjectGenerator eclipseUIProjectGenerator = new EclipseUIProjectGenerator((List)entry.getValue());
                        eclipseUIProjectGenerator.generate(childMonitor);
                    }
                    finally {
                        childMonitor.done();
                    }
                    if (monitor.isCanceled()) break;
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, generateRunnable);
        }
        catch (InvocationTargetException e) {
            AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(4, ((Object)((Object)this)).getClass(), "Couldn't generate.", (Throwable)e));
        }
        catch (InterruptedException e) {
            AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(4, ((Object)((Object)this)).getClass(), "Couldn't generate.", (Throwable)e));
        }
        return null;
    }
}

