/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.common;

import java.net.URI;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.namespace.ISourceLocation;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public final class LocationUtils {
    private LocationUtils() {
    }

    public static Location location(IQualifiedNameQueryEnvironment queryEnvironment, String contextQualifiedName, IAcceleoValidationResult acceleoValidationResult, ASTNode astNode) {
        URI sourceURI = LocationUtils.getSourceURI(queryEnvironment, contextQualifiedName);
        return new Location(sourceURI.toASCIIString(), LocationUtils.range(acceleoValidationResult, astNode));
    }

    public static Location identifierLocation(IQualifiedNameQueryEnvironment queryEnvironment, String contextQualifiedName, IAcceleoValidationResult acceleoValidationResult, ASTNode astNode) {
        URI sourceURI = LocationUtils.getSourceURI(queryEnvironment, contextQualifiedName);
        return new Location(sourceURI.toASCIIString(), LocationUtils.identifierRange(acceleoValidationResult, astNode));
    }

    public static Range range(IAcceleoValidationResult acceleoValidationResult, ASTNode astNode) {
        AcceleoAstResult astResult = acceleoValidationResult.getAcceleoAstResult();
        int startLine = astResult.getStartLine(astNode);
        int startColumn = astResult.getStartColumn(astNode);
        int endLine = astResult.getEndLine(astNode);
        int endColumn = astResult.getEndColumn(astNode);
        Position start = new Position(startLine, startColumn);
        Position end = new Position(endLine, endColumn);
        return new Range(start, end);
    }

    public static Range identifierRange(IAcceleoValidationResult acceleoValidationResult, ASTNode astNode) {
        AcceleoAstResult astResult = acceleoValidationResult.getAcceleoAstResult();
        int startLine = astResult.getIdentifierStartLine(astNode);
        int startColumn = astResult.getIdentifierStartColumn(astNode);
        int endLine = astResult.getIdentifierEndLine(astNode);
        int endColumn = astResult.getIdentifierEndColumn(astNode);
        Position start = new Position(startLine, startColumn);
        Position end = new Position(endLine, endColumn);
        return new Range(start, end);
    }

    private static URI getSourceURI(IQualifiedNameQueryEnvironment queryEnvironment, String qualifiedName) {
        IQualifiedNameResolver resolver = queryEnvironment.getLookupEngine().getResolver();
        URI sourceURI = resolver.getSourceURI(qualifiedName);
        return sourceURI;
    }

    public static Range identifierRange(ISourceLocation location) {
        ISourceLocation.IRange identifierRange = location.getIdentifierRange();
        Position identifierStart = new Position(identifierRange.getStart().getLine(), identifierRange.getStart().getColumn());
        Position identifierEnd = new Position(identifierRange.getEnd().getLine(), identifierRange.getEnd().getColumn());
        return new Range(identifierStart, identifierEnd);
    }

    public static Range range(ISourceLocation location) {
        ISourceLocation.IRange range = location.getIdentifierRange();
        Position start = new Position(range.getStart().getLine(), range.getStart().getColumn());
        Position end = new Position(range.getEnd().getLine(), range.getEnd().getColumn());
        return new Range(start, end);
    }
}

