/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ide.runtime.impl.namespace;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.acceleo.query.runtime.impl.namespace.CallStack;
import org.eclipse.acceleo.query.runtime.impl.namespace.ClassLoaderQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.namespace.ILoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class OSGiQualifiedNameResolver
extends ClassLoaderQualifiedNameResolver {
    private final Map<String, Bundle> qualifiedNameToBundleWiring = new HashMap<String, Bundle>();
    private final Bundle bundle;

    public OSGiQualifiedNameResolver(Bundle bundle, String qualifierSeparator) {
        super(OSGiQualifiedNameResolver.createBundleClassLoader(bundle), qualifierSeparator);
        this.bundle = bundle;
    }

    protected static ClassLoader createBundleClassLoader(Bundle bundle) {
        return ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
    }

    protected void register(ILoader loader, String qualifiedName, Object object) {
        super.register(loader, qualifiedName, object);
        String resourceName = loader.resourceName(qualifiedName);
        Bundle resourceBundle = this.getBundle(this.bundle, resourceName);
        this.qualifiedNameToBundleWiring.put(qualifiedName, resourceBundle);
    }

    private Bundle getBundle(Bundle root, String resource) {
        Bundle res = null;
        URL entry = root.getResource(resource);
        if (this.isLocalResource(root, entry)) {
            res = root;
        } else {
            BundleWiring rootWiring = (BundleWiring)root.adapt(BundleWiring.class);
            for (BundleWire requirement : rootWiring.getRequiredWires(null)) {
                URL requiredBundleEntry;
                Bundle requiredBundle = requirement.getProviderWiring().getBundle();
                if (!this.isLocalResource(requiredBundle, requiredBundleEntry = requiredBundle.getResource(resource))) continue;
                res = requiredBundle;
                break;
            }
        }
        return res;
    }

    private boolean isLocalResource(Bundle bundle, URL resource) {
        return resource != null && resource.toString().startsWith(bundle.getResource("/").toString());
    }

    protected ClassLoader getClassLoader() {
        String contextQualifiedName = this.getContextQualifiedName();
        BundleWiring contextBundleWiring = (BundleWiring)this.qualifiedNameToBundleWiring.getOrDefault(contextQualifiedName, this.bundle).adapt(BundleWiring.class);
        return contextBundleWiring.getClassLoader();
    }

    protected String getContextQualifiedName() {
        CallStack currentContext = this.getLookupEngine().getCurrentContext();
        String res = currentContext != null ? (!currentContext.isEmpty() ? currentContext.peek() : currentContext.getStartingQualifiedName()) : null;
        return res;
    }
}

