/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.samples.rcp.action;

import java.io.File;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportEditorInput;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.samplesview.action.IOpenSampleReportAction;
import org.eclipse.birt.report.designer.ui.samplesview.util.PlaceResources;
import org.eclipse.birt.report.designer.ui.samplesview.view.ReportExamples;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class RCPOpenSampleReportAction
extends Action
implements IOpenSampleReportAction,
Listener {
    private static final String ACTION_TEXT = Messages.getString((String)"SampleReportsView.Action.openSampleReport");
    private static final String DRILL_TO_DETAILS_CATEGORY = "Drill to Details";
    private ReportExamples composite;

    public RCPOpenSampleReportAction() {
        super(ACTION_TEXT);
        this.setToolTipText(Messages.getString((String)"SampleReportsView.Action.openSampleReport.toolTipText.rcp"));
        this.setImageDescriptor(ReportPlatformUIImages.getImageDescriptor((String)"import_enable"));
        this.setDisabledImageDescriptor(ReportPlatformUIImages.getImageDescriptor((String)"import_edisable"));
        this.setEnabled(false);
    }

    public void setMainComposite(ReportExamples composite) {
        this.composite = composite;
        composite.addSelectedListener((Listener)this);
    }

    public void run() {
        TreeItem item = (TreeItem)this.composite.getSelectedElement();
        final Object selectedElement = item.getData();
        if (selectedElement == null || !(selectedElement instanceof ReportDesignHandle)) {
            return;
        }
        PlaceResources.copy((Shell)this.composite.getShell(), (String)this.getDefaultLocation(), (String)item.getText(), (String)((ReportDesignHandle)selectedElement).getFileName());
        if (item.getParentItem().getText().equals(DRILL_TO_DETAILS_CATEGORY)) {
            PlaceResources.copyDrillThroughReport((Shell)this.composite.getShell(), (String)this.getDefaultLocation(), (String)item.getText());
        }
        PlaceResources.copyExcludedRptDesignes((Shell)this.composite.getShell(), (String)this.getDefaultLocation(), (String)((ReportDesignHandle)selectedElement).getFileName(), (boolean)true);
        ISafeRunnable op = new ISafeRunnable(){

            public void run() {
                String fileName = ((ReportDesignHandle)selectedElement).getFileName();
                RCPOpenSampleReportAction.this.doFinish(RCPOpenSampleReportAction.this.getDefaultLocation(), fileName.substring(fileName.lastIndexOf(47) + 1));
            }

            public void handleException(Throwable exception) {
                ExceptionUtil.handle((Throwable)exception);
            }
        };
        SafeRunner.run((ISafeRunnable)op);
    }

    private void doFinish(String locationPath, String fileName) {
        final File file = new File(locationPath, fileName);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    if (page == null) {
                        throw new IllegalArgumentException();
                    }
                    page.openEditor((IEditorInput)new ReportEditorInput(file), "org.eclipse.birt.report.designer.ui.editors.ReportEditor", true);
                }
                catch (Exception e) {
                    ExceptionUtil.handle((Throwable)e);
                }
            }
        });
    }

    private String getDefaultLocation() {
        IPath defaultPath = Platform.getLocation();
        return defaultPath.toOSString();
    }

    public void handleEvent(Event event) {
        TreeItem item;
        if (event.widget == null || !(event.widget instanceof TreeItem)) {
            this.setEnabled(false);
        }
        if ((item = (TreeItem)event.widget) == null) {
            super.setEnabled(false);
            return;
        }
        Object selectedElement = item.getData();
        if (selectedElement == null) {
            super.setEnabled(false);
        } else {
            super.setEnabled(selectedElement instanceof ReportDesignHandle);
        }
    }
}

