/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.comma.monitoring.lib.CComponentMonitoringContext;
import org.eclipse.comma.monitoring.lib.CComponentTypeDescriptor;
import org.eclipse.comma.monitoring.lib.CEntryPoint;
import org.eclipse.comma.monitoring.lib.CFactory;
import org.eclipse.comma.monitoring.lib.CInterfaceMonitoringContext;
import org.eclipse.comma.monitoring.lib.CMonitoringContext;
import org.eclipse.comma.monitoring.lib.CPortConnectionMonitoringContext;
import org.eclipse.comma.monitoring.lib.CPortInstance;

public class CComponentMonitoringTaskContext
extends CMonitoringContext {
    protected List<CEntryPoint> entryPoints;
    protected List<List<CPortInstance>> portPaths;
    protected List<String> componentInstancesInTrace;
    protected String componentType;
    protected Map<String, CComponentTypeDescriptor> componentDescriptors = new HashMap<String, CComponentTypeDescriptor>();

    public CComponentMonitoringTaskContext(String componentType, List<String> componentInstancesInTrace, CFactory factory, String resultsDir) {
        super(factory, resultsDir);
        this.componentType = componentType;
        this.componentInstancesInTrace = componentInstancesInTrace;
    }

    public void setEntryPoints(List<CEntryPoint> entryPoints) {
        this.entryPoints = entryPoints;
    }

    public CComponentTypeDescriptor getMonitoredComponentDescriptor() {
        return this.componentDescriptors.get(this.componentType);
    }

    public CComponentTypeDescriptor getComponentDescriptor(String componentType) {
        return this.componentDescriptors.get(componentType);
    }

    public List<CEntryPoint> getEntryPoints() {
        return this.entryPoints;
    }

    public void setPortPaths(List<List<CPortInstance>> portPaths) {
        this.portPaths = portPaths;
    }

    public List<List<CPortInstance>> getPortPaths() {
        return this.portPaths;
    }

    public List<String> getComponentInstances() {
        return this.componentInstancesInTrace;
    }

    public void addComponentTypeDescriptor(CComponentTypeDescriptor d) {
        this.componentDescriptors.put(d.componentType, d);
    }

    public CComponentMonitoringContext createComponentMonitoringContext(String instance, String componentType) {
        CComponentMonitoringContext context = new CComponentMonitoringContext(this.factory, this.resultsDir);
        context.skipTimeConstraints(this.timeConstraintsSkipped);
        context.skipDataConstraints(this.dataConstraintsSkipped);
        return context.setComponentInstanceName(instance).setComponentDescriptor(this.componentDescriptors.get(componentType));
    }

    public CPortConnectionMonitoringContext createPortConnectionContext(String interfaceName, String port, String componentInstance, String connectionKey) {
        CPortConnectionMonitoringContext result = new CPortConnectionMonitoringContext(interfaceName, false, this.factory, this.resultsDir);
        result.setConnectionName(connectionKey).setLocalDir(String.valueOf(componentInstance) + "/" + "port_" + port + "/");
        result.setPort(port);
        return result;
    }

    public CInterfaceMonitoringContext createComponentTimeDataContext(String componentInstanceName) {
        CInterfaceMonitoringContext context = new CInterfaceMonitoringContext("", false, null, this.resultsDir).setConnectionName(componentInstanceName).setLocalDir(String.valueOf(componentInstanceName) + "/" + "time_data/");
        context.skipTimeConstraints(this.timeConstraintsSkipped);
        context.skipDataConstraints(this.dataConstraintsSkipped);
        return context;
    }
}

