/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.core;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.eclemma.core.IExecutionDataSource;
import org.eclipse.eclemma.core.ISessionImporter;
import org.eclipse.eclemma.core.ISessionManager;
import org.eclipse.eclemma.internal.core.CoreMessages;
import org.eclipse.eclemma.internal.core.CoverageSession;
import org.eclipse.eclemma.internal.core.ExecutionDataFiles;
import org.eclipse.jdt.core.IPackageFragmentRoot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionImporter
implements ISessionImporter {
    private final ISessionManager sessionManager;
    private final ExecutionDataFiles executionDataFiles;
    private String description;
    private IExecutionDataSource dataSource;
    private Set<IPackageFragmentRoot> scope;
    private boolean copy;

    public SessionImporter(ISessionManager sessionManager, ExecutionDataFiles executionDataFiles) {
        this.sessionManager = sessionManager;
        this.executionDataFiles = executionDataFiles;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setExecutionDataSource(IExecutionDataSource source) {
        this.dataSource = source;
    }

    @Override
    public void setScope(Set<IPackageFragmentRoot> scope) {
        this.scope = scope;
    }

    @Override
    public void setCopy(boolean copy) {
        this.copy = copy;
    }

    @Override
    public void importSession(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(CoreMessages.ImportingSession_task, 2);
        IExecutionDataSource source = this.copy ? this.executionDataFiles.newFile(this.dataSource) : this.dataSource;
        monitor.worked(1);
        CoverageSession session = new CoverageSession(this.description, this.scope, source, null);
        this.sessionManager.addSession(session, true, null);
        monitor.done();
    }
}

