/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.runnablejar;

import com.sun.enterprise.config.serverbeans.Domain;
import java.io.Console;
import java.nio.file.Path;
import java.util.List;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.main.boot.embedded.EmbeddedGlassFishRuntimeBuilder;
import org.glassfish.runnablejar.InfoPrinter;
import org.glassfish.runnablejar.commandline.Arguments;
import org.glassfish.runnablejar.commandline.CommandLineParser;

public class UberMain
implements AutoCloseable {
    private static final System.Logger LOG = System.getLogger(UberMain.class.getName());
    private static final String SERVER_NAME = "server";
    private static volatile String goodByeMessage;
    private GlassFish glassFish;
    private CommandRunner commandRunner;
    private boolean shutdownRequested;

    public static void main(String ... args) throws Exception {
        Arguments arguments = new CommandLineParser().parse(args);
        if (arguments.askedForHelp) {
            arguments.printHelp();
        } else {
            EmbeddedGlassFishRuntimeBuilder.addModuleJars = false;
            System.out.println("GlassFish will start now. Welcome!");
            UberMain uberMain = new UberMain();
            try {
                uberMain.run(arguments);
                if (uberMain.isShutdownRequested()) {
                    UberMain.exit(0, "GlassFish shut down after startup as requested.");
                }
            }
            catch (GlassFishException e) {
                LOG.log(System.Logger.Level.ERROR, "Exit code 1, execution failed.", (Throwable)e);
                UberMain.exit(1, "Exit code 1, execution failed.");
            }
            catch (Throwable e) {
                LOG.log(System.Logger.Level.ERROR, "Exit code 100, execution failed.", e);
                UberMain.exit(100, "Exit code 100, execution failed.");
            }
        }
    }

    private static void exit(int exitCode, String goodByeMessage) {
        UberMain.goodByeMessage = goodByeMessage;
        System.exit(exitCode);
    }

    public UberMain() {
        this.addShutdownHook();
    }

    public boolean isShutdownRequested() {
        return this.shutdownRequested;
    }

    private void run(Arguments arguments) throws GlassFishException {
        GlassFishProperties gfProps = arguments.glassFishProperties;
        this.setFromSystemProperty(gfProps, "org.glassfish.embeddable.autoDelete", "true");
        this.glassFish = GlassFishRuntime.bootstrap().newGlassFish(gfProps);
        this.glassFish.start();
        this.commandRunner = this.glassFish.getCommandRunner();
        for (String command : arguments.commands) {
            this.executeCommandFromString(command);
        }
        if (!arguments.deployables.isEmpty()) {
            if (this.glassFish.getDeployer().getDeployedApplications().isEmpty() && arguments.deployables.size() == 1) {
                String deployable = arguments.deployables.get(0);
                this.executeCommandFromString("deploy --contextroot=/ " + (String)deployable);
                LOG.log(System.Logger.Level.INFO, () -> "Application " + String.valueOf(Path.of(deployable, new String[0]).getFileName()) + " deployed at context root \"/\"");
            } else {
                for (String deployable : arguments.deployables) {
                    this.executeCommandFromString("deploy " + deployable);
                    LOG.log(System.Logger.Level.INFO, () -> "Application " + String.valueOf(Path.of(deployable, new String[0]).getFileName()) + " deployed");
                }
            }
        }
        if (arguments.shutdown) {
            LOG.log(System.Logger.Level.INFO, "Shutting down after startup as requested.");
            this.shutdownRequested = true;
            return;
        }
        GlassFish.Status status = this.glassFish.getStatus();
        switch (status) {
            case INIT: 
            case STARTING: 
            case STARTED: {
                if (!arguments.noInfo) {
                    this.printInfoAfterStartup();
                }
                if (!arguments.prompt) break;
                this.runCommandPromptLoop();
                break;
            }
            case STOPPING: {
                LOG.log(System.Logger.Level.INFO, "GlassFish is shutting down...");
                break;
            }
            case STOPPED: 
            case DISPOSED: {
                LOG.log(System.Logger.Level.INFO, "GlassFish is shut down.");
            }
            default: {
                throw new IllegalArgumentException("Unknown status of the GlassFish runtime: " + String.valueOf(status));
            }
        }
    }

    protected void printInfoAfterStartup() throws GlassFishException {
        Domain domain = (Domain)this.glassFish.getService(Domain.class);
        List applications = domain.getApplicationsInTarget(SERVER_NAME);
        List listeners = domain.getServers().getServer(SERVER_NAME).getConfig().getNetworkConfig().getNetworkListeners().getNetworkListener();
        System.out.println("\n\n" + new InfoPrinter().getInfoAfterStartup(applications, listeners));
    }

    private void runCommandPromptLoop() {
        Console console = System.console();
        if (console == null) {
            throw new Error("System.console() is not supported in this shell.");
        }
        while (true) {
            String str;
            if ((str = console.readLine("\nGlassFish $ ", new Object[0]).strip()) == null || str.isEmpty()) {
                continue;
            }
            if ("exit".equalsIgnoreCase(str) || "quit".equalsIgnoreCase(str)) {
                UberMain.exit(0, "GlassFish shut down. See you soon!");
            }
            try {
                this.executeCommandFromString(str);
                continue;
            }
            catch (GlassFishException e) {
                System.out.println(e.getLocalizedMessage());
                e.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }

    private void executeCommandFromString(String stringCommand) throws GlassFishException {
        LOG.log(System.Logger.Level.DEBUG, () -> "Executing command: " + stringCommand);
        String[] split = stringCommand.split("(?<!\\\\)\\s+");
        String command = split[0].trim();
        String[] commandParams = null;
        if (split.length > 1) {
            commandParams = new String[split.length - 1];
            for (int i = 1; i < split.length; ++i) {
                commandParams[i - 1] = split[i].trim();
            }
        }
        CommandResult result = commandParams == null ? this.commandRunner.run(command, new String[0]) : this.commandRunner.run(command, commandParams);
        switch (result.getExitStatus()) {
            case SUCCESS: {
                LOG.log(System.Logger.Level.INFO, () -> "SUCCESS: " + result.getOutput());
                break;
            }
            case WARNING: {
                LOG.log(System.Logger.Level.WARNING, () -> "WARNING: " + result.getOutput());
                break;
            }
            case FAILURE: {
                throw new GlassFishException("Command completed with " + String.valueOf(result.getExitStatus()) + ": " + result.getOutput() + ". Command was: " + stringCommand, result.getFailureCause());
            }
            default: {
                throw new IllegalArgumentException("Unknwown command exit status: " + String.valueOf(result.getExitStatus()) + ". Output: " + result.getOutput());
            }
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread("GlassFish UberMain Shutdown Hook"){

            @Override
            public void run() {
                try {
                    UberMain.this.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }

    @Override
    public void close() throws GlassFishException {
        if (this.glassFish == null) {
            return;
        }
        GlassFish instance = this.glassFish;
        this.glassFish = null;
        try {
            instance.stop();
        }
        finally {
            instance.dispose();
            if (goodByeMessage != null) {
                System.out.println(goodByeMessage);
            }
        }
    }

    private void setFromSystemProperty(GlassFishProperties gfProps, String propertyName, String defaultValue) {
        String systemProperty = System.getProperty(propertyName);
        if (systemProperty != null) {
            gfProps.setProperty(propertyName, systemProperty);
        } else if (!gfProps.getProperties().containsKey(propertyName)) {
            gfProps.setProperty(propertyName, defaultValue);
        }
    }
}

