/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.comet.concurrent;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Logger;
import org.glassfish.grizzly.comet.CometContext;
import org.glassfish.grizzly.comet.CometEvent;
import org.glassfish.grizzly.comet.CometHandler;
import org.glassfish.grizzly.http.server.Response;

public abstract class DefaultConcurrentCometHandler<E>
implements CometHandler<E> {
    protected static final Logger logger = Logger.getLogger(DefaultConcurrentCometHandler.class.getName());
    private boolean shuttingDown;
    private final int messageQueueLimit;
    private int queueSize;
    private boolean readyForWork = true;
    protected final Queue<CometEvent> messageQueue = new LinkedList<CometEvent>();
    private CometContext<E> context;
    private Response response;

    public DefaultConcurrentCometHandler(CometContext<E> context, Response response) {
        this(100);
        this.context = context;
        this.response = response;
    }

    public DefaultConcurrentCometHandler(int messageQueueLimit) {
        this.messageQueueLimit = messageQueueLimit;
    }

    @Override
    public CometContext<E> getCometContext() {
        return this.context;
    }

    @Override
    public void setCometContext(CometContext<E> context) {
        this.context = context;
    }

    @Override
    public Response getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(Response response) {
        this.response = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueEvent(CometEvent event) throws IOException {
        Queue<CometEvent> queue = this.messageQueue;
        synchronized (queue) {
            if (!this.readyForWork) {
                if (!this.shuttingDown && this.queueSize < this.messageQueueLimit) {
                    this.messageQueue.add(event);
                    ++this.queueSize;
                }
                return;
            }
            this.readyForWork = false;
        }
        boolean queueFull = false;
        while (!this.shuttingDown) {
            Object object;
            block21: {
                if (!event.getCometContext().isActive(this)) {
                    this.shuttingDown = true;
                    return;
                }
                try {
                    object = this;
                    synchronized (object) {
                        this.onEvent(event);
                    }
                }
                catch (IOException ex) {
                    this.shuttingDown = true;
                }
                finally {
                    if (!this.shuttingDown) break block21;
                    event.getCometContext().resumeCometHandler(this);
                    return;
                }
            }
            object = this.messageQueue;
            synchronized (object) {
                if (this.queueSize == this.messageQueueLimit) {
                    queueFull = true;
                } else {
                    if (this.queueSize == 0) {
                        this.readyForWork = true;
                        return;
                    }
                    event = this.messageQueue.poll();
                    --this.queueSize;
                }
            }
            if (!queueFull) continue;
            this.shuttingDown = true;
            this.onQueueFull(event);
        }
    }

    public void onQueueFull(CometEvent event) throws IOException {
        event.getCometContext().resumeCometHandler(this);
    }

    @Override
    public void onInterrupt(CometEvent event) throws IOException {
        this.terminate();
    }

    @Override
    public void onTerminate(CometEvent event) throws IOException {
        this.terminate();
    }

    protected void terminate() {
    }
}

