/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angus.mail.imap.protocol;

import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.util.ArrayList;
import org.eclipse.angus.mail.iap.ParsingException;
import org.eclipse.angus.mail.iap.Response;

class IMAPAddress
extends InternetAddress {
    private boolean group = false;
    private InternetAddress[] grouplist;
    private String groupname;
    private static final long serialVersionUID = -3835822029483122232L;

    IMAPAddress(Response r, boolean strict) throws ParsingException {
        r.skipSpaces();
        if (r.readByte() != 40) {
            throw new ParsingException("ADDRESS parse error");
        }
        this.encodedPersonal = r.readString();
        r.readString();
        String mb = r.readString();
        String host = r.readString();
        r.skipSpaces();
        if (!r.isNextNonSpace(')')) {
            throw new ParsingException("ADDRESS parse error");
        }
        if (host == null) {
            IMAPAddress a;
            this.group = true;
            this.groupname = mb;
            if (this.groupname == null) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.groupname).append(':');
            ArrayList<IMAPAddress> v = new ArrayList<IMAPAddress>();
            while (r.peekByte() != 41 && !(a = new IMAPAddress(r, strict)).isEndOfGroup()) {
                if (v.size() != 0) {
                    sb.append(',');
                }
                sb.append(a.toString());
                v.add(a);
            }
            sb.append(';');
            this.address = sb.toString();
            this.grouplist = v.toArray(new IMAPAddress[0]);
        } else {
            this.address = mb == null || mb.length() == 0 ? host : (host.length() == 0 ? mb : mb + "@" + host);
        }
        if (strict) {
            try {
                this.validate();
            }
            catch (AddressException e) {
                throw new ParsingException("ADDRESS parse error", e);
            }
        }
    }

    boolean isEndOfGroup() {
        return this.group && this.groupname == null;
    }

    public boolean isGroup() {
        return this.group;
    }

    public InternetAddress[] getGroup(boolean strict) throws AddressException {
        if (this.grouplist == null) {
            return null;
        }
        return (InternetAddress[])this.grouplist.clone();
    }
}

