/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.singleton.lifecycle.bean;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.lite.EJBLiteClientBase;
import com.sun.ts.tests.ejb30.lite.singleton.lifecycle.bean.ASingletonBean;
import com.sun.ts.tests.ejb30.lite.singleton.lifecycle.bean.BSingletonIF;
import com.sun.ts.tests.ejb30.lite.singleton.lifecycle.bean.C2SingletonIF;
import com.sun.ts.tests.ejb30.lite.singleton.lifecycle.bean.CSingletonIF;
import com.sun.ts.tests.ejb30.lite.singleton.lifecycle.bean.CommonSingletonIF;
import com.sun.ts.tests.ejb30.lite.singleton.lifecycle.bean.StatefulBean;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBException;
import java.util.Vector;
import java.util.logging.Level;

public class Client
extends EJBLiteClientBase {
    @EJB(name="ejb/aSingleton", beanName="ASingletonBean")
    private ASingletonBean aSingleton;
    @EJB(name="ejb/bSingleton", beanName="BSingletonBean")
    private BSingletonIF bSingleton;
    @EJB(name="ejb/cSingleton", beanName="CSingletonBean")
    private CSingletonIF cSingleton;
    @EJB(name="ejb/c2Singleton", beanName="CSingletonBean")
    private C2SingletonIF c2Singleton;
    @EJB(beanName="StatefulBean")
    private StatefulBean stateful;

    public void beanReferenceEqualsAndHashCodeA() {
        this.beanReferenceEqualsAndHashCode(this.aSingleton);
    }

    public void beanReferenceEqualsAndHashCodeB() {
        this.beanReferenceEqualsAndHashCode(this.bSingleton);
    }

    public void beanReferenceEqualsAndHashCodeC2() {
        this.beanReferenceEqualsAndHashCode(this.c2Singleton);
    }

    public void beanReferenceEqualsAndHashCodeA_2() {
        this.beanReferenceEqualsAndHashCodeFromEJBContext(this.aSingleton);
    }

    public void beanReferenceEqualsAndHashCodeB_2() {
        this.beanReferenceEqualsAndHashCodeFromEJBContext(this.bSingleton);
    }

    public void beanReferenceEqualsAndHashCodeC2_2() {
        this.beanReferenceEqualsAndHashCodeFromEJBContext(this.c2Singleton);
    }

    public void beanReferencesNotEqual() {
        this.appendReason("References to singletons of different interface types are not equal.");
        this.assertNotEquals(null, this.aSingleton, null);
        this.assertNotEquals(null, this.bSingleton, null);
        this.assertNotEquals(null, this.cSingleton, null);
        this.assertNotEquals(null, this.c2Singleton, null);
        this.assertNotEquals(null, this.c2Singleton, 1);
        this.assertNotEquals(null, this.c2Singleton, false);
        this.assertNotEquals(null, this.c2Singleton, this.cSingleton);
        this.assertNotEquals(null, this.cSingleton, this.c2Singleton);
        this.assertNotEquals(null, this.aSingleton, this.bSingleton);
    }

    public void beanClassHashCodeA() {
        this.beanClassHashCode(this.aSingleton, "ejb/aSingleton", "ASingletonBean", null);
    }

    public void beanClassHashCodeB() {
        this.beanClassHashCode(this.bSingleton, "ejb/bSingleton", "BSingletonBean", null);
    }

    public void beanClassHashCodeC2() {
        this.beanClassHashCode(this.c2Singleton, "ejb/c2Singleton", "CSingletonBean", CSingletonIF.class);
    }

    public void beanClassHashCodeCC2() {
        this.beanClassHashCode(this.cSingleton, "ejb/c2Singleton", "CSingletonBean", C2SingletonIF.class);
    }

    public void noDestructionAfterSystemException() {
        this.noDestructionAfterSystemException(this.aSingleton);
        this.noDestructionAfterSystemException(this.bSingleton);
        this.noDestructionAfterSystemException(this.cSingleton);
        this.noDestructionAfterSystemException(this.c2Singleton);
    }

    private void noDestructionAfterSystemException(CommonSingletonIF b) {
        int expected = b.identityHashCode();
        try {
            b.error();
            throw new RuntimeException("Expecting EJBException, but got none.");
        }
        catch (EJBException eJBException) {
            this.assertEquals("noDestructionAfterSystemException", expected, b.identityHashCode());
            return;
        }
    }

    private void beanClassHashCode(CommonSingletonIF b, final String lookupName, String beanName, Class<?> beanInterface) {
        int i;
        CommonSingletonIF resultInSameThread = (CommonSingletonIF)this.lookup(lookupName, beanName, beanInterface);
        Helper.getLogger().info("When look up in parent thread: " + resultInSameThread);
        int numOfClients = 50;
        final Vector hashCodes = new Vector();
        Thread[] threads = new Thread[50];
        for (i = 0; i < threads.length; ++i) {
            final CommonSingletonIF sg = (CommonSingletonIF)this.lookup(lookupName, beanName, beanInterface);
            threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        hashCodes.add(sg.identityHashCode());
                    }
                    catch (Exception ex) {
                        Helper.getLogger().info("Failed to look up " + lookupName + " in a spawned thread. " + ex);
                        Helper.getLogger().log(Level.FINER, null, ex);
                    }
                }
            });
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException sg) {
                // empty catch block
            }
        }
        int expected = b.identityHashCode();
        this.appendReason("Compare hashCodes from multiple invocations: " + hashCodes);
        this.assertEquals("check hashCodes.size", 50, hashCodes.size());
        int j = hashCodes.size();
        for (int i2 = 0; i2 < j; ++i2) {
            this.assertEquals(null, expected, hashCodes.get(i2));
        }
    }

    private void beanReferenceEqualsAndHashCode(CommonSingletonIF single) {
        Object fromA = this.aSingleton.getSingletonReference(single.getClass());
        Object fromB = this.bSingleton.getSingletonReference(single.getClass());
        Object fromC = this.cSingleton.getSingletonReference(single.getClass());
        Object fromS = this.stateful.getSingletonReference(single.getClass());
        this.appendReason("Compare references to a no-interface singleton bean and hashCode.");
        this.beanReferenceEqualsAndHashCode0(single, new CommonSingletonIF[]{fromA, fromB, fromC, fromS});
    }

    private void beanReferenceEqualsAndHashCodeFromEJBContext(CommonSingletonIF single) {
        Object fromA = this.aSingleton.getSingletonReferenceFromEJBContext(single.getClass());
        Object fromB = this.bSingleton.getSingletonReferenceFromEJBContext(single.getClass());
        Object fromC = this.cSingleton.getSingletonReferenceFromEJBContext(single.getClass());
        Object fromS = this.stateful.getSingletonReferenceFromEJBContext(single.getClass());
        this.appendReason("Compare references to a no-interface singleton bean and hashCode.");
        this.beanReferenceEqualsAndHashCode0(single, new CommonSingletonIF[]{fromA, fromB, fromC, fromS});
    }

    private void beanReferenceEqualsAndHashCode0(CommonSingletonIF original, CommonSingletonIF ... compareTos) {
        for (CommonSingletonIF compareTo : compareTos) {
            this.assertEquals(null, original, compareTo);
            this.assertEquals(null, original.hashCode(), compareTo.hashCode());
        }
    }
}

