/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.prepStmt.prepStmt1;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.csSchema;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class prepStmtClient1
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.prepStmt.prepStmt1";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private ResultSet rs = null;
    private Statement stmt = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private rsSchema rsSch = null;
    private csSchema csSch = null;
    private String drManager = null;
    private Properties sqlp = null;
    private PreparedStatement pstmt = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        prepStmtClient1 theTests = new prepStmtClient1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.rsSch = new rsSchema();
                this.dbSch = new dbSchema();
                this.dbSch.createData(p, this.conn);
                this.csSch = new csSchema();
                this.msg = new JDBCTestMsg();
                this.stmt = this.conn.createStatement();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception" + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetMetaData() throws Exception {
        ResultSetMetaData rsmd = null;
        ResultSetMetaData rsmdPrep = null;
        boolean statflag = false;
        try {
            String sPrepStmt = this.sqlp.getProperty("SelCoffeeAll", "");
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            try {
                this.msg.setMsg("Getting MetaData from PreparedStatement");
                rsmdPrep = this.pstmt.getMetaData();
            }
            catch (SQLException sqe) {
                statflag = true;
                this.msg.setMsg("#####PreparedStatement.getMetaData() not supported and received the expected SQLException.");
            }
            if (!statflag) {
                try {
                    this.msg.setMsg("Executing Query : " + sPrepStmt);
                    this.rs = this.stmt.executeQuery(sPrepStmt);
                    this.msg.setMsg("Getting MetaData from ResultSet");
                    rsmd = this.rs.getMetaData();
                }
                catch (SQLException sq) {
                    this.msg.printSQLError(sq, "Call to executeQuery method is Failed!");
                }
                this.msg.addOutputMsg("" + rsmdPrep.getColumnCount(), "" + rsmd.getColumnCount());
                if (rsmdPrep.getColumnCount() == rsmd.getColumnCount()) {
                    this.msg.setMsg("Call to getMetaData Method is Passed");
                } else {
                    this.msg.printTestError("getMetaData Method does not return a valid ResultSetMetaData", "Call to getMetaData Method is Failed!");
                }
            } else {
                this.msg.setMsg("Call to getMetaData Method is Passed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getMetaData is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getMetaData is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
                this.pstmt.close();
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClearParameters() throws Exception {
        ResultSet reSet = null;
        boolean sqlexcflag = false;
        try {
            String sPrepStmt = this.sqlp.getProperty("CoffeeTab_Query", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setInt(1, 1);
            this.pstmt.clearParameters();
            try {
                reSet = this.pstmt.executeQuery();
            }
            catch (SQLException sqe) {
                TestUtil.printStackTrace((Throwable)sqe);
                sqlexcflag = true;
            }
            if (sqlexcflag) {
                this.msg.setMsg("clearParameters Method clears the current Parameters ");
            } else {
                this.msg.printTestError("clearParameters Method does not clear the current Parameters", "Call to clearParameters Method is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to clearParameters is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to clearParameters is Failed!");
        }
        finally {
            try {
                if (reSet != null) {
                    reSet.close();
                }
                this.pstmt.close();
            }
            catch (Exception sqle) {}
        }
    }

    public void testExecute01() throws Exception {
        try {
            String sPrepStmt = this.sqlp.getProperty("CoffeeTab_Delete", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setInt(1, 1);
            boolean retValue = this.pstmt.execute();
            this.msg.addOutputMsg("false", "" + retValue);
            if (!retValue) {
                this.msg.setMsg("execute Method executes the SQL Statement ");
            } else {
                this.msg.printTestError("execute Method does not execute the SQL Statment", "Call to execute Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to execute is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to execute is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecute03() throws Exception {
        boolean sqlexcflag = false;
        try {
            String sPrepStmt = this.sqlp.getProperty("CoffeeTab_Delete", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            try {
                boolean retValue = this.pstmt.execute();
            }
            catch (SQLException sqe) {
                TestUtil.printStackTrace((Throwable)sqe);
                sqlexcflag = true;
            }
            if (sqlexcflag) {
                this.msg.setMsg("execute Method executes the SQL Statement ");
            } else {
                this.msg.printTestError("execute Method does not execute the SQL Statment", "Call to execute Method is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to execute is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to execute is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
            }
            catch (Exception sqle) {}
        }
    }

    public void testExecuteQuery01() throws Exception {
        ResultSet reSet = null;
        try {
            String sPrepStmt = this.sqlp.getProperty("CoffeeTab_Query", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setInt(1, 1);
            reSet = this.pstmt.executeQuery();
            if (reSet != null) {
                this.msg.setMsg("executeQuery Method executes the SQL Statement ");
            } else {
                this.msg.printTestError("executeQuery Method does not execute the SQL Statment", "Call to executeQuery Method is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to executeQuery is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeQuery is Failed!");
        }
        finally {
            try {
                if (reSet != null) {
                    reSet.close();
                }
                this.pstmt.close();
            }
            catch (Exception sqle) {}
        }
    }

    public void testExecuteQuery02() throws Exception {
        ResultSet reSet = null;
        try {
            String sPrepStmt = this.sqlp.getProperty("CoffeeTab_Query", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setInt(1, 0);
            reSet = this.pstmt.executeQuery();
            if (!reSet.next()) {
                this.msg.setMsg("executeQuery Method executes the SQL Statement ");
            } else {
                this.msg.printTestError("executeQuery Method does not execute the SQL Statment", "Call to executeQuery Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to executeQuery is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeQuery is Failed!");
        }
        finally {
            try {
                if (reSet != null) {
                    reSet.close();
                }
                this.pstmt.close();
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecuteQuery03() throws Exception {
        ResultSet reSet = null;
        boolean sqlexcflag = false;
        try {
            String sPrepStmt = this.sqlp.getProperty("CoffeeTab_Query", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            try {
                reSet = this.pstmt.executeQuery();
            }
            catch (SQLException sqe) {
                TestUtil.printStackTrace((Throwable)sqe);
                sqlexcflag = true;
            }
            if (sqlexcflag) {
                this.msg.setMsg("executeQuery Method executes the SQL Statement ");
            } else {
                this.msg.printTestError("executeQuery Method does not execute the SQL Statment", "Call to executeQuery Method is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to executeQuery is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeQuery is Failed!");
        }
        finally {
            try {
                if (reSet != null) {
                    reSet.close();
                }
                this.pstmt.close();
            }
            catch (Exception sqle) {}
        }
    }

    public void testExecuteUpdate01() throws Exception {
        try {
            String sPrepStmt = this.sqlp.getProperty("CoffeeTab_Delete", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setInt(1, 1);
            int retValue = this.pstmt.executeUpdate();
            if (retValue >= 0) {
                this.msg.setMsg("executeUpdate Method executes the SQL Statement ");
            } else {
                this.msg.printTestError("executeUpdate Method does not execute the SQL Statment", "Call to executUpdate Method is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to executeUpdate is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeUpdate is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
            }
            catch (Exception sqle) {}
        }
    }

    public void testExecuteUpdate02() throws Exception {
        try {
            String sPrepStmt = this.sqlp.getProperty("CoffeeTab_Delete", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setInt(1, 0);
            int retValue = this.pstmt.executeUpdate();
            if (retValue >= 0) {
                this.msg.setMsg("executeUpdate Method executes the SQL Statement ");
            } else {
                this.msg.printTestError("executeUpdate Method does not execute the SQL Statment", "Call to executeUpdate is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to executeUpdate is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeUpdate is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecuteUpdate03() throws Exception {
        boolean sqlexcflag = false;
        try {
            String sPrepStmt = this.sqlp.getProperty("CoffeeTab_Delete", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            try {
                int retValue = this.pstmt.executeUpdate();
            }
            catch (SQLException sqe) {
                TestUtil.printStackTrace((Throwable)sqe);
                sqlexcflag = true;
            }
            if (sqlexcflag) {
                this.msg.setMsg("executeUpdate Method executes the SQL Statement ");
            } else {
                this.msg.printTestError("executeUpdate Method does not execute the SQL Statment", "Call to executeUpdate is Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to executeUpdate is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to executeUpdate is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetBigDecimal01() throws Exception {
        BigDecimal rBigDecimalVal = null;
        BigDecimal minBigDecimalVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Numeric_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("extract the Value of Minimum value to be Updated");
            String sminBigDecimalVal = this.rsSch.extractVal("Numeric_Tab", 2, this.sqlp, this.conn);
            minBigDecimalVal = new BigDecimal(sminBigDecimalVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setBigDecimal(1, minBigDecimalVal);
            int retVal = this.pstmt.executeUpdate();
            this.msg.addOutputMsg("1", "" + retVal);
            if (retVal != 1) {
                this.msg.printTestError("Minimum Value not being updated in the Min_Val column", "Call to executeUpdate is Failed!");
            }
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Numeric_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            rBigDecimalVal = this.rs.getBigDecimal(1);
            this.msg.addOutputMsg(" " + minBigDecimalVal, "" + rBigDecimalVal);
            if (rBigDecimalVal.compareTo(minBigDecimalVal) == 0) {
                this.msg.setMsg("setBigDecimal Method sets the designated parameter to a BigDecimal value ");
            } else {
                this.msg.printTestError("setBigDecimal Method does not set the designated parameter to a BigDecimal value ", "Call to setBigDecimal Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setBigDecimal Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setBigDecimal Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
                this.pstmt.close();
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetBigDecimal02() throws Exception {
        BigDecimal maxBigDecimalVal = null;
        BigDecimal rBigDecimalVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Numeric_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("extract the Value of Maximum value to be Updated ");
            String smaxBigDecimalVal = this.rsSch.extractVal("Numeric_Tab", 1, this.sqlp, this.conn);
            maxBigDecimalVal = new BigDecimal(smaxBigDecimalVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setBigDecimal(1, maxBigDecimalVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Numeric_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rBigDecimalVal = this.rs.getBigDecimal(1);
            this.msg.addOutputMsg(" " + maxBigDecimalVal, "" + rBigDecimalVal);
            if (rBigDecimalVal.compareTo(maxBigDecimalVal) == 0) {
                this.msg.setMsg("setBigDecimal Method sets the designated parameter to a BigDecimal value ");
            } else {
                this.msg.printTestError("setBigDecimal Method does not set the designated parameter to a BigDecimal value ", "Call to setBigDecimal Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setBigDecimal Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setBigDecimal Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
                this.pstmt.close();
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetBoolean01() throws Exception {
        try {
            this.rsSch.createTab("Bit_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Bit_Tab_Max_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("extract the Value of Minimum value to be Updated");
            boolean bminBooleanVal = this.rsSch.extractValAsBoolVal("Bit_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setBoolean(1, bminBooleanVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Bit_Query_Max", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            boolean rBooleanVal = this.rs.getBoolean(1);
            this.msg.addOutputMsg(" " + bminBooleanVal, "" + rBooleanVal);
            if (rBooleanVal == bminBooleanVal) {
                this.msg.setMsg("setBoolean Method sets the designated parameter to a Boolean value ");
            } else {
                this.msg.printTestError("setBoolean Method does not set the designated parameter to a Boolean value ", "Call to setBoolean Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setBoolean is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setBoolean is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
                this.pstmt.close();
                this.rsSch.dropTab("Bit_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetBoolean02() throws Exception {
        try {
            this.rsSch.createTab("Bit_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Bit_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("extract the Value of Maximum value to be Updated");
            boolean bmaxBooleanVal = this.rsSch.extractValAsBoolVal("Bit_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setBoolean(1, bmaxBooleanVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Bit_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            boolean rBooleanVal = this.rs.getBoolean(1);
            this.msg.addOutputMsg(" " + bmaxBooleanVal, "" + rBooleanVal);
            if (rBooleanVal == bmaxBooleanVal) {
                this.msg.setMsg("setBoolean Method sets the designated parameter to a Boolean value ");
            } else {
                this.msg.printTestError("setBoolean Method does not set the designated parameter to a Boolean value ", "Call to setBoolean is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setBoolean is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setBoolean is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
                this.pstmt.close();
                this.rsSch.dropTab("Bit_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetByte01() throws Exception {
        byte bminByteVal = 0;
        byte rByteVal = 0;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Tinyint_Tab_Max_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("extract the Value of Minimum value to be Updated ");
            String sminByteVal = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            bminByteVal = Byte.parseByte(sminByteVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setByte(1, bminByteVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Tinyint_Query_Max", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            rByteVal = this.rs.getByte(1);
            this.msg.addOutputMsg(" " + bminByteVal, "" + rByteVal);
            if (rByteVal == bminByteVal) {
                this.msg.setMsg("setByte Method sets the designated parameter to a Byte value ");
            } else {
                this.msg.printTestError("setByte Method does not set the designated parameter to a Byte value ", "Call to setByte Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setByte Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setByte Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
                this.pstmt.close();
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetByte02() throws Exception {
        byte bmaxByteVal = 0;
        byte rByteVal = 0;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Tinyint_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("extract the Value of Maximum value to be Updated");
            String smaxByteVal = this.rsSch.extractVal("Tinyint_Tab", 1, this.sqlp, this.conn);
            bmaxByteVal = Byte.parseByte(smaxByteVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setByte(1, bmaxByteVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Tinyint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rByteVal = this.rs.getByte(1);
            this.msg.addOutputMsg(" " + bmaxByteVal, "" + rByteVal);
            if (rByteVal == bmaxByteVal) {
                this.msg.setMsg("setByte Method sets the designated parameter to a Byte value ");
            } else {
                this.msg.printTestError("setByte Method does not set the designated parameter to a Byte value ", "Call to setByte Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setByte is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setByte is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
                this.pstmt.close();
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetFloat01() throws Exception {
        float rFloatVal = 0.0f;
        float minFloatVal = 0.0f;
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Float_Tab_Max_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("extract the Value of Minimum value to be Updated");
            String sminFloatVal = this.rsSch.extractVal("Float_Tab", 2, this.sqlp, this.conn);
            minFloatVal = Float.parseFloat(sminFloatVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setFloat(1, minFloatVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Float_Query_Max", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            rFloatVal = this.rs.getFloat(1);
            this.msg.addOutputMsg(" " + minFloatVal, "" + rFloatVal);
            if (rFloatVal == minFloatVal) {
                this.msg.setMsg("setFloat Method sets the designated parameter to a float value ");
            } else {
                this.msg.printTestError("setFloat Method does not set the designated parameter to a float value ", "Call to setFloat Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setFloat Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setFloat Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
                this.pstmt.close();
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetFloat02() throws Exception {
        float maxFloatVal = 0.0f;
        float rFloatVal = 0.0f;
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Float_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("extract the Value of Maximum value to be Updated ");
            String smaxFloatVal = this.rsSch.extractVal("Float_Tab", 1, this.sqlp, this.conn);
            maxFloatVal = Float.parseFloat(smaxFloatVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setFloat(1, maxFloatVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Float_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rFloatVal = this.rs.getFloat(1);
            this.msg.addOutputMsg(" " + maxFloatVal, "" + rFloatVal);
            if (rFloatVal == maxFloatVal) {
                this.msg.setMsg("setFloat Method sets the designated parameter to a float value ");
            } else {
                this.msg.printTestError("setFloat Method does not set the designated parameter to a float value ", "Call to setFloat Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setFloat Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setFloat Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
                this.pstmt.close();
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetInt01() throws Exception {
        int rIntegerVal = 0;
        int minIntegerVal = 0;
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Integer_Tab_Max_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg("extract the Value of Minimum value to be Updated");
            String sminIntegerVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            minIntegerVal = Integer.parseInt(sminIntegerVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setInt(1, minIntegerVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Integer_Query_Max", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            rIntegerVal = this.rs.getInt(1);
            this.msg.addOutputMsg(" " + minIntegerVal, "" + rIntegerVal);
            if (rIntegerVal == minIntegerVal) {
                this.msg.setMsg("setInt Method sets the designated parameter to a int value ");
            } else {
                this.msg.printTestError("setInteger Method does not set the designated parameter to a int value ", "Call to setInt Method is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setInt\t Method is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setInt Method is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
                this.pstmt.close();
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            this.stmt.close();
            this.pstmt.close();
            this.dbSch.destroyData(this.conn);
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

