/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.container.event;

import jakarta.ejb.Stateless;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.SessionBeanType;
import java.lang.reflect.Type;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.ee.EnterpriseArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.container.event.Cow;
import org.jboss.cdi.tck.tests.extensions.container.event.CowLocal;
import org.jboss.cdi.tck.tests.extensions.container.event.Farm;
import org.jboss.cdi.tck.tests.extensions.container.event.ProcessAnnotatedTypeObserver;
import org.jboss.cdi.tck.tests.extensions.container.event.ProcessBeanObserver;
import org.jboss.cdi.tck.tests.extensions.container.event.ProcessInjectionTargetObserver;
import org.jboss.cdi.tck.tests.extensions.container.event.Sheep;
import org.jboss.cdi.tck.tests.extensions.container.event.SheepInterceptor;
import org.jboss.cdi.tck.tests.extensions.container.event.SheepLocal;
import org.jboss.cdi.tck.tests.extensions.container.event.Tame;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"javaee-full"})
@SpecVersion(spec="cdi", version="2.0")
public class ContainerEventTest
extends AbstractTest {
    @Deployment
    public static EnterpriseArchive createTestArchive() {
        return (EnterpriseArchive)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().withTestClassPackage(ContainerEventTest.class)).withBeansXml(new BeansXml(BeanDiscoveryMode.ALL))).withExtensions(new Class[]{ProcessBeanObserver.class, ProcessInjectionTargetObserver.class, ProcessAnnotatedTypeObserver.class})).withEjbJarXml("ejb-jar.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bean_discovery_steps", id="f"), @SpecAssertion(section="process_injection_target", id="aaa")})
    public void testProcessInjectionTargetFiredForManagedBean() {
        assert (ProcessInjectionTargetObserver.getManagedBeanType() != null);
        this.validateManagedBean(ProcessInjectionTargetObserver.getManagedBeanType());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_target_ee", id="aab"), @SpecAssertion(section="process_injection_target_ee", id="abb"), @SpecAssertion(section="bean_discovery_steps_ee", id="bb")})
    public void testProcessInjectionTargetFiredForSessionBean() {
        assert (ProcessInjectionTargetObserver.getStatelessSessionBeanType() != null);
        assert (ProcessInjectionTargetObserver.getStatefulSessionBeanType() != null);
        this.validateStatelessSessionBean((Annotated)ProcessInjectionTargetObserver.getStatelessSessionBeanType());
        this.validateStatefulSessionBean((Annotated)ProcessInjectionTargetObserver.getStatefulSessionBeanType());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_target_ee", id="aaf"), @SpecAssertion(section="process_injection_target_ee", id="abf"), @SpecAssertion(section="bean_discovery_steps_ee", id="bh")})
    public void testProcessInjectionTargetFiredForSessionBeanInterceptor() {
        assert (ProcessInjectionTargetObserver.getSessionBeanInterceptorType() != null);
        this.validateSessionBeanInterceptor(ProcessInjectionTargetObserver.getSessionBeanInterceptorType());
    }

    @Test
    @SpecAssertion(section="type_discovery_steps", id="c")
    public void testProcessAnnotatedTypeFiredForManagedBean() {
        assert (ProcessAnnotatedTypeObserver.getManagedBeanType() != null);
        this.validateManagedBean(ProcessAnnotatedTypeObserver.getManagedBeanType());
    }

    @Test
    @SpecAssertion(section="type_bean_discovery_ee", id="bb")
    public void testProcessAnnotatedTypeFiredForSessionBean() {
        assert (ProcessAnnotatedTypeObserver.getStatelessSessionBeanType() != null);
        assert (ProcessAnnotatedTypeObserver.getStatefulSessionBeanType() != null);
        this.validateStatelessSessionBean((Annotated)ProcessAnnotatedTypeObserver.getStatelessSessionBeanType());
        this.validateStatefulSessionBean((Annotated)ProcessAnnotatedTypeObserver.getStatefulSessionBeanType());
    }

    @Test
    @SpecAssertion(section="type_bean_discovery_ee", id="bh")
    public void testProcessAnnotatedTypeFiredForSessionBeanInterceptor() {
        assert (ProcessAnnotatedTypeObserver.getSessionBeanInterceptorType() != null);
        this.validateSessionBeanInterceptor(ProcessAnnotatedTypeObserver.getSessionBeanInterceptorType());
    }

    @Test
    @SpecAssertion(section="process_bean", id="ba")
    public void testProcessManagedBeanFired() {
        assert (ProcessBeanObserver.getProcessManagedBeanType() != null);
        this.validateManagedBean(ProcessBeanObserver.getProcessManagedBeanType());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_ee", id="ca"), @SpecAssertion(section="bean_discovery_steps_ee", id="fb")})
    public void testProcessSessionBeanFiredForStatelessSessionBean() {
        assert (ProcessBeanObserver.getProcessStatelessSessionBeanAnnotatedType() != null);
        this.validateStatelessSessionBean((Annotated)ProcessBeanObserver.getProcessStatelessSessionBeanAnnotatedType());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_ee", id="ca"), @SpecAssertion(section="bean_discovery_steps_ee", id="fb")})
    public void testProcessSessionBeanFiredForStatefulSessionBean() {
        assert (ProcessBeanObserver.getProcessStatefulSessionBeanAnnotatedType() != null);
        this.validateStatefulSessionBean((Annotated)ProcessBeanObserver.getProcessStatefulSessionBeanAnnotatedType());
    }

    @Test
    @SpecAssertion(section="process_bean_ee", id="hb")
    public void testGetEJBName() {
        assert (ProcessBeanObserver.getProcessStatelessSessionBeanName().equals("sheep"));
        assert (ProcessBeanObserver.getProcessStatefulSessionBeanName().equals("cow"));
    }

    @Test
    @SpecAssertion(section="process_bean_ee", id="hc")
    public void testGetSessionBeanType() {
        assert (ProcessBeanObserver.getProcessStatelessSessionBeanType().equals((Object)SessionBeanType.STATELESS));
        assert (ProcessBeanObserver.getProcessStatefulSessionBeanType().equals((Object)SessionBeanType.STATEFUL));
    }

    private void validateStatelessSessionBean(Annotated type) {
        assert (type.getBaseType().equals(Sheep.class));
        assert (this.typeSetMatches(type.getTypeClosure(), new Type[]{Sheep.class, SheepLocal.class, Object.class}));
        assert (type.getAnnotations().size() == 2);
        assert (this.annotationSetMatches(type.getAnnotations(), new Class[]{Tame.class, Stateless.class}));
    }

    private void validateStatefulSessionBean(Annotated type) {
        assert (type.getBaseType().equals(Cow.class));
        assert (this.typeSetMatches(type.getTypeClosure(), new Type[]{Cow.class, CowLocal.class, Object.class}));
        assert (type.getAnnotations().size() == 0);
    }

    private void validateSessionBeanInterceptor(AnnotatedType<SheepInterceptor> type) {
        assert (type.getBaseType().equals(SheepInterceptor.class));
        assert (this.typeSetMatches(type.getTypeClosure(), new Type[]{SheepInterceptor.class, Object.class}));
        assert (type.getAnnotations().size() == 0);
        assert (type.getFields().size() == 0);
        assert (type.getMethods().size() == 1);
    }

    private void validateManagedBean(AnnotatedType<Farm> type) {
        assert (type.getBaseType().equals(Farm.class));
        assert (this.typeSetMatches(type.getTypeClosure(), new Type[]{Farm.class, Object.class}));
        assert (type.getFields().size() == 1);
        assert (((AnnotatedField)type.getFields().iterator().next()).isAnnotationPresent(Produces.class));
        assert (type.getMethods().size() == 1);
        assert (((AnnotatedMethod)type.getMethods().iterator().next()).isAnnotationPresent(Produces.class));
    }
}

