/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.pluggability.jsonprovidertests;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.common.base.EETest;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.common.vehicle.servlet.ServletVehicle;
import com.sun.ts.tests.jsonp.common.JSONP_Data;
import com.sun.ts.tests.jsonp.common.JSONP_Util;
import com.sun.ts.tests.jsonp.common.MyBufferedInputStream;
import com.sun.ts.tests.jsonp.common.MyBufferedReader;
import com.sun.ts.tests.jsonp.common.MyBufferedWriter;
import com.sun.ts.tests.jsonp.common.MyJsonLocation;
import com.sun.ts.tests.jsonp.provider.MyJsonGenerator;
import com.sun.ts.tests.jsonp.provider.MyJsonGeneratorFactory;
import com.sun.ts.tests.jsonp.provider.MyJsonParser;
import com.sun.ts.tests.jsonp.provider.MyJsonParserFactory;
import com.sun.ts.tests.jsonp.provider.MyJsonProvider;
import com.sun.ts.tests.jsonp.provider.MyJsonReader;
import com.sun.ts.tests.jsonp.provider.MyJsonReaderFactory;
import com.sun.ts.tests.jsonp.provider.MyJsonWriter;
import com.sun.ts.tests.jsonp.provider.MyJsonWriterFactory;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonException;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.protocol.common.TargetVehicle;

@Tags(value={@Tag(value="tck-javatest"), @Tag(value="platform"), @Tag(value="web"), @Tag(value="jsonp")})
@ExtendWith(value={ArquillianExtension.class})
public class ClientServletTest
extends ServiceEETest {
    private static final System.Logger logger = System.getLogger(ClientServletTest.class.getName());
    private static String packagePath = ClientServletTest.class.getPackageName().replace(".", "/");
    public final String TEMP_DIR = System.getProperty("java.io.tmpdir", "/tmp");
    private boolean providerJarDeployed = false;
    static final String VEHICLE_ARCHIVE = "jsonprovidertests_servlet_vehicle";
    private static final String MY_JSONPROVIDER_CLASS = "com.sun.ts.tests.jsonp.provider.MyJsonProvider";
    private String providerPath = null;

    @BeforeEach
    void logStartTest(TestInfo testInfo) throws Exception {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @BeforeEach
    public void setup() throws Exception {
        this.createProviderJar();
        logger.log(System.Logger.Level.INFO, "setup ok");
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) throws Exception {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    public void cleanup() throws Exception {
        this.removeProviderJarFromCP();
        MyJsonProvider.clearCalls();
        MyJsonGenerator.clearCalls();
        logger.log(System.Logger.Level.INFO, "cleanup ok");
    }

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="jsonprovidertests_servlet_vehicle", testable=true)
    public static WebArchive createServletDeployment() throws Exception {
        String providerPackagePath = MyJsonProvider.class.getPackageName().replace(".", "/");
        WebArchive jsonprovidertests_servlet_vehicle_web = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsonprovidertests_servlet_vehicle_web.war");
        ((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)jsonprovidertests_servlet_vehicle_web.addClass(ClientServletTest.class)).addClass(ServletVehicle.class)).addClass(VehicleRunnerFactory.class)).addClass(VehicleRunnable.class)).addClass(VehicleClient.class)).addClass(JSONP_Data.class)).addClass(JSONP_Util.class)).addClass(MyBufferedReader.class)).addClass(MyBufferedWriter.class)).addClass(MyBufferedInputStream.class)).addClass(MyJsonLocation.class)).addClass(EETest.class)).addClass(ServiceEETest.class);
        URL jsonURL = ClientServletTest.class.getClassLoader().getResource("com/sun/ts/tests/jsonp/pluggability/jsonprovidertests/jsonArrayWithAllTypesOfData.json");
        jsonprovidertests_servlet_vehicle_web.addAsWebInfResource(jsonURL, "classes/jsonArrayWithAllTypesOfData.json");
        jsonURL = ClientServletTest.class.getClassLoader().getResource("com/sun/ts/tests/jsonp/pluggability/jsonprovidertests/jsonObjectWithAllTypesOfData.json");
        jsonprovidertests_servlet_vehicle_web.addAsWebInfResource(jsonURL, "classes/jsonObjectWithAllTypesOfData.json");
        URL webXML = ClientServletTest.class.getClassLoader().getResource("com/sun/ts/tests/jsonp/pluggability/jsonprovidertests/servlet_vehicle_web.xml");
        jsonprovidertests_servlet_vehicle_web.setWebXML(webXML);
        JavaArchive jarArchive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jsonp_alternate_provider.jar")).addClass(MyJsonGenerator.class)).addClass(MyJsonGeneratorFactory.class)).addClass(MyJsonParser.class)).addClass(MyJsonParserFactory.class)).addClass(MyJsonProvider.class)).addClass(MyJsonReader.class)).addClass(MyJsonReaderFactory.class)).addClass(MyJsonWriter.class)).addClass(MyJsonWriterFactory.class)).addAsResource((Asset)new UrlAsset(MyJsonProvider.class.getClassLoader().getResource(providerPackagePath + "/META-INF/services/jakarta.json.spi.JsonProvider")), "META-INF/services/jakarta.json.spi.JsonProvider");
        jsonprovidertests_servlet_vehicle_web.addAsLibrary((Archive)jarArchive);
        return jsonprovidertests_servlet_vehicle_web;
    }

    public void removeProviderJarFromCP() throws Exception {
        if (this.providerJarDeployed) {
            URLClassLoader currentThreadClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader.getParent());
            currentThreadClassLoader.close();
            this.providerJarDeployed = false;
        }
    }

    public void createProviderJar() throws Exception {
        String providerPackagePath = MyJsonProvider.class.getPackageName().replace(".", "/");
        JavaArchive jarArchive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jsonp_alternate_provider.jar")).addClass(MyJsonGenerator.class)).addClass(MyJsonGeneratorFactory.class)).addClass(MyJsonParser.class)).addClass(MyJsonParserFactory.class)).addClass(MyJsonProvider.class)).addClass(MyJsonReader.class)).addClass(MyJsonReaderFactory.class)).addClass(MyJsonWriter.class)).addClass(MyJsonWriterFactory.class)).addAsResource((Asset)new UrlAsset(MyJsonProvider.class.getClassLoader().getResource(providerPackagePath + "/META-INF/services/jakarta.json.spi.JsonProvider")), "META-INF/services/jakarta.json.spi.JsonProvider");
        ((ZipExporter)jarArchive.as(ZipExporter.class)).exportTo(new File(this.TEMP_DIR + File.separator + "jsonp_alternate_provider.jar"), true);
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{new File(this.TEMP_DIR + File.separator + "jsonp_alternate_provider.jar").toURL()}, currentThreadClassLoader);
        Thread.currentThread().setContextClassLoader(urlClassLoader);
        this.providerJarDeployed = true;
    }

    public static void main(String[] args) {
        ClientServletTest theTests = new ClientServletTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
    }

    @Test
    @TargetVehicle(value="servlet")
    public void jsonProviderTest1() throws Exception {
        boolean pass = true;
        try {
            JsonProvider provider = JsonProvider.provider();
            String providerClass = provider.getClass().getName();
            logger.log(System.Logger.Level.INFO, "provider class=" + providerClass);
            if (providerClass.equals(MY_JSONPROVIDER_CLASS)) {
                logger.log(System.Logger.Level.INFO, "Current provider is my provider - expected.");
            } else {
                logger.log(System.Logger.Level.ERROR, "Current provider is not my provider - unexpected.");
                pass = false;
                ServiceLoader<JsonProvider> loader = ServiceLoader.load(JsonProvider.class);
                Iterator<JsonProvider> it = loader.iterator();
                ArrayList<JsonProvider> providers = new ArrayList<JsonProvider>();
                while (it.hasNext()) {
                    providers.add(it.next());
                }
                logger.log(System.Logger.Level.INFO, "Providers: " + providers);
            }
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest1 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest1 Failed");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void jsonProviderTest2() throws Exception {
        boolean pass = true;
        String expString = "public JsonGenerator createGenerator(Writer)";
        String expString2 = "public JsonGenerator writeStartArray()";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonGenerator generator = Json.createGenerator((Writer)new StringWriter());
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
            generator.writeStartArray();
            String actString2 = MyJsonGenerator.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI generator method was called: " + expString2);
            pass = JSONP_Util.assertEquals(expString2, actString2);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest2 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest2 Failed");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void jsonProviderTest3() throws Exception {
        boolean pass = true;
        String expString = "public JsonGenerator createGenerator(OutputStream)";
        String expString2 = "public JsonGenerator writeStartObject()";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonGenerator generator = Json.createGenerator((OutputStream)new ByteArrayOutputStream());
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
            generator.writeStartObject();
            String actString2 = MyJsonGenerator.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI generator method was called: " + expString2);
            pass = JSONP_Util.assertEquals(expString2, actString2);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest3 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest3 Failed");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void jsonProviderTest4() throws Exception {
        boolean pass = true;
        String expString = "public JsonParser createParser(Reader)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonParser parser = Json.createParser((Reader)new StringReader("{}"));
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest4 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest4 Failed");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void jsonProviderTest5() throws Exception {
        boolean pass = true;
        String expString = "public JsonParser createParser(InputStream)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonParser parser = Json.createParser((InputStream)JSONP_Util.getInputStreamFromString("{}"));
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest5 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest5 Failed");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void jsonProviderTest6() throws Exception {
        boolean pass = true;
        String expString = "public JsonParserFactory createParserFactory(Map<String, ?>)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonParserFactory parserFactory = Json.createParserFactory(JSONP_Util.getEmptyConfig());
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest6 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest6 Failed");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void jsonProviderTest7() throws Exception {
        boolean pass = true;
        String expString = "public JsonParserFactory createParserFactory(Map<String, ?>)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonParserFactory parserFactory = Json.createParserFactory(new HashMap());
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest7 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest7 Failed");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void jsonProviderTest8() throws Exception {
        boolean pass = true;
        String expString = "public JsonGeneratorFactory createGeneratorFactory(Map<String, ?>)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonGeneratorFactory generatorFactory = Json.createGeneratorFactory(new HashMap());
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest8 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest8 Failed");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void jsonProviderTest9() throws Exception {
        boolean pass = true;
        String expString = "public JsonWriterFactory createWriterFactory(Map<String, ?>)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonWriterFactory factory = Json.createWriterFactory(JSONP_Util.getEmptyConfig());
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest9 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest9 Failed");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void jsonProviderTest10() throws Exception {
        boolean pass = true;
        String expString = "public JsonParser createParser(InputStream)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            InputStream in = null;
            JsonParser parser = Json.createParser(in);
            pass = false;
        }
        catch (JsonException e) {
            logger.log(System.Logger.Level.INFO, "Caught expected JsonException: " + e);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest10 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest10 Failed");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void jsonProviderTest11() throws Exception {
        boolean pass = true;
        String expString = "public JsonArrayBuilder createArrayBuilder()";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest11 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest11 Failed");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void jsonProviderTest12() throws Exception {
        boolean pass = true;
        String expString = "public JsonObjectBuilder createObjectBuilder()";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest12 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest12 Failed");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void jsonProviderTest13() throws Exception {
        boolean pass = true;
        String expString = "public JsonBuilderFactory createBuilderFactory(Map<String, ?>)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonBuilderFactory objectBuilder = Json.createBuilderFactory(JSONP_Util.getEmptyConfig());
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest13 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest13 Failed");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void jsonProviderTest14() throws Exception {
        boolean pass = true;
        String expString = "public JsonReader createReader(Reader)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonReader reader = Json.createReader((Reader)new StringReader("{}"));
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest14 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest14 Failed");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void jsonProviderTest15() throws Exception {
        boolean pass = true;
        String expString = "public JsonReader createReader(InputStream)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonReader reader = Json.createReader((InputStream)JSONP_Util.getInputStreamFromString("{}"));
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest15 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest15 Failed");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void jsonProviderTest16() throws Exception {
        boolean pass = true;
        String expString = "public JsonWriter createWriter(Writer)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonWriter writer = Json.createWriter((Writer)new StringWriter());
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest16 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest16 Failed");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void jsonProviderTest17() throws Exception {
        boolean pass = true;
        String expString = "public JsonWriter createWriter(OutputStream)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonWriter writer = Json.createWriter((OutputStream)new ByteArrayOutputStream());
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest17 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest17 Failed");
        }
    }

    @Test
    @TargetVehicle(value="servlet")
    public void jsonProviderTest18() throws Exception {
        boolean pass = true;
        String expString = "public JsonReaderFactory createReaderFactory(Map<String, ?>)";
        try {
            logger.log(System.Logger.Level.INFO, "Calling SPI provider method: " + expString);
            JsonReaderFactory factory = Json.createReaderFactory(JSONP_Util.getEmptyConfig());
            String actString = MyJsonProvider.getCalls();
            logger.log(System.Logger.Level.INFO, "Verify SPI provider method was called: " + expString);
            pass = JSONP_Util.assertEquals(expString, actString);
        }
        catch (Exception e) {
            throw new Exception("jsonProviderTest18 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonProviderTest18 Failed");
        }
    }
}

