/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.tagext.resource.listener;

import ee.jakarta.tck.pages.common.client.ServletAbstractUrlClient;
import ee.jakarta.tck.pages.common.servlet.GenericTCKServlet;
import ee.jakarta.tck.pages.common.util.Data;
import ee.jakarta.tck.pages.common.util.ServletTestUtil;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@Tags(value={@Tag(value="jsp"), @Tag(value="platform")})
@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends ServletAbstractUrlClient {
    private static final System.Logger logger = System.getLogger(URLClientIT.class.getName());

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    public URLClientIT() throws Exception {
        this.setServletName("TestServlet");
        this.setContextRoot("/jsp_tagext_resource_listener_web");
    }

    @Deployment(testable=true)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_tagext_resource_listener_web.war");
        archive.addClasses(new Class[]{ServletTestUtil.class, Data.class, GenericTCKServlet.class});
        archive.addPackages(true, Filters.exclude((Class[])new Class[]{URLClientIT.class}), new String[]{URLClientIT.class.getPackageName()});
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_tagext_resource_listener_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tagext_resource_listener.tld", "tagext_resource_listener.tld");
        return archive;
    }

    @Test
    @RunAsClient
    public void ContextListenerTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "testResourceCL");
        this.invoke();
    }

    @Test
    @RunAsClient
    public void ContextAttributeListenerTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "testResourceCAL");
        this.invoke();
    }

    @Test
    @RunAsClient
    public void RequestListenerTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "testResourceRL");
        this.invoke();
    }

    @Test
    @RunAsClient
    public void RequestAttributeListenerTest() throws Exception {
        TEST_PROPS.setProperty("apitest", "testResourceRAL");
        this.invoke();
    }
}

