/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.ee.packaging.ejb.descriptor;

import ee.jakarta.tck.persistence.ee.packaging.ejb.descriptor.Stateful3IF;
import ee.jakarta.tck.persistence.ee.packaging.ejb.descriptor.Stateless3IF;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJB;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.logging.Level;
import java.util.logging.Logger;

@Dependent
public class Client {
    private static Logger log = Logger.getLogger(Client.class.getName());
    @Dependent
    @Inject
    Instance<Stateful3IF> statefulBeanInstance;
    Stateful3IF statefulBean;
    @EJB
    private Stateless3IF statelessBean;

    @PostConstruct
    public void setup() {
        try {
            log.info("Look up Stateful3IF: " + String.valueOf(this.statefulBean));
            log.info("Look up Stateless3IF: " + String.valueOf(this.statelessBean));
            this.cleanup();
        }
        catch (Exception e) {
            throw new IllegalStateException("Setup Failed!", e);
        }
    }

    public void test1() throws Exception {
        log.info("Begin test1");
        boolean pass = false;
        try {
            this.statefulBean = (Stateful3IF)this.statefulBeanInstance.get();
            pass = this.statefulBean.test1();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unexpected Exception :", e);
            throw e;
        }
        finally {
            this.cleanup();
        }
        if (!pass) {
            throw new Exception("test1 failed");
        }
    }

    public void test2() throws Exception {
        log.info("Begin test2");
        boolean pass = false;
        try {
            this.statefulBean = (Stateful3IF)this.statefulBeanInstance.get();
            pass = this.statefulBean.test2();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unexpected Exception :", e);
            throw e;
        }
        finally {
            this.cleanup();
        }
        if (!pass) {
            throw new Exception("test2 failed");
        }
    }

    public void test3() throws Exception {
        log.info("Begin test3");
        boolean pass = false;
        try {
            this.statefulBean = (Stateful3IF)this.statefulBeanInstance.get();
            pass = this.statefulBean.test3();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unexpected Exception :", e);
            throw e;
        }
        finally {
            this.cleanup();
        }
        if (!pass) {
            throw new Exception("test3 failed");
        }
    }

    public void test4() throws Exception {
        log.info("Begin test4");
        boolean pass = false;
        try {
            this.statefulBean = (Stateful3IF)this.statefulBeanInstance.get();
            pass = this.statefulBean.test4();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unexpected Exception :", e);
            throw e;
        }
        finally {
            this.cleanup();
        }
        if (!pass) {
            throw new Exception("test4 failed");
        }
    }

    public void test5() throws Exception {
        log.info("Begin test5");
        boolean pass = false;
        try {
            pass = this.statelessBean.test5();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unexpected Exception :", e);
            throw e;
        }
        finally {
            this.cleanup();
        }
        if (!pass) {
            throw new Exception("test5 failed");
        }
    }

    public void test6() throws Exception {
        log.info("Begin test6");
        boolean pass = false;
        try {
            this.statefulBean = (Stateful3IF)this.statefulBeanInstance.get();
            pass = this.statefulBean.test6();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unexpected Exception :", e);
            throw e;
        }
        finally {
            this.cleanup();
        }
        if (!pass) {
            throw new Exception("test6 failed");
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.statefulBean != null) {
                this.statefulBean.removeTestData();
                this.statefulBeanInstance.destroy((Object)this.statefulBean);
                this.statefulBean = null;
            }
        }
        catch (Exception re) {
            log.log(Level.WARNING, "Unexpected Exception in entity cleanup:", re);
        }
        try {
            this.statelessBean.removeTestData();
        }
        catch (Exception re) {
            log.log(Level.WARNING, "Unexpected Exception in entity cleanup:", re);
        }
        log.info("cleanup complete");
    }
}

