/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.ee.packaging.ejb.standalone;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.ee.common.B;
import ee.jakarta.tck.persistence.ee.packaging.ejb.standalone.Stateful3IF;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBException;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateful;
import jakarta.persistence.EntityManager;
import java.util.Properties;

@Stateful(name="Stateful3Bean")
public class Stateful3Bean
implements Stateful3IF {
    private EntityManager entityManager;
    public SessionContext sessionContext;
    private static final B[] bRef = new B[5];

    @PostConstruct
    public void prepareEnvironment() {
        try {
            TestUtil.logTrace((String)"In PostContruct");
            this.entityManager = (EntityManager)this.sessionContext.lookup("persistence/MyPersistenceContext");
        }
        catch (Exception e) {
            TestUtil.logErr((String)" In PostConstruct: Exception caught while looking up EntityManager", (Throwable)e);
        }
    }

    @Resource
    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public void createTestData() {
        TestUtil.logTrace((String)"createTestData");
        try {
            TestUtil.logTrace((String)"Create 5 Bees");
            Stateful3Bean.bRef[0] = new B("1", "b1", 1);
            Stateful3Bean.bRef[1] = new B("2", "b2", 2);
            Stateful3Bean.bRef[2] = new B("3", "b3", 3);
            Stateful3Bean.bRef[3] = new B("4", "b4", 4);
            Stateful3Bean.bRef[4] = new B("5", "b5", 5);
            TestUtil.logTrace((String)"Start to persist Bees ");
            for (B b : bRef) {
                if (b == null) continue;
                this.entityManager.persist((Object)b);
                TestUtil.logTrace((String)("persisted B " + String.valueOf(b)));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Unexpected while creating test data:" + String.valueOf(e)));
        }
    }

    @Override
    public void removeTestData() {
        try {
            this.entityManager.createNativeQuery("DELETE FROM BEJB_1X1_BI_BTOB").executeUpdate();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception caught while cleaning up:", (Throwable)e);
        }
        TestUtil.logTrace((String)"Clearing cache");
        this.entityManager.getEntityManagerFactory().getCache().evictAll();
        TestUtil.logTrace((String)"cleanup complete");
    }

    @Override
    public void init(Properties p) {
        TestUtil.logTrace((String)"init");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    @Override
    public boolean test1() {
        TestUtil.logTrace((String)"Begin test1");
        boolean pass = false;
        try {
            this.createTestData();
            B anotherB = (B)this.entityManager.find(B.class, (Object)"3");
            if (anotherB != null) {
                TestUtil.logTrace((String)("newB found" + anotherB.getName()));
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception :", (Throwable)e);
        }
        return pass;
    }
}

