/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.StoredProcedureQuery;

import com.sun.ts.lib.harness.Fault;
import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.core.StoredProcedureQuery.Client;
import ee.jakarta.tck.persistence.core.StoredProcedureQuery.Employee;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.Parameter;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.TemporalType;
import jakarta.persistence.TransactionRequiredException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class Client1
extends Client {
    @Override
    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        super.setup(args, p);
        this.dataBaseName = p.getProperty("jdbc.db");
    }

    public static void main(String[] args) {
        Client1 theTests = new Client1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void executeTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            ArrayList<Integer> expected;
            List<List> listOfList;
            StoredProcedureQuery spq;
            this.getEntityTransaction().begin();
            try {
                this.logMsg("Testing using name,class");
                this.clearCache();
                spq = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", new Class[]{Employee.class});
                if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                    this.logTrace("register refcursor parameter");
                    spq.registerStoredProcedureParameter(1, Void.TYPE, ParameterMode.REF_CURSOR);
                }
                this.logTrace("executing:" + spq.toString());
                if (spq.execute()) {
                    listOfList = this.getResultSetsFromStoredProcedure(spq);
                    if (listOfList.size() == 1) {
                        expected = new ArrayList<Integer>();
                        for (Employee e : this.empRef) {
                            expected.add(e.getId());
                        }
                        pass1 = this.verifyEmployeeIds(expected, listOfList);
                    } else {
                        this.logErr("Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size());
                    }
                } else {
                    this.logErr("Expected execute() to return true, actual: false");
                }
            }
            catch (Exception ex) {
                this.logErr("Received unexpected exception:", ex);
            }
            try {
                this.logMsg("Testing using name,result mapping");
                this.clearCache();
                spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS", new String[]{"id-firstname-lastname"});
                spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
                if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                    this.logTrace("register refcursor parameter");
                    spq.registerStoredProcedureParameter(2, Void.TYPE, ParameterMode.REF_CURSOR);
                }
                spq.setParameter(1, (Object)1);
                if (spq.execute()) {
                    listOfList = this.getResultSetsFromStoredProcedure(spq);
                    if (listOfList.size() == 1) {
                        expected = new ArrayList();
                        expected.add((Integer)((Object)new Employee(this.emp0.getId(), this.emp0.getFirstName(), this.emp0.getLastName())));
                        pass2 = this.verifyListOfListEmployees(expected, listOfList);
                    } else {
                        this.logErr("Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size());
                    }
                } else {
                    this.logErr("Expected execute() to return false, actual: true");
                }
            }
            catch (Exception ex) {
                this.logErr("Received unexpected exception:", ex);
            }
            try {
                this.logMsg("Testing using named stored procedure");
                this.clearCache();
                if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                    this.logTrace("Calling refcursor specific named stored procedure query");
                    spq = this.getEntityManager().createNamedStoredProcedureQuery("get-id-firstname-lastname-refcursor");
                } else {
                    spq = this.getEntityManager().createNamedStoredProcedureQuery("get-id-firstname-lastname");
                }
                spq.setParameter(1, (Object)1);
                if (spq.execute()) {
                    listOfList = this.getResultSetsFromStoredProcedure(spq);
                    if (listOfList.size() == 1) {
                        expected = new ArrayList();
                        expected.add((Integer)((Object)new Employee(this.emp0.getId(), this.emp0.getFirstName(), this.emp0.getLastName())));
                        pass3 = this.verifyListOfListEmployees(expected, listOfList);
                    } else {
                        this.logErr("Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size());
                    }
                } else {
                    this.logErr("Expected execute() to return false, actual: true");
                }
            }
            catch (Exception ex) {
                this.logErr("Received unexpected exception:", ex);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Received unexpected exception:", ex);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("executeTest failed");
        }
    }

    @Override
    public void getOutputParameterValueIntTest() throws Exception {
        String actual;
        boolean pass2 = false;
        boolean pass4 = false;
        boolean pass6 = false;
        Object oActual = null;
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Get the value from an OUT only parameter");
            StoredProcedureQuery spq3 = this.getEntityManager().createStoredProcedureQuery("GetEmpOneFirstNameFromOut");
            spq3.registerStoredProcedureParameter(1, String.class, ParameterMode.OUT);
            if (!spq3.execute()) {
                oActual = spq3.getOutputParameterValue(1);
                if (oActual instanceof String) {
                    actual = (String)oActual;
                    if (actual.equals(this.emp0.getFirstName())) {
                        this.logTrace("Received expected result:" + actual);
                        pass6 = true;
                    } else {
                        this.logErr("Expected result: " + this.emp0.getFirstName() + ", actual:" + actual);
                    }
                } else {
                    this.logErr("Did not get instance of String, instead:" + String.valueOf(oActual));
                }
            } else {
                this.logErr("Expected execute() to return false, actual: true");
            }
        }
        catch (Exception ex) {
            this.logErr("Received unexpected exception:", ex);
        }
        try {
            this.logMsg("Get the value from an IN and OUT parameter");
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq1.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq1.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq1.setParameter(1, (Object)1);
            if (!spq1.execute()) {
                oActual = spq1.getOutputParameterValue(2);
                if (oActual instanceof String) {
                    actual = (String)oActual;
                    if (actual.equals(this.emp0.getFirstName())) {
                        this.logTrace("Received expected result:" + actual);
                        pass2 = true;
                    } else {
                        this.logErr("Expected result: " + this.emp0.getFirstName() + ", actual:" + actual);
                    }
                } else {
                    this.logErr("Did not get instance of String, instead:" + String.valueOf(oActual));
                }
            } else {
                this.logErr("Expected execute() to return false, actual: true");
            }
        }
        catch (Exception ex) {
            this.logErr("Received unexpected exception:", ex);
        }
        try {
            this.logMsg("Get the value from an INOUT parameter");
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
            spq2.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
            spq2.setParameter(1, (Object)"1");
            if (!spq2.execute()) {
                oActual = spq2.getOutputParameterValue(1);
                if (oActual instanceof String) {
                    actual = (String)oActual;
                    if (actual.equals(this.emp0.getLastName())) {
                        this.logTrace("Received expected result:" + actual);
                        pass4 = true;
                    } else {
                        this.logErr("Expected result: " + this.emp0.getLastName() + ", actual:" + actual);
                    }
                } else {
                    this.logErr("Expected Integer to be returned, actual:" + String.valueOf(oActual));
                }
            } else {
                this.logErr("Expected execute() to return false, actual: true");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Received unexpected exception:", ex);
        }
        if (!(pass2 && pass4 && pass6)) {
            throw new Fault("getOutputParameterValueIntTest failed");
        }
    }

    @Override
    public void getOutputParameterValueIntIllegalArgumentExceptionTest() throws Exception {
        boolean pass4;
        boolean pass2;
        block15: {
            pass2 = false;
            pass4 = false;
            try {
                block14: {
                    this.getEntityTransaction().begin();
                    this.logMsg("Get a value that does not exist");
                    StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
                    spq1.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
                    spq1.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
                    spq1.setParameter(1, (Object)1);
                    if (!spq1.execute()) {
                        try {
                            spq1.getOutputParameterValue(99);
                            this.logErr("Did not throw IllegalArgumentException");
                        }
                        catch (IllegalArgumentException iae) {
                            this.logTrace("Received expected IllegalArgumentException");
                            if (!this.getEntityTransaction().getRollbackOnly()) {
                                pass2 = true;
                                this.logTrace("Transaction was not marked for rollback");
                                break block14;
                            }
                            this.logErr("Transaction was marked for rollback and should not have been");
                        }
                        catch (Exception e) {
                            this.logErr("Caught unexpected exception", e);
                        }
                    } else {
                        this.logErr("Expected execute() to return false, actual: true");
                    }
                }
                this.logMsg("Get the value from an IN parameter");
                StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
                spq2.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
                spq2.setParameter(1, (Object)"1");
                if (!spq2.execute()) {
                    try {
                        spq2.getOutputParameterValue(99);
                        this.logErr("Did not throw IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        this.logTrace("Received expected IllegalArgumentException");
                        pass4 = true;
                    }
                    catch (Exception e) {
                        this.logErr("Caught unexpected exception", e);
                    }
                    if (this.getEntityTransaction().isActive()) {
                        this.getEntityTransaction().rollback();
                    }
                    break block15;
                }
                this.logErr("Expected execute() to return false, actual: true");
            }
            catch (Exception ex) {
                this.logErr("Received unexpected exception:", ex);
            }
        }
        if (!pass2 || !pass4) {
            throw new Fault("getOutputParameterValueIntIllegalArgumentExceptionTest failed");
        }
    }

    @Override
    public void getFirstResultTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            int num;
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", new Class[]{Employee.class});
            if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                this.logTrace("register refcursor parameter");
                spq.registerStoredProcedureParameter(1, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            if ((num = spq.getFirstResult()) == 0) {
                this.logTrace("Received expected first result when none is set:" + num);
                pass1 = true;
            } else {
                this.logErr("Expected first result when none is set: 0, actual:" + num);
            }
            List actual = spq.getResultList();
            num = spq.getFirstResult();
            if (num == 0) {
                this.logTrace("Received expected first result:" + num + " after getResultList");
                pass2 = true;
            } else {
                this.logErr("Expected first result: 0, actual:" + num + " after getResultList");
            }
            if (actual.size() > 0) {
                pass3 = this.verifyListEmployees(this.empRef, actual);
            } else {
                this.logErr("getResultList() returned 0 results");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Received unexpected exception:", ex);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Fault("getFirstResultTest failed");
        }
    }

    @Override
    public void getMaxResultsTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        try {
            int num;
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", new Class[]{Employee.class});
            if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                this.logTrace("register refcursor parameter");
                spq.registerStoredProcedureParameter(1, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            if ((num = spq.getMaxResults()) == Integer.MAX_VALUE) {
                this.logTrace("Received expected max result:" + num);
                pass1 = true;
            } else {
                this.logErr("Expected max result: 2147483647, actual:" + num);
            }
            List actual = spq.getResultList();
            num = spq.getMaxResults();
            if (num == Integer.MAX_VALUE) {
                this.logTrace("Received expected max result:" + num + " after getResultList");
                pass2 = true;
            } else {
                this.logErr("Expected max result:2147483647, actual:" + num + " after getResultList");
            }
            if (actual.size() > 0) {
                pass3 = this.verifyListEmployees(this.empRef, actual);
            } else {
                this.logErr("getResultList() returned 0 results");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Received unexpected exception:", ex);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Fault("getMaxResultsTest failed");
        }
    }

    @Override
    public void getSingleResultTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS", new String[]{"id-firstname-lastname"});
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                this.logTrace("register refcursor parameter");
                spq.registerStoredProcedureParameter(2, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            spq.setParameter(1, (Object)1);
            Employee expected = new Employee(this.emp0.getId(), this.emp0.getFirstName(), this.emp0.getLastName());
            Object o = spq.getSingleResult();
            if (o instanceof Employee) {
                Employee actual = (Employee)o;
                if (actual.equals(expected)) {
                    this.logTrace("Received expected result:" + String.valueOf(actual));
                    pass = true;
                } else {
                    this.logErr("Expected result:" + String.valueOf(expected) + ", actual:" + String.valueOf(actual));
                }
            } else {
                this.logErr("Did not get Integer result:" + String.valueOf(o));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Received unexpected exception:", ex);
        }
        if (!pass) {
            throw new Fault("getSingleResultTest failed");
        }
    }

    public void getSingleResultOrNullWithValueTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS", new String[]{"id-firstname-lastname"});
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                this.logTrace("register refcursor parameter");
                spq.registerStoredProcedureParameter(2, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            spq.setParameter(1, (Object)1);
            Employee expected = new Employee(this.emp0.getId(), this.emp0.getFirstName(), this.emp0.getLastName());
            Object o = spq.getSingleResultOrNull();
            if (o instanceof Employee) {
                Employee actual = (Employee)o;
                if (actual.equals(expected)) {
                    this.logTrace("Received expected result:" + String.valueOf(actual));
                    pass = true;
                } else {
                    this.logErr("Expected result:" + String.valueOf(expected) + ", actual:" + String.valueOf(actual));
                }
            } else {
                this.logErr("Did not get Integer result:" + String.valueOf(o));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Received unexpected exception:", ex);
        }
        if (!pass) {
            throw new Fault("getSingleResultOrNullWithValueTest failed");
        }
    }

    public void getSingleResultOrNullWithNullTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS", new String[]{"id-firstname-lastname"});
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                this.logTrace("register refcursor parameter");
                spq.registerStoredProcedureParameter(2, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            spq.setParameter(1, (Object)0);
            Object result = spq.getSingleResultOrNull();
            if (result == null) {
                this.logTrace("Received expected null value.");
                pass = true;
            } else {
                Employee actual = (Employee)result;
                this.logErr("Unexpected not null result:" + String.valueOf(actual));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Received unexpected exception:", ex);
        }
        if (!pass) {
            throw new Fault("getSingleResultOrNullWithNullTest failed");
        }
    }

    @Override
    public void getSingleResultNoResultExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                this.logTrace("register refcursor parameter");
                spq.registerStoredProcedureParameter(2, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            spq.setParameter(1, (Object)99);
            try {
                spq.getSingleResult();
                this.logErr("Did not throw NoResultException");
            }
            catch (NoResultException nre) {
                this.logTrace("Received expected NoResultException");
                pass = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception ex) {
            this.logErr("Received unexpected exception:", ex);
        }
        if (!pass) {
            throw new Fault("getSingleResultNoResultExceptionTest failed");
        }
    }

    @Override
    public void getSingleResultNonUniqueResultExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", new Class[]{Employee.class});
            if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                this.logTrace("register refcursor parameter");
                spq.registerStoredProcedureParameter(1, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            try {
                spq.getSingleResult();
                this.logErr("Did not throw NonUniqueResultException");
            }
            catch (NonUniqueResultException nure) {
                this.logTrace("Received expected NonUniqueResultException");
                pass = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception ex) {
            this.logErr("Received unexpected exception:", ex);
        }
        if (!pass) {
            throw new Fault("getSingleResultNonUniqueResultExceptionTest failed");
        }
    }

    @Override
    public void setgetFlushModeTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            FlushModeType fmt;
            this.logMsg("Testing StoredProcedureQuery");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", new Class[]{Employee.class});
            if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                this.logTrace("register refcursor parameter");
                spq.registerStoredProcedureParameter(1, Void.TYPE, ParameterMode.REF_CURSOR);
            }
            if ((fmt = spq.getFlushMode()) != null) {
                if (fmt.equals((Object)this.getEntityManager().getFlushMode())) {
                    this.logTrace("Setting mode to returned default mode");
                    spq.setFlushMode(fmt);
                    this.logTrace("Setting mode to FlushModeType.COMMIT");
                    spq.setFlushMode(FlushModeType.COMMIT);
                    fmt = spq.getFlushMode();
                    if (fmt.equals((Object)FlushModeType.COMMIT)) {
                        this.logTrace("Setting mode to FlushModeType.AUTO");
                        spq.setFlushMode(FlushModeType.AUTO);
                        fmt = spq.getFlushMode();
                        if (fmt.equals((Object)FlushModeType.AUTO)) {
                            this.logTrace("Query object returned from setFlushMode");
                            StoredProcedureQuery q = spq.setFlushMode(FlushModeType.COMMIT);
                            fmt = q.getFlushMode();
                            if (fmt.equals((Object)FlushModeType.COMMIT)) {
                                this.logTrace("Received expected Query FlushModeType:" + fmt.name());
                                pass1 = true;
                            } else {
                                this.logErr("Expected a value of:" + FlushModeType.COMMIT.name() + ", actual:" + fmt.name());
                            }
                        } else {
                            this.logErr("Expected a value of:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name());
                        }
                    } else {
                        this.logErr("Expected a default value of:" + FlushModeType.COMMIT.name() + ", actual:" + fmt.name());
                    }
                } else {
                    this.logErr("Expected EntityManager value of:" + String.valueOf(this.getEntityManager().getFlushMode()) + ", actual:" + fmt.name());
                }
            } else {
                this.logErr("getFlushMode return null");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        try {
            this.logMsg("Testing Query object returned from setFlushMode");
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpASCFromRS", new Class[]{Employee.class});
            this.logTrace("Setting mode to FlushModeType.AUTO");
            StoredProcedureQuery q = spq2.setFlushMode(FlushModeType.AUTO);
            FlushModeType fmt = q.getFlushMode();
            if (fmt.equals((Object)FlushModeType.AUTO)) {
                this.logTrace("Received expected value of:" + fmt.name());
                pass2 = true;
            } else {
                this.logErr("Expected a value of:" + FlushModeType.AUTO.name() + ", actual:" + fmt.name());
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass1 || !pass2) {
            throw new Fault("setgetFlushModeTest failed");
        }
    }

    @Override
    public void setLockModeIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("UpdateEmpSalaryColumn");
            try {
                spq.setLockMode(LockModeType.PESSIMISTIC_READ);
                this.logErr("Did not throw IllegalStateException");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Received expected IllegalStateException");
                pass = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Fault("setLockModeIllegalStateExceptionTest failed");
        }
    }

    @Override
    public void getLockModeIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("UpdateEmpSalaryColumn");
            try {
                spq.getLockMode();
                this.logErr("Did not throw IllegalStateException");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Received expected IllegalStateException");
                pass = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Fault("getLockModeIllegalStateExceptionTest failed");
        }
    }

    @Override
    public void setGetParameterIntTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Testing StoredProcedureQuery");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            Parameter p = spq.getParameter(1);
            int pos = p.getPosition();
            if (pos == 1) {
                this.logTrace("Received expected parameter:" + pos);
                pass1 = true;
            } else {
                this.logErr("Expected position: 1, actual:" + pos);
            }
            this.logMsg("Testing Query object returned from getParameter");
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq2.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq2.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            StoredProcedureQuery q = spq2.setParameter(1, (Object)1);
            p = q.getParameter(1);
            pos = p.getPosition();
            if (pos == 1) {
                this.logTrace("Received expected parameter:" + pos);
                pass2 = true;
            } else {
                this.logErr("Expected position: 1, actual:" + pos);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass1 || !pass2) {
            throw new Fault("setGetParameterIntTest failed");
        }
    }

    @Override
    public void getParameterStringExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Testing StoredProcedureQuery ");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter("ID", Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter("FIRSTNAME", String.class, ParameterMode.OUT);
            spq.setParameter("ID", (Object)1);
            try {
                spq.getParameter("DOESNOTEXIST");
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (IllegalStateException ise) {
                this.logTrace("Received expected IllegalStateException");
                pass1 = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            this.logMsg("Testing Query object returned from getParameter");
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq2.registerStoredProcedureParameter("ID", Integer.class, ParameterMode.IN);
            spq2.registerStoredProcedureParameter("FIRSTNAME", String.class, ParameterMode.OUT);
            StoredProcedureQuery q = spq2.setParameter("ID", (Object)1);
            try {
                q.getParameter("DOESNOTEXIST");
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (IllegalStateException ise) {
                this.logTrace("Received expected IllegalStateException");
                pass2 = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Fault("getParameterStringExceptionTest failed");
        }
    }

    @Override
    public void getParameterIntIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Testing StoredProcedureQuery ");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            try {
                spq.getParameter(99);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            this.logMsg("Testing Query object returned from getParameter");
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq2.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq2.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            StoredProcedureQuery q = spq2.setParameter(1, (Object)1);
            try {
                q.getParameter(99);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Fault("getParameterIntIllegalArgumentExceptionTest failed");
        }
    }

    @Override
    public void setParameterParameterObjectTest() throws Exception {
        boolean pass4;
        boolean pass2;
        block18: {
            block17: {
                pass2 = false;
                pass4 = false;
                try {
                    this.getEntityTransaction().begin();
                    this.logMsg("Testing StoredProcedureQuery ");
                    StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
                    spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
                    spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
                    spq.setParameter(1, (Object)99);
                    Parameter p = spq.getParameter(1);
                    spq.setParameter(p, (Object)1);
                    if (!spq.execute()) {
                        Object oActual = spq.getOutputParameterValue(2);
                        if (oActual instanceof String) {
                            String actual = (String)oActual;
                            if (actual.equals(this.emp0.getFirstName())) {
                                this.logTrace("Received expected result:" + actual);
                                pass2 = true;
                            } else {
                                this.logErr("Expected result: " + this.emp0.getFirstName() + ", actual:" + actual);
                            }
                        } else {
                            this.logErr("Did not get instance of String, instead:" + String.valueOf(oActual.getClass()));
                        }
                    } else {
                        this.logErr("Expected execute() to return false, actual: true");
                    }
                    this.getEntityTransaction().commit();
                }
                catch (Exception e) {
                    this.logErr("Caught exception", e);
                    if (!this.getEntityTransaction().isActive()) break block17;
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                this.logMsg("Testing Query object returned from setParameter");
                StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
                spq2.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
                spq2.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
                StoredProcedureQuery q = spq2;
                q.setParameter(1, (Object)99);
                Parameter p = q.getParameter(1);
                q.setParameter(p, (Object)1);
                StoredProcedureQuery spq3 = q;
                if (!spq3.execute()) {
                    Object oActual = spq3.getOutputParameterValue(2);
                    if (oActual instanceof String) {
                        String actual = (String)oActual;
                        if (actual.equals(this.emp0.getFirstName())) {
                            this.logTrace("Received expected result:" + actual);
                            pass4 = true;
                        } else {
                            this.logErr("Expected result: " + this.emp0.getFirstName() + ", actual:" + actual);
                        }
                    } else {
                        this.logErr("Did not get instance of String, instead:" + String.valueOf(oActual));
                    }
                } else {
                    this.logErr("Expected execute() to return false, actual: true");
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                this.logErr("Caught exception", e);
                if (!this.getEntityTransaction().isActive()) break block18;
                this.getEntityTransaction().rollback();
            }
        }
        if (!pass2 || !pass4) {
            throw new Fault("setParameterParameterObjectTest failed");
        }
    }

    @Override
    public void setParameterParameterObjectIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Get parameter from other stored procedure");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
            spq.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
            spq.setParameter(1, (Object)"INOUT");
            Parameter p = spq.getParameter(1);
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq2.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq2.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            try {
                spq2.setParameter(p, (Object)1);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception", e);
        }
        if (!pass1) {
            throw new Fault("setParameterParameterObjectIllegalArgumentExceptionTest failed");
        }
    }

    @Override
    public void setParameterIntObjectIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Testing StoredProcedureQuery with incorrect position specified");
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq1.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq1.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            try {
                spq1.setParameter(99, (Object)1);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            this.logMsg("Testing StoredProcedureQuery with incorrect type specified");
            StoredProcedureQuery spq2 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq2.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq2.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            try {
                spq2.setParameter(1, (Object)new Date());
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            this.logMsg("Testing Query object with incorrect position specified");
            StoredProcedureQuery spq3 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq3.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq3.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            StoredProcedureQuery q1 = spq3.setParameter(1, (Object)1);
            try {
                spq3.setParameter(99, (Object)1);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass3 = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            this.logMsg("Testing Query object with incorrect type specified");
            StoredProcedureQuery spq4 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq4.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq4.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            StoredProcedureQuery q2 = spq4.setParameter(1, (Object)1);
            try {
                q2.setParameter(1, (Object)new Date());
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass4 = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception", e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Fault("setParameterIntObjectIllegalArgumentExceptionTest failed");
        }
    }

    @Override
    public void getParametersTest() throws Exception {
        boolean pass1 = false;
        boolean pass3 = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            Set p1 = spq.getParameters();
            if (p1.size() == 0) {
                this.logTrace("Received expected number of parameters when non exist:" + p1.size());
                pass1 = true;
            } else {
                this.logErr("Expected number of parameters when non exist: 0, actual:" + String.valueOf(p1));
            }
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            if (!spq.execute()) {
                Set p2 = spq.getParameters();
                if (p2.size() == 2) {
                    this.logTrace("Received expected number of parameters:" + p2.size());
                    pass3 = true;
                } else {
                    this.logErr("Expected number of parameters: 2, actual:" + p2.size());
                }
            } else {
                this.logErr("Expected execute() to return false, actual: true");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass1 || !pass3) {
            throw new Fault("getParametersTest failed");
        }
    }

    @Override
    public void setParameterIntDateTemporalTypeTest() throws Exception {
        boolean pass2 = false;
        boolean pass4 = false;
        try {
            this.getEntityTransaction().begin();
            try {
                this.logMsg("Testing StoredProcedureQuery");
                StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                spq.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
                spq.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                spq.setParameter(1, this.utilDate, TemporalType.DATE);
                if (!spq.execute()) {
                    Object o = spq.getOutputParameterValue(2);
                    if (o instanceof Integer) {
                        Integer actual = (Integer)o;
                        if (actual == 1) {
                            this.logTrace("Received expected id:" + actual);
                            pass2 = true;
                        } else {
                            this.logErr("Expected id: 1, actual:" + actual);
                        }
                    } else {
                        this.logErr("Did not get instance of Integer back:" + String.valueOf(o));
                    }
                } else {
                    this.logErr("Expected execute() to return false, actual: true");
                }
            }
            catch (Exception e) {
                this.logErr("Caught exception: ", e);
            }
            try {
                this.logMsg("Testing Query object");
                StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                spq1.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
                spq1.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                StoredProcedureQuery q = spq1;
                q.setParameter(1, this.utilDate, TemporalType.DATE);
                StoredProcedureQuery spq2 = q;
                if (!spq2.execute()) {
                    Object o = spq2.getOutputParameterValue(2);
                    if (o instanceof Integer) {
                        int actual = (Integer)o;
                        if (actual == 1) {
                            this.logTrace("Received expected id:" + actual);
                            pass4 = true;
                        } else {
                            this.logErr("Expected id: 1, actual:" + actual);
                        }
                    } else {
                        this.logErr("Did not get instance of Integer back:" + String.valueOf(o));
                    }
                } else {
                    this.logErr("Expected execute() to return false, actual: true");
                }
            }
            catch (Exception e) {
                this.logErr("Caught exception: ", e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass2 || !pass4) {
            throw new Fault("setParameterIntDateTemporalTypeTest failed");
        }
    }

    @Override
    public void setParameterIntDateTemporalTypeIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Testing StoredProcedureQuery with incorrect position specified");
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq1.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
            try {
                spq1.setParameter(99, this.utilDate, TemporalType.DATE);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            this.logMsg("Testing Query object with incorrect position specified");
            StoredProcedureQuery spq3 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq3.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
            StoredProcedureQuery q1 = spq3.setParameter(1, (Object)this.getUtilDate());
            try {
                q1.setParameter(99, this.utilDate, TemporalType.DATE);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Fault("setParameterIntDateTemporalTypeIllegalArgumentExceptionTest failed");
        }
    }

    @Override
    public void setParameterParameterDateTemporalTypeTest() throws Exception {
        boolean pass5;
        boolean pass3;
        boolean pass2;
        block20: {
            block19: {
                pass2 = false;
                pass3 = false;
                pass5 = false;
                try {
                    this.getEntityTransaction().begin();
                    StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                    spq.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
                    spq.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                    spq.setParameter(1, this.getUtilDate(), TemporalType.DATE);
                    Parameter p = spq.getParameter(1);
                    spq.setParameter(p, this.utilDate, TemporalType.DATE);
                    if (!spq.execute()) {
                        Object o = spq.getOutputParameterValue(2);
                        if (o instanceof Integer) {
                            int actual = (Integer)o;
                            if (actual == 1) {
                                this.logTrace("Received expected id:" + actual);
                                pass2 = true;
                            } else {
                                this.logErr("Expected id: 1, actual:" + actual);
                            }
                        } else {
                            this.logErr("Did not get instance of Integer back:" + String.valueOf(o));
                        }
                    } else {
                        this.logErr("Expected execute() to return false, actual: true");
                    }
                    this.getEntityTransaction().commit();
                }
                catch (Exception e) {
                    this.logErr("Caught exception: ", e);
                    if (!this.getEntityTransaction().isActive()) break block19;
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                this.logMsg("Testing Query object");
                StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                spq1.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
                spq1.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                spq1.setParameter(1, this.getCalDate().getTime(), TemporalType.DATE);
                StoredProcedureQuery q = spq1;
                Parameter p = q.getParameter(1);
                q.setParameter(p, this.utilDate, TemporalType.DATE);
                Parameter p2 = q.getParameter(1);
                if (p.getPosition().equals(p2.getPosition()) && p.getParameterType().equals(p2.getParameterType())) {
                    this.logTrace("Received expected parameter");
                    pass3 = true;
                } else {
                    this.logErr("Expected parameter:" + String.valueOf(p) + ", actual:" + String.valueOf(p2));
                }
                StoredProcedureQuery spq2 = q;
                if (!spq2.execute()) {
                    Object o = spq2.getOutputParameterValue(2);
                    if (o instanceof Integer) {
                        int actual = (Integer)o;
                        if (actual == this.emp0.getId()) {
                            this.logTrace("Received expected id:" + actual);
                            pass5 = true;
                        } else {
                            this.logErr("Expected id: 1, actual:" + actual);
                        }
                    } else {
                        this.logErr("Did not get instance of Integer back:" + String.valueOf(o));
                    }
                } else {
                    this.logErr("Expected execute() to return false, actual: true");
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                this.logErr("Caught exception: ", e);
                if (!this.getEntityTransaction().isActive()) break block20;
                this.getEntityTransaction().rollback();
            }
        }
        if (!(pass2 && pass3 && pass5)) {
            throw new Fault("setParameterParameterDateTemporalTypeTest failed");
        }
    }

    @Override
    public void setParameterParameterDateTemporalTypeIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Get parameter from other stored procedure");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
            spq.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
            spq.setParameter(1, (Object)"INOUT");
            Parameter p = spq.getParameter(1);
            this.logMsg("Testing StoredProcedureQuery with parameter specified from another query");
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq1.registerStoredProcedureParameter(1, Date.class, ParameterMode.IN);
            spq1.setParameter(1, this.getUtilDate(), TemporalType.DATE);
            try {
                spq1.setParameter(p, this.getUtilDate(), TemporalType.DATE);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            this.logMsg("Testing Query object with parameter specified from another query");
            StoredProcedureQuery spq3 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq3.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
            StoredProcedureQuery q1 = spq3.setParameter(1, (Object)this.getCalDate());
            try {
                q1.setParameter(p, this.getCalDate(), TemporalType.DATE);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Fault("setParameterParameterDateTemporalTypeIllegalArgumentExceptionTest failed");
        }
    }

    @Override
    public void executeUpdateOfAnUpdateTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("UpdateEmpSalaryColumn");
            spq.executeUpdate();
            int updateCount = spq.getUpdateCount();
            if (updateCount == -1) {
                this.logTrace("Received expected update count:" + updateCount);
                pass = true;
            } else {
                this.logErr("Expected update count: -1, actual:" + updateCount);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Fault("executeUpdateOfAnUpdateTest failed");
        }
    }

    @Override
    public void executeUpdateOfADeleteTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("DeleteAllEmp");
            spq.executeUpdate();
            int updateCount = spq.getUpdateCount();
            if (updateCount == -1) {
                this.logTrace("Received expected update count:" + updateCount);
                pass = true;
            } else {
                this.logErr("Expected update count: -1, actual:" + updateCount);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Fault("executeUpdateOfADeleteTest failed");
        }
    }

    @Override
    public void executeUpdateTransactionRequiredExceptionTest() throws Exception {
        boolean pass = false;
        try {
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("DeleteAllEmp");
            try {
                this.logMsg("IsActive returns:" + this.getEntityTransaction().isActive());
                spq.executeUpdate();
                this.logErr("Did not throw TransactionRequiredException");
            }
            catch (TransactionRequiredException tre) {
                this.logTrace("Received expected TransactionRequiredException");
                pass = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Fault("executeUpdateTransactionRequiredExceptionTest failed");
        }
    }

    @Override
    public void getParameterValueParameterTest() throws Exception {
        boolean pass1 = false;
        boolean pass3 = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            Parameter p = spq.getParameter(1);
            boolean b = spq.isBound(p);
            if (b) {
                this.logTrace("Received expected from isBound():" + b);
                pass1 = true;
            } else {
                this.logErr("Expected result from isBound():true, actual:" + b);
            }
            if (!spq.execute()) {
                p = spq.getParameter(1);
                Object o = spq.getParameterValue(p);
                if (o instanceof Integer) {
                    this.logTrace("Received expected parameter type: Integer");
                    Integer i = (Integer)o;
                    if (i.equals(this.emp0.getId())) {
                        this.logTrace("Received expected parameter value:" + i);
                        pass3 = true;
                    } else {
                        this.logErr("Expected getParameterValue() result: " + this.emp0.getId() + ", actual:" + i);
                    }
                } else {
                    this.logErr("Did not get instance of Integer from getParameterValue():" + String.valueOf(o));
                }
            } else {
                this.logErr("Expected execute() to return false, actual: true");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass3) {
            throw new Fault("getParameterValueParameterTest failed");
        }
    }

    @Override
    public void getParameterValueParameterIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
            spq.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
            spq.setParameter(1, (Object)"1");
            Parameter p = spq.getParameter(1);
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq1.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq1.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq1.setParameter(1, (Object)1);
            try {
                spq1.getParameterValue(p);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Fault("getParameterValueParameterIllegalArgumentExceptionTest failed");
        }
    }

    @Override
    public void getParameterValueParameterIllegalStateExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            Parameter p = spq.getParameter(1);
            boolean b = spq.isBound(p);
            if (b) {
                this.logTrace("Received expected from isBound():" + b);
                pass1 = true;
            } else {
                this.logErr("Expected result from isBound():true, actual:" + b);
            }
            Parameter p2 = spq.getParameter(2);
            try {
                spq.getParameterValue(p2);
                this.logErr("Did not throw IllegalStateException");
            }
            catch (IllegalStateException iae) {
                this.logTrace("Received expected IllegalStateException");
                pass2 = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Fault("getParameterValueParameterIllegalStateExceptionTest failed");
        }
    }

    @Override
    public void getParameterValueIntTest() throws Exception {
        boolean pass4;
        boolean pass3;
        boolean pass2;
        boolean pass1;
        block24: {
            String s;
            Object o;
            StoredProcedureQuery spq;
            block23: {
                pass1 = false;
                pass2 = false;
                pass3 = false;
                pass4 = false;
                try {
                    this.getEntityTransaction().begin();
                    this.logMsg("Testing createStoredProcedureQuery");
                    spq = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
                    spq.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
                    spq.setParameter(1, (Object)"1");
                    o = spq.getParameterValue(1);
                    if (o instanceof String) {
                        this.logTrace("Received expected parameter type: String");
                        s = (String)o;
                        if (s.equals("1")) {
                            this.logTrace("Received expected parameter value:" + s);
                            pass1 = true;
                        } else {
                            this.logErr("Expected getParameterValue() result: 1, actual:" + s);
                        }
                    } else {
                        this.logErr("Did not get instance of String from getParameterValue():" + String.valueOf(o));
                    }
                    if (!spq.execute()) {
                        o = spq.getParameterValue(1);
                        if (o instanceof String) {
                            this.logTrace("Received expected parameter type: String");
                            s = (String)o;
                            if (s.equals("1")) {
                                this.logTrace("Received expected parameter value:" + s);
                                pass2 = true;
                            } else {
                                this.logErr("Expected getParameterValue() result: 1, actual:" + s);
                            }
                        }
                    } else {
                        this.logErr("Expected execute() to return false, actual: true");
                    }
                    this.getEntityTransaction().commit();
                }
                catch (Exception e) {
                    this.logErr("Unexpected exception occurred", e);
                    if (!this.getEntityTransaction().isActive()) break block23;
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                this.logMsg("Testing createNamedStoredProcedureQuery");
                spq = this.getEntityManager().createNamedStoredProcedureQuery("getemplastnamefrominout");
                spq.setParameter(1, (Object)"1");
                o = spq.getParameterValue(1);
                if (o instanceof String) {
                    this.logTrace("Received expected parameter type: String");
                    s = (String)o;
                    if (s.equals("1")) {
                        this.logTrace("Received expected parameter value:" + s);
                        pass3 = true;
                    } else {
                        this.logErr("Expected getParameterValue() result: 1, actual:" + s);
                    }
                } else {
                    this.logErr("Did not get instance of String from getParameterValue():" + String.valueOf(o));
                }
                if (!spq.execute()) {
                    o = spq.getParameterValue(1);
                    if (o instanceof String) {
                        this.logTrace("Received expected parameter type: String");
                        s = (String)o;
                        if (s.equals("1")) {
                            this.logTrace("Received expected parameter value:" + s);
                            pass4 = true;
                        } else {
                            this.logErr("Expected getParameterValue() result: 1, actual:" + s);
                        }
                    }
                } else {
                    this.logErr("Expected execute() to return false, actual: true");
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                this.logErr("Unexpected exception occurred", e);
                if (!this.getEntityTransaction().isActive()) break block24;
                this.getEntityTransaction().rollback();
            }
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Fault("getParameterValueIntTest failed");
        }
    }

    @Override
    public void getParameterValueIntIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            try {
                spq.getParameterValue(99);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Fault("getParameterValueIntIllegalArgumentExceptionTest failed");
        }
    }

    @Override
    public void getParameterValueIntIllegalStateExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            try {
                spq.getParameterValue(2);
                this.logErr("Did not throw IllegalStateException");
            }
            catch (IllegalStateException iae) {
                this.logTrace("Received expected IllegalStateException");
                pass = true;
            }
            catch (Exception e) {
                this.logErr("Caught unexpected exception", e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Fault("getParameterValueIntIllegalStateExceptionTest failed");
        }
    }

    @Override
    public void setHintStringObjectTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpFirstNameFromOut");
            spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
            spq.registerStoredProcedureParameter(2, String.class, ParameterMode.OUT);
            spq.setParameter(1, (Object)1);
            spq.getParameterValue(1);
            spq.setHint("property.that.is.not.recognized", (Object)"property.that.is.not.recognized");
            spq.execute();
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Fault("setHintStringObjectTest failed");
        }
    }

    @Override
    public void xmlOverridesNamedStoredProcedureQueryTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            StoredProcedureQuery spq = this.getEntityManager().createNamedStoredProcedureQuery("tobeoverridden1");
            spq.setParameter(1, (Object)1);
            Object o = spq.getParameterValue(1);
            if (o instanceof Integer) {
                this.logTrace("Received expected parameter type: Integer");
                Integer i = (Integer)o;
                if (i.equals(1)) {
                    this.logTrace("Received expected parameter value:" + i);
                    pass1 = true;
                } else {
                    this.logErr("Expected getParameterValue() result: 1, actual:" + i);
                }
            } else {
                this.logErr("Did not get instance of Integer from getParameterValue():" + String.valueOf(o));
            }
            if (!spq.execute()) {
                o = spq.getOutputParameterValue(2);
                if (o instanceof String) {
                    this.logTrace("Received expected parameter type: String");
                    String s = (String)o;
                    if (s.equals(this.emp0.getFirstName())) {
                        this.logTrace("Received expected parameter value:" + s);
                        pass2 = true;
                    } else {
                        this.logErr("Expected getParameterValue() result: " + this.emp0.getFirstName() + ", actual:" + s);
                    }
                }
            } else {
                this.logErr("Expected execute() to return false, actual: true");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Fault("xmlOverridesNamedStoredProcedureQueryTest failed");
        }
    }

    @Override
    public void xmlOverridesSqlResultSetMappingAnnotationTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            try {
                this.logMsg("Testing using name,result mapping");
                this.clearCache();
                StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdFNameLNameFromRS", new String[]{"tobeoverridden2"});
                spq.registerStoredProcedureParameter(1, Integer.class, ParameterMode.IN);
                if (this.dataBaseName.equalsIgnoreCase("oracle") || this.dataBaseName.equalsIgnoreCase("postgresql")) {
                    this.logTrace("register refcursor parameter");
                    spq.registerStoredProcedureParameter(2, Void.TYPE, ParameterMode.REF_CURSOR);
                }
                spq.setParameter(1, (Object)1);
                if (spq.execute()) {
                    List<List> listOfList = this.getResultSetsFromStoredProcedure(spq);
                    if (listOfList.size() == 1) {
                        ArrayList<Employee> expected = new ArrayList<Employee>();
                        expected.add(new Employee(this.emp0.getId(), this.emp0.getFirstName(), this.emp0.getLastName()));
                        pass = this.verifyListOfListEmployees(expected, listOfList);
                    } else {
                        this.logErr("Did not get the correct number of result sets returned, expected: 1, actual:" + listOfList.size());
                    }
                } else {
                    this.logErr("Expected execute() to return true, actual: false");
                }
            }
            catch (Exception ex) {
                this.logErr("Received unexpected exception:", ex);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Received unexpected exception:", ex);
        }
        if (!pass) {
            throw new Fault("xmlOverridesSqlResultSetMappingAnnotationTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmployeeTestData() {
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Creating Employees");
            Date d2 = this.getUtilDate("2001-06-27");
            Date d3 = this.getUtilDate("2002-07-07");
            Date d4 = this.getUtilDate("2003-03-03");
            Date d5 = this.getUtilDate();
            this.emp0 = new Employee(1, "Alan", "Frechette", this.utilDate, 35000.0f);
            this.empRef.add(this.emp0);
            this.empRef.add(new Employee(2, "Arthur", "Frechette", d2, 35000.0f));
            this.empRef.add(new Employee(3, "Shelly", "McGowan", d3, 50000.0f));
            this.empRef.add(new Employee(4, "Robert", "Bissett", d4, 55000.0f));
            this.empRef.add(new Employee(5, "Stephen", "DMilla", d5, 25000.0f));
            for (Employee e : this.empRef) {
                if (e == null) continue;
                this.getEntityManager().persist((Object)e);
                this.logTrace("persisted employee:" + String.valueOf(e));
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
    }
}

