/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.persistenceUnitUtil;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.persistenceUnitUtil.Employee;
import ee.jakarta.tck.persistence.core.versioning.Member;
import jakarta.persistence.PersistenceUnitUtil;
import java.math.BigInteger;
import java.util.Properties;

public class Client
extends PMClientBase {
    private final Employee[] empRef = new Employee[2];

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void getPersistenceUtilUtilTest() throws Exception {
        boolean pass = false;
        PersistenceUnitUtil puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
        if (puu != null) {
            pass = true;
        } else {
            this.logErr("getPersistenceUtil() returned null");
        }
        if (!pass) {
            throw new Exception("getPersistenceUtilUtilTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getIdentifierTest() throws Exception {
        Integer id;
        PersistenceUnitUtil puu;
        boolean pass = true;
        Employee emp = new Employee(1, "foo", "bar", this.getSQLDate("2000-02-14"), 35000.0f);
        this.logMsg("Test entity not yet persisted");
        try {
            puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            id = (Integer)puu.getIdentifier((Object)emp);
            if (id == null || id != 1) {
                this.logErr("expected a null or id: 1, actual id:" + id);
                pass = false;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        this.logMsg("Test entity persisted");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)emp);
            puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            id = (Integer)puu.getIdentifier((Object)emp);
            if (id != 1) {
                this.logErr("expected a null or id: 1, actual id:" + id);
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("getIdentifierTest failed");
        }
    }

    public void getIdentifierIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            PersistenceUnitUtil puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            puu.getIdentifier((Object)this);
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            pass = true;
            this.logTrace("Received expected IllegalArgumentException");
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("getIdentifierIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getVersionTest() throws Exception {
        boolean pass = false;
        boolean ID = true;
        Member member = new Member(1, "Member 1", true, BigInteger.valueOf(1000L));
        try {
            this.getEntityTransaction().begin();
            Member member1 = (Member)this.getEntityManager().find(Member.class, (Object)1);
            if (member1 != null) {
                this.getEntityManager().remove((Object)member1);
                this.getEntityTransaction().commit();
            }
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entity:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)member);
            PersistenceUnitUtil puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            this.getEntityTransaction().commit();
            Integer version = (Integer)puu.getVersion((Object)member);
            if (version != null && version.equals(member.getVersion())) {
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("getVersionTest failed");
        }
    }

    public void loadIsLoadTest() throws Exception {
        boolean pass = false;
        try {
            Employee employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empRef[0].getId());
            PersistenceUnitUtil puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            puu.load((Object)employee, "salary");
            if (puu.isLoaded((Object)employee, "salary")) {
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("loadIsLoadTest failed");
        }
    }

    public void isInstanceTest() throws Exception {
        boolean pass = false;
        try {
            Employee foundEmployee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empRef[0].getId());
            PersistenceUnitUtil puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            if (puu.isInstance((Object)foundEmployee, Employee.class)) {
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("isInstanceTest failed");
        }
    }

    public void getClassTest() throws Exception {
        boolean pass = false;
        try {
            Employee foundEmployee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empRef[0].getId());
            PersistenceUnitUtil puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            Class clazz = puu.getClass((Object)foundEmployee);
            if (clazz == Employee.class) {
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getClassTest failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        this.logTrace("createTestData");
        try {
            this.getEntityTransaction().begin();
            this.empRef[0] = new Employee(100, "Alan", "Frechette", this.getSQLDate("2000-02-14"), 35000.0f);
            for (Employee e : this.empRef) {
                if (e == null) continue;
                this.getEntityManager().persist((Object)e);
                this.logTrace("persisted employee " + String.valueOf(e));
            }
            this.getEntityTransaction().commit();
            this.logTrace("Created TestData");
        }
        catch (Exception re) {
            this.logErr("Unexpected Exception in createTestData:", re);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in createTestData while rolling back TX:", re);
            }
        }
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM MEMBER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

