/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.common;

import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.common.vehicle.ejb3share.UseEntityManager;
import com.sun.ts.tests.common.vehicle.ejb3share.UseEntityManagerFactory;
import jakarta.persistence.Cache;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Persistence;
import jakarta.persistence.PersistenceException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;

public abstract class PMClientBase
extends ServiceEETest
implements UseEntityManager,
UseEntityManagerFactory,
Serializable {
    protected Properties myProps = new Properties();
    private transient EntityManager em;
    private transient EntityTransaction et;
    private transient boolean inContainer;
    private transient boolean testArtifactDeployed = false;
    private transient EntityManagerFactory emf;
    EntityManagerFactory jakartaEEemf;
    public boolean cachingSupported = true;
    public static final transient String PROVIDER_PROP = "jakarta.persistence.provider";
    public static final transient String TRANSACTION_TYPE_PROP = "jakarta.persistence.transactionType";
    public static final transient String JTA_DATASOURCE_PROP = "jakarta.persistence.jtaDataSource";
    public static final transient String NON_JTA_DATASOURCE_PROP = "jakarta.persistence.nonJtaDataSource";
    public static final transient String RESOURCE_LOCAL = "RESOURCE_LOCAL";
    public static final transient String MODE_PROP = "platform.mode";
    public static final transient String JAKARTA_EE = "jakartaEE";
    public static final transient String STANDALONE_MODE = "standalone";
    public static final transient String PERSISTENCE_UNIT_NAME_PROP = "persistence.unit.name";
    public static final transient String SECOND_PERSISTENCE_UNIT_NAME_PROP = "persistence.unit.name.2";
    public static final transient String JAVAX_PERSISTENCE_PROVIDER = "jakarta.persistence.provider";
    public static final transient String JAVAX_PERSISTENCE_JDBC_DRIVER = "jakarta.persistence.jdbc.driver";
    public static final transient String JAVAX_PERSISTENCE_JDBC_URL = "jakarta.persistence.jdbc.url";
    public static final transient String JAVAX_PERSISTENCE_JDBC_USER = "jakarta.persistence.jdbc.user";
    public static final transient String JAVAX_PERSISTENCE_JDBC_PASSWORD = "jakarta.persistence.jdbc.password";
    public static final transient String JPA_PROVIDER_IMPLEMENTATION_SPECIFIC_PROPERTIES = "jpa.provider.implementation.specific.properties";
    public static final transient String PERSISTENCE_SECOND_LEVEL_CACHING_SUPPORTED = "persistence.second.level.caching.supported";
    private transient String mode;
    protected String persistenceUnitName;
    protected String secondPersistenceUnitName;

    protected PMClientBase() {
    }

    protected void removeEntity(Object o) {
        if (o != null) {
            try {
                this.getEntityManager().remove(o);
            }
            catch (Exception e) {
                this.logErr("removeEntity: Exception caught when removing entity: ", e);
            }
        }
    }

    public String getPersistenceUnitName() {
        this.logTrace("getPersistenceUnitName() - Persistence Unit Name:" + this.persistenceUnitName);
        return this.persistenceUnitName;
    }

    public String getSecondPersistenceUnitName() {
        this.logTrace("getSecondPersistenceUnitName() - Second Persistence Unit Name:" + this.secondPersistenceUnitName);
        return this.secondPersistenceUnitName;
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("PMClientBase.setup(String[] args, Properties)");
        this.myProps = p;
        this.mode = p.getProperty(MODE_PROP, JAKARTA_EE);
        this.persistenceUnitName = p.getProperty(PERSISTENCE_UNIT_NAME_PROP);
        this.logTrace("Persistence Unit Name =" + this.persistenceUnitName);
        this.secondPersistenceUnitName = p.getProperty(SECOND_PERSISTENCE_UNIT_NAME_PROP);
        this.logTrace("Second Persistence Unit Name =" + this.secondPersistenceUnitName);
        if (JAKARTA_EE.equalsIgnoreCase(this.mode)) {
            this.logTrace("platform.mode is set to " + this.mode + ", so tests are running in JakartaEE environment.");
            for (String name : p.stringPropertyNames()) {
                System.setProperty(name, p.getProperty(name));
            }
        } else if (STANDALONE_MODE.equalsIgnoreCase(this.mode)) {
            this.logTrace("platform.mode is set to " + this.mode + ", so tests are running in J2SE environment standalone mode.persistence.unit.name is set to " + this.persistenceUnitName);
        } else {
            this.logTrace("WARNING: platform.mode is set to " + this.mode + ", an invalid value.");
        }
        this.cachingSupported = Boolean.parseBoolean(p.getProperty(PERSISTENCE_SECOND_LEVEL_CACHING_SUPPORTED, "true"));
        this.displayProperties(p);
    }

    public void displayProperties(Properties props) {
        this.logMsg("Current properties:");
        for (Object entry : props.keySet()) {
            if (props.get(entry) instanceof String) {
                this.logTrace("Key:" + (String)entry + ", value:[" + String.valueOf(props.get(entry)) + "]");
                continue;
            }
            this.logTrace("Key:" + (String)entry + ", value:" + props.get(entry).getClass().getSimpleName());
        }
    }

    public void cleanup() throws Exception {
    }

    public void cleanupNoSuper() throws Exception {
    }

    public void closeEMAndEMF() throws Exception {
        if (!this.isStandAloneMode()) {
            return;
        }
        try {
            this.logTrace("Rolling back any existing transaction before closing EMF and EM if one exists.");
            if (this.getEntityTransaction(false) != null && this.getEntityTransaction(false).isActive()) {
                this.logTrace("An active transaction was found, rolling it back.");
                this.getEntityTransaction(false).rollback();
            }
        }
        catch (Exception fe) {
            this.logMsg("Unexpected exception rolling back TX: " + fe.getMessage());
        }
        this.clearCache();
        if (this.isStandAloneMode()) {
            this.logTrace("Closing EM and EMF");
            if (this.getEntityManager(false) != null && this.getEntityManager(false).isOpen()) {
                this.getEntityManager(false).close();
            }
            if (this.getEntityManagerFactory() != null && this.getEntityManagerFactory().isOpen()) {
                this.getEntityManagerFactory().close();
            }
        }
    }

    public void clearEMAndEMF() throws Exception {
        this.closeEMAndEMF();
        this.clearEntityManager();
        this.clearEntityManagerFactory();
    }

    public void clearEntityManager() {
        if (this.isStandAloneMode()) {
            this.em = null;
        }
    }

    public void clearEntityManagerFactory() {
        if (this.isStandAloneMode()) {
            this.emf = null;
        }
    }

    public void clearCache() throws Exception {
        if (this.cachingSupported) {
            if (this.getEntityManager() != null && this.getEntityManager().isOpen()) {
                if (this.getEntityManager().getEntityManagerFactory() != null && this.getEntityManager().getEntityManagerFactory().isOpen()) {
                    this.logTrace("Clearing context");
                    this.getEntityManager().clear();
                    this.logTrace("Trying to clear cache via call to EMF.getCache().evictAll().");
                    Cache cache = this.getEntityManager().getEntityManagerFactory().getCache();
                    if (cache != null) {
                        cache.evictAll();
                        this.logTrace("EMF.getCache().evictAll() was executed.");
                    } else {
                        this.logErr("Cache supported is true in ts.jte but getCache() is returning null");
                    }
                } else {
                    this.logTrace("Clearing of cache did not occur because either EntityManagerFactory was null or closed");
                }
            } else {
                this.logTrace("Clearing of cache did not occur because either EntityManager was null or closed");
            }
        } else {
            this.logTrace("Clearing of cache did not occur because it is not supposed.");
        }
    }

    public void setEntityManager(EntityManager em) {
        this.em = em;
    }

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.jakartaEEemf = emf;
    }

    public EntityManager getEntityManager() {
        return this.getEntityManager(false);
    }

    public EntityManager getEntityManager(boolean reInit) {
        if (!reInit) {
            if (this.em != null) {
                this.logTrace("Using existing entity manager class:" + this.em.getClass().getName() + " isOpen:" + this.em.isOpen());
                return this.em;
            }
            this.logTrace("getEntityManager: false was specified and EM is null");
        }
        this.logTrace("Need to Initialize EntityManager");
        if (this.isStandAloneMode()) {
            this.initEntityManager(this.persistenceUnitName, true);
            this.logTrace("EntityManager class:" + this.em.getClass().getName() + " isOpen:" + this.em.isOpen());
            return this.em;
        }
        throw new IllegalStateException("The test is running in JakartaEE environment, but PMClientBase.em has not been initialized from the vehicle component.");
    }

    public EntityManagerFactory getEntityManagerFactory() {
        if (this.isStandAloneMode()) {
            if (this.emf != null) {
                this.logTrace("EntityManagerFactory class:" + this.emf.getClass().getName() + " isOpen:" + this.emf.isOpen());
            }
            return this.emf;
        }
        if (this.jakartaEEemf != null) {
            this.logTrace("EntityManagerFactory class:" + this.jakartaEEemf.getClass().getName() + " isOpen:" + this.jakartaEEemf.isOpen());
        }
        return this.jakartaEEemf;
    }

    public void clearEntityTransaction() {
        this.et = null;
    }

    public void setEntityTransaction(EntityTransaction et) {
        this.et = et;
    }

    public EntityTransaction getEntityTransaction() {
        if (this.et != null) {
            this.logTrace("Transaction class:" + this.et.getClass().getName() + " isActive():" + this.et.isActive());
            return this.et;
        }
        this.logTrace("Need to get Transaction");
        if (this.isStandAloneMode()) {
            this.initEntityTransaction();
            if (this.et != null) {
                this.logTrace("Transaction class:" + this.et.getClass().getName() + " isActive():" + this.et.isActive());
            }
            return this.et;
        }
        throw new IllegalStateException("The test is running in JakartaEE environment, but PMClientBase.et has not been initialized from the vehicle component.");
    }

    public EntityTransaction getEntityTransaction(boolean reInit, EntityManager em) {
        if (!reInit && this.et != null) {
            this.logTrace("Transaction class:" + this.et.getClass().getName() + " isActive():" + this.et.isActive());
            return this.et;
        }
        if (this.isStandAloneMode()) {
            this.initEntityTransaction(em);
            if (this.et != null) {
                this.logTrace("Transaction class:" + this.et.getClass().getName() + " isActive():" + this.et.isActive());
            }
            return this.et;
        }
        throw new IllegalStateException("The test is running in JakartaEE environment, but PMClientBase.et has not been initialized from the vehicle component.");
    }

    public EntityTransaction getEntityTransaction(boolean reInit) {
        if (!reInit && this.et != null) {
            this.logTrace("Transaction class:" + this.et.getClass().getName() + " isActive():" + this.et.isActive());
            return this.et;
        }
        if (this.isStandAloneMode()) {
            this.initEntityTransaction();
            if (this.et != null) {
                this.logTrace("Transaction class:" + this.et.getClass().getName() + " isActive():" + this.et.isActive());
            }
            return this.et;
        }
        throw new IllegalStateException("The test is running in JakartaEE environment, but PMClientBase.et has not been initialized from the vehicle component.");
    }

    protected void initEntityManager(String persistenceUnitName, boolean useProps) {
        if (this.isStandAloneMode()) {
            this.logTrace("in initEntityManager(String, boolean): " + persistenceUnitName);
            if (useProps) {
                Properties propsMap = this.getPersistenceUnitProperties();
                this.logTrace("createEntityManagerFactory(String,Map)");
                this.emf = Persistence.createEntityManagerFactory((String)persistenceUnitName, (Map)propsMap);
            } else {
                this.logTrace("createEntityManagerFactory(String)");
                this.emf = Persistence.createEntityManagerFactory((String)persistenceUnitName);
            }
            Map emfMap = this.emf.getProperties();
            if (emfMap != null) {
                this.displayMap(emfMap);
            }
            this.em = this.emf.createEntityManager();
        } else {
            this.logMsg("The test is running in JakartaEE environment, the EntityManager is initialized in the vehicle component.");
        }
    }

    protected void initEntityTransaction() {
        EntityTransaction delegate;
        this.et = delegate = this.getEntityManager().getTransaction();
    }

    protected void initEntityTransaction(EntityManager em) {
        EntityTransaction delegate;
        this.et = delegate = em.getTransaction();
    }

    public boolean isInContainer() {
        return this.inContainer;
    }

    public void setInContainer(boolean inContainer) {
        this.inContainer = inContainer;
    }

    protected Properties getPersistenceUnitProperties() {
        Properties jpaProps = new Properties();
        if (this.isStandAloneMode()) {
            jpaProps.put("jakarta.persistence.provider", this.myProps.get("jakarta.persistence.provider"));
            jpaProps.put(JAVAX_PERSISTENCE_JDBC_DRIVER, this.myProps.get(JAVAX_PERSISTENCE_JDBC_DRIVER));
            jpaProps.put(JAVAX_PERSISTENCE_JDBC_URL, this.myProps.get(JAVAX_PERSISTENCE_JDBC_URL));
            jpaProps.put(JAVAX_PERSISTENCE_JDBC_USER, this.myProps.get(JAVAX_PERSISTENCE_JDBC_USER));
            jpaProps.put(JAVAX_PERSISTENCE_JDBC_PASSWORD, this.myProps.get(JAVAX_PERSISTENCE_JDBC_PASSWORD));
            String provider_specific_props = (String)this.myProps.get(JPA_PROVIDER_IMPLEMENTATION_SPECIFIC_PROPERTIES);
            StringTokenizer st = new StringTokenizer(provider_specific_props, ":");
            while (st.hasMoreTokens()) {
                StringTokenizer st1 = new StringTokenizer(st.nextToken(), "=");
                String pspValue = null;
                String pspName = null;
                if (st1.hasMoreTokens()) {
                    pspName = st1.nextToken();
                }
                if (st1.hasMoreTokens()) {
                    pspValue = st1.nextToken();
                }
                jpaProps.put(pspName, pspValue);
            }
            this.checkPersistenceUnitProperties(jpaProps);
        }
        return jpaProps;
    }

    public boolean isStandAloneMode() {
        return STANDALONE_MODE.equalsIgnoreCase(this.mode);
    }

    private void checkPersistenceUnitProperties(Properties jpaProps) {
        this.logTrace("persistence unit properites from user: " + jpaProps.toString());
        String provider = jpaProps.getProperty("jakarta.persistence.provider");
        if (provider == null) {
            throw new IllegalStateException("jakarta.persistence.provider not specified in persistence unit properties file");
        }
        String transactionType = jpaProps.getProperty(TRANSACTION_TYPE_PROP);
        if (transactionType != null && !RESOURCE_LOCAL.equals(transactionType)) {
            throw new IllegalStateException("jakarta.persistence.transactionType is set to an unsupported value: " + transactionType + ".  The only portably supported type is RESOURCE_LOCAL.  Please correct it in persistence unit properties file.");
        }
        String jtaDataSource = jpaProps.getProperty(JTA_DATASOURCE_PROP);
        if (jtaDataSource != null) {
            this.logMsg("WARNING: jakarta.persistence.jtaDataSource is specified as " + jtaDataSource + ", and it will be passed to the persistence provider.  However, this is in general not supported in Java SE environment");
        }
        this.logTrace("persistence unit properites verified: " + jpaProps.toString());
    }

    public Calendar getCalDate() {
        return Calendar.getInstance();
    }

    public Calendar getCalDate(int yy, int mm, int dd) {
        GregorianCalendar cal = new GregorianCalendar(yy, mm, dd);
        this.logTrace("returning date:" + String.valueOf(cal));
        return cal;
    }

    public Date getSQLDate(String sDate) {
        Date d = Date.valueOf(sDate);
        this.logTrace("returning date:" + String.valueOf(d));
        return d;
    }

    public Date getSQLDate(int yy, int mm, int dd) {
        Calendar newCal = this.getCalDate();
        newCal.clear();
        newCal.set(yy, mm, dd);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String sDate = sdf.format(newCal.getTime());
        this.logTrace("returning date:" + String.valueOf(Date.valueOf(sDate)));
        return Date.valueOf(sDate);
    }

    public Date getSQLDate() {
        Calendar calDate = this.getCalDate();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String sDate = sdf.format(calDate.getTime());
        Date d = Date.valueOf(sDate);
        this.logTrace("returning date:" + String.valueOf(d));
        return d;
    }

    public java.util.Date getUtilDate() {
        java.util.Date d = new java.util.Date();
        this.logTrace("getPKDate: returning date:" + String.valueOf(d));
        return d;
    }

    public java.util.Date getUtilDate(String sDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date d = null;
        try {
            d = formatter.parse(sDate);
        }
        catch (ParseException pe) {
            this.logErr("Received unexpected exception:" + String.valueOf(pe));
        }
        this.logTrace("getPKDate: returning date:" + String.valueOf(d));
        return d;
    }

    public Time getTimeData(String sTime) {
        Time t = Time.valueOf(sTime);
        this.logTrace("getTimeData: returning Time:" + String.valueOf(t));
        return t;
    }

    public Time getTimeData(int hh, int mm, int ss) {
        Calendar newCal = Calendar.getInstance();
        newCal.clear();
        newCal.set(hh, mm, ss);
        SimpleDateFormat sdf = new SimpleDateFormat("hh:mm:ss");
        String sDate = sdf.format(newCal.getTime());
        this.logTrace("getTimeData: returning Time:" + String.valueOf(Time.valueOf(sDate)));
        return Time.valueOf(sDate);
    }

    public Timestamp getTimestampData(String sDate) {
        String tFormat = sDate + " 10:10:10";
        Timestamp ts = Timestamp.valueOf(tFormat);
        this.logTrace("getTimestampData: returning TimeStamp:" + String.valueOf(ts));
        return ts;
    }

    public Timestamp getTimestampData(int yy, int mm, int dd) {
        this.logTrace("Entering getTimestampData");
        Calendar newCal = Calendar.getInstance();
        newCal.clear();
        newCal.set(yy, mm, dd);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String sDate = sdf.format(newCal.getTime());
        this.logTrace("getTimestampData: returning TimeStamp:" + String.valueOf(Timestamp.valueOf(sDate)));
        return Timestamp.valueOf(sDate);
    }

    public java.util.Date getPKDate(int yy, int mm, int dd) {
        Calendar newCal = Calendar.getInstance();
        newCal.clear();
        newCal.set(yy, mm, dd);
        this.logTrace("getPKDate: returning date:" + String.valueOf(newCal.getTime()));
        return newCal.getTime();
    }

    public void doFlush() throws PersistenceException {
        try {
            this.getEntityManager().flush();
        }
        catch (PersistenceException pe) {
            this.logErr("Unexpected Exception caught while flushing: ", pe);
            throw new PersistenceException("Unexpected Exception caught while flushing: " + String.valueOf((Object)pe));
        }
    }

    public <T> boolean checkEntityPK(Collection<T> actualPKS, Collection<T> expectedPKS) {
        this.logTrace("PMClientBase.checkEntityPK(Collection<T>,Collection<T>)");
        return this.checkEntityPK(actualPKS, expectedPKS, false);
    }

    public <T> boolean checkEntityPK(Collection<T> actualPKS, Collection<T> expectedPKS, boolean allowDups) {
        Integer[] epks2 = new Integer[expectedPKS.size()];
        this.logTrace("PMClientBase.checkEntityPK(Collection<T>,Collection<T>, boolean)");
        if (expectedPKS.size() != 0) {
            int i = 0;
            Iterator<T> iterator = expectedPKS.iterator();
            while (iterator.hasNext()) {
                T o;
                T ref = o = iterator.next();
                try {
                    if (ref instanceof Integer) {
                        epks2[i++] = (Integer)ref;
                        continue;
                    }
                    if (ref instanceof String) {
                        epks2[i++] = Integer.valueOf((String)ref);
                        continue;
                    }
                    Method m = ref.getClass().getMethod("getId", new Class[0]);
                    Object oo = m.invoke(ref, new Object[0]);
                    if (oo instanceof String) {
                        epks2[i++] = Integer.valueOf((String)oo);
                        continue;
                    }
                    epks2[i++] = (Integer)oo;
                }
                catch (NoSuchMethodException nsme) {
                    this.logErr("Unexpected exception thrown", nsme);
                }
                catch (IllegalAccessException iae) {
                    this.logErr("Unexpected exception thrown", iae);
                }
                catch (InvocationTargetException ite) {
                    this.logErr("Unexpected exception thrown", ite);
                }
            }
        }
        return this.checkEntityPK(actualPKS, epks2, allowDups, true);
    }

    public <T> boolean checkEntityPK(Collection<T> actualPKS, String[] expectedPKS) {
        this.logTrace("PMClientBase.checkEntityPK(Collection<T>,String[])");
        return this.checkEntityPK(actualPKS, expectedPKS, false);
    }

    public <T> boolean checkEntityPK(Collection<T> actualPKS, String[] expectedPKS, boolean allowDups) {
        Integer[] epks2 = new Integer[expectedPKS.length];
        this.logTrace("PMClientBase.checkEntityPK(Collection<T>,String[], boolean)");
        if (expectedPKS.length != 0) {
            int i = 0;
            for (String s : expectedPKS) {
                epks2[i++] = Integer.valueOf(s);
            }
        }
        return this.checkEntityPK(actualPKS, epks2, allowDups, true);
    }

    public <T> boolean checkEntityPK(Collection<T> actualPKS, Integer[] expectedPKS) {
        this.logTrace("PMClientBase.checkEntityPK(Collection<T>,Integer[])");
        return this.checkEntityPK(actualPKS, expectedPKS, false, true);
    }

    public <T> boolean checkEntityPK(Collection<T> actualPKS, Integer[] expectedPKS, boolean allowDups, boolean sortLists) {
        Object[] cpks2 = new Integer[actualPKS.size()];
        this.logTrace("PMClientBase.checkEntityPK(Collection<T>,Integer[], boolean)");
        try {
            String cpks;
            String epks;
            if (expectedPKS.length == 0) {
                epks = "()";
            } else {
                if (sortLists) {
                    Arrays.sort((Object[])expectedPKS);
                }
                epks = this.createStringVersionOfPKS(expectedPKS);
            }
            if (actualPKS.size() == 0) {
                cpks = "()";
            } else {
                int k = 0;
                Iterator<T> iterator = actualPKS.iterator();
                while (iterator.hasNext()) {
                    T o;
                    T ref = o = iterator.next();
                    try {
                        if (ref instanceof Integer) {
                            cpks2[k++] = (Integer)ref;
                            continue;
                        }
                        if (ref instanceof String) {
                            cpks2[k++] = Integer.valueOf((String)ref);
                            continue;
                        }
                        Method m = ref.getClass().getMethod("getId", new Class[0]);
                        Object oo = m.invoke(ref, new Object[0]);
                        if (oo instanceof String) {
                            cpks2[k++] = Integer.valueOf((String)oo);
                            continue;
                        }
                        cpks2[k++] = (Integer)oo;
                    }
                    catch (NoSuchMethodException nsme) {
                        this.logErr("Unexpected exception thrown", nsme);
                    }
                    catch (IllegalAccessException iae) {
                        this.logErr("Unexpected exception thrown", iae);
                    }
                    catch (InvocationTargetException ite) {
                        this.logErr("Unexpected exception thrown", ite);
                    }
                }
            }
            if (sortLists) {
                Arrays.sort(cpks2);
            }
            cpks = this.createStringVersionOfPKS((Integer[])cpks2);
            if (this.checkWrongSize(expectedPKS, (Integer[])cpks2)) {
                this.logErr("Wrong size returned, expected PKs of " + epks + ", got PKs of " + cpks);
                return false;
            }
            if (!allowDups && this.checkDuplicates((Integer[])cpks2)) {
                this.logErr("Duplicate values returned, expected PKs of " + epks + ", got PKs of " + cpks);
                return false;
            }
            if (!Arrays.equals((Object[])expectedPKS, cpks2)) {
                this.logErr("Wrong values returned, expected PKs of " + epks + ", got PKs of " + cpks);
                return false;
            }
        }
        catch (Exception e) {
            this.logErr("Exception in PMClientBase.checkEntityPK(Collection<T>,Integer[]: ", e);
            return false;
        }
        return true;
    }

    public String createStringVersionOfPKS(Integer[] iArray) {
        StringBuilder sb = new StringBuilder(2);
        sb.append("(");
        for (int i = 0; i < iArray.length; ++i) {
            sb.append(iArray[i]);
            if (i >= iArray.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean checkWrongSize(Integer[] expected, Integer[] actual) {
        this.logTrace("PMClientbase.checkWrongSize");
        if (expected.length != actual.length) {
            this.logErr("Wrong collection size returned (expected " + expected.length + ", got " + actual.length + ")");
            return true;
        }
        return false;
    }

    public boolean checkDuplicates(Integer[] iArray) {
        this.logTrace("PMClientbase.checkDuplicates");
        boolean duplicates = false;
        block0: for (int ii = 0; ii < iArray.length; ++ii) {
            for (int j = 0; j < iArray.length; ++j) {
                if (ii == j || !iArray[ii].equals(iArray[j])) continue;
                duplicates = true;
                continue block0;
            }
        }
        if (duplicates) {
            this.logErr("Wrong collection contents returned (contains duplicate entries)");
            return true;
        }
        return false;
    }

    public String compareResultList(List expected, List actual) {
        if (!expected.equals(actual)) {
            String reason = "Expecting result list: " + String.valueOf(expected) + "  , actual: " + String.valueOf(actual);
            throw new RuntimeException(reason);
        }
        String reason = "Got expected result list: " + String.valueOf(expected);
        this.logTrace(reason);
        return reason;
    }

    public void displayMap(Map map) {
        if (map != null) {
            Set set = map.entrySet();
            for (Map.Entry me : set) {
                if (me.getValue() instanceof String) {
                    this.logTrace("Map - name:" + (String)me.getKey() + ", value:" + String.valueOf(me.getValue()));
                    continue;
                }
                this.logTrace("Map - name:" + (String)me.getKey() + ", value:" + me.getValue().getClass().getName());
            }
        } else {
            this.logTrace("Map passed in to displayMap was null");
        }
    }

    public int convertToInt(Object o) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).intValue();
        }
        if (o instanceof Long) {
            return ((Long)o).intValue();
        }
        throw new IllegalArgumentException("convertToInt(): Received type not coded for:" + o.getClass().getName());
    }

    public boolean findDataInFile(File file, String searchString) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(searchString);
        return this.findDataInFile(file, list);
    }

    public boolean findDataInFile(File file, List<String> searchStrings) {
        boolean found = false;
        List<String> fileContents = this.getFileContent(file);
        int fileContentLineCount = 0;
        int foundCount = 0;
        block0: while (!found && foundCount != searchStrings.size() && fileContentLineCount != fileContents.size()) {
            for (String fileContent : fileContents) {
                ++fileContentLineCount;
                foundCount = 0;
                for (String searchString : searchStrings) {
                    this.logTrace("searchString:" + searchString);
                    if (fileContent.toLowerCase().indexOf(searchString.toLowerCase()) < 0) continue;
                    this.logTrace("Found string[" + searchString + "] in line [" + fileContent + "]");
                    ++foundCount;
                }
                if (foundCount != searchStrings.size()) continue;
                found = true;
                continue block0;
            }
        }
        if (!found) {
            if (searchStrings.size() > 1) {
                StringBuffer sb = new StringBuffer();
                int count = 0;
                for (String s : searchStrings) {
                    sb.append(s);
                    if (++count == searchStrings.size()) continue;
                    sb.append(" and ");
                }
                this.logErr("Entries:" + sb.toString() + ", not found in file:" + file.toString());
                for (String s : fileContents) {
                    this.logErr("File line[" + s + "]");
                }
            } else {
                this.logErr("Entry:" + searchStrings.get(0) + ", not found in file:" + file.toString());
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFileContent(File file) {
        ArrayList<String> list;
        block8: {
            list = new ArrayList<String>();
            try {
                if (file.exists()) {
                    this.logTrace("found file:" + file.getAbsolutePath());
                    if (file.length() > 0L) {
                        try (BufferedReader input = new BufferedReader(new FileReader(file));){
                            String line = null;
                            while ((line = input.readLine()) != null) {
                                this.logTrace("read line:" + line);
                                line = line.trim();
                                list.add(line);
                            }
                            break block8;
                        }
                    }
                    this.logErr("File is empty: " + file.getAbsolutePath());
                    break block8;
                }
                this.logErr("Specified file " + file.getAbsolutePath() + " does not exist");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return list;
    }

    public void deleteItem(File file) {
        if (file.exists()) {
            this.logTrace("item:" + file.getAbsolutePath() + " exists");
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    for (File f : files) {
                        this.deleteItem(f);
                    }
                    if (file.delete()) {
                        this.logTrace("directory: " + file.getAbsolutePath() + " deleted");
                        if (file.exists()) {
                            this.logErr("directory still exists even after calling delete");
                        }
                    } else {
                        this.logErr("Could not delete directory: " + file.getAbsolutePath());
                    }
                } else {
                    this.logErr("listFiles returned null");
                }
            } else if (file.delete()) {
                this.logTrace("file: " + file.getAbsolutePath() + " deleted");
                if (file.exists()) {
                    this.logErr("file still exists even after calling delete");
                }
            } else {
                this.logErr("Could not delete file: " + file.getAbsolutePath());
            }
        } else {
            this.logTrace("file:" + file.getAbsolutePath() + " does not exist");
        }
    }

    public String convertToURI(String path) {
        String sURI = null;
        try {
            sURI = new File(path).toURI().toASCIIString();
            this.logTrace("URI=" + sURI);
        }
        catch (Exception ue) {
            this.logErr("Received unexpected exception for path:" + path, ue);
        }
        return sURI;
    }

    public static String toString(InputStream inStream) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(inStream, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }
}

