/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.integration.session.servletejbjdbc;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.integration.session.servletejbjdbc.Teller;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;

public class ServletTest
extends HttpServlet {
    private static final int ACCOUNT = 1075;
    private static final String TELLERNAME = "joe";
    private static final String ejbRef = "java:comp/env/ejb/TellerBean";
    private static TSNamingContext nctx = null;
    private static Teller beanRef = null;
    private Properties harnessProps = null;
    private static final boolean debug = false;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        System.out.println("init");
        TestUtil.logTrace((String)("init " + ((Object)((Object)this)).getClass().getName() + " ..."));
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        TestUtil.logTrace((String)"doGet");
        System.out.println("doGet");
        Properties p = new Properties();
        res.setContentType("text/plain");
        PrintWriter out = res.getWriter();
        try {
            TestUtil.logTrace((String)"Initialize bean");
            beanRef.initialize(TELLERNAME, this.harnessProps);
            TestUtil.logTrace((String)"List all accounts in database");
            System.out.println("List all accounts in database");
            TestUtil.logTrace((String)"ACCOUNTS Database");
            TestUtil.logTrace((String)"-------- --------");
            System.out.println("ACCOUNTS Database");
            System.out.println("-------- --------");
            String accounts = beanRef.getAllAccounts();
            if (accounts != null) {
                TestUtil.logTrace((String)accounts);
                System.out.println(accounts);
            }
            TestUtil.logTrace((String)"Operating on account: 1075");
            System.out.println("Operating on account: 1075");
            double balance = beanRef.balance(1075);
            p.setProperty("Balance", "" + balance);
            TestUtil.logTrace((String)("Balance: " + balance));
            System.out.println("Balance: " + balance);
            balance = beanRef.deposit(1075, 100.0);
            p.setProperty("Deposit", "" + balance);
            TestUtil.logTrace((String)("Deposit: " + balance));
            System.out.println("Deposit: " + balance);
            balance = beanRef.withdraw(1075, 50.0);
            p.setProperty("Withdraw", "" + balance);
            TestUtil.logTrace((String)("Withdraw: " + balance));
            System.out.println("Withdraw: " + balance);
            TestUtil.logTrace((String)"list all accounts in database");
            System.out.println("list all accounts in database");
            TestUtil.logTrace((String)"ACCOUNTS Database");
            TestUtil.logTrace((String)"-------- --------");
            System.out.println("ACCOUNTS Database");
            System.out.println("-------- --------");
            accounts = beanRef.getAllAccounts();
            if (accounts != null) {
                TestUtil.logTrace((String)accounts);
                System.out.println(accounts);
            }
            p.list(out);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("doGet Exception: " + String.valueOf(e)));
            TestUtil.printStackTrace((Throwable)e);
            System.out.println("doGet Exception: " + String.valueOf(e));
            e.printStackTrace();
        }
        out.close();
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        TestUtil.logTrace((String)"doPost");
        System.out.println("doPost");
        this.harnessProps = new Properties();
        Enumeration pEnum = req.getParameterNames();
        while (pEnum.hasMoreElements()) {
            String name = (String)pEnum.nextElement();
            String value = req.getParameter(name);
            this.harnessProps.setProperty(name, value);
        }
        try {
            TestUtil.init((Properties)this.harnessProps);
            TestUtil.logTrace((String)"Remote logging intialized for Servlet");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("doPost Exception: " + String.valueOf(e)));
            System.out.println("doPost Exception: " + String.valueOf(e));
            TestUtil.printStackTrace((Throwable)e);
            throw new ServletException("unable to initialize remote logging");
        }
        try {
            if (nctx == null || beanRef == null) {
                TestUtil.logTrace((String)"Obtain naming context");
                System.out.println("Obtain naming context");
                nctx = new TSNamingContext();
                TestUtil.logTrace((String)"Lookup bean: java:comp/env/ejb/TellerBean");
                System.out.println("Lookup bean: java:comp/env/ejb/TellerBean");
                beanRef = (Teller)nctx.lookup(ejbRef, Teller.class);
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception: " + String.valueOf(e)));
            TestUtil.printStackTrace((Throwable)e);
            System.out.println("init Exception: " + String.valueOf(e));
            e.printStackTrace();
            throw new ServletException("unable to initialize servlet properly");
        }
        this.doGet(req, res);
        this.harnessProps = null;
    }
}

