/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.session;

import jakarta.websocket.CloseReason;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@ServerEndpoint(value="/WSCloseTestServer")
public class WSCloseTestServer {
    private static final Class<?>[] TEST_ARGS = new Class[]{String.class, Session.class};
    private static final System.Logger logger = System.getLogger(WSCloseTestServer.class.getName());
    static String testName;

    @OnOpen
    public void init(Session session) throws IOException {
        session.getBasicRemote().sendText("========WSCloseTestServer opened");
        if (session.isOpen()) {
            session.getBasicRemote().sendText("========session from WSCloseTestServer is open=TRUE");
        } else {
            session.getBasicRemote().sendText("========session from WSCloseTestServer is open=FALSE");
        }
    }

    @OnMessage
    public void respondString(String message, Session session) {
        logger.log(System.Logger.Level.INFO, "WSCloseTestServer got String message: " + message);
        try {
            if (message.startsWith("testName=") && message.endsWith("Test")) {
                testName = message.substring(9);
                Method method = WSCloseTestServer.class.getMethod(testName, TEST_ARGS);
                method.invoke((Object)this, message, session);
            } else {
                session.getBasicRemote().sendText("========WSCloseTestServer received String:" + message);
                session.getBasicRemote().sendText("========WSCloseTestServer responds, please close your session");
            }
        }
        catch (InvocationTargetException ite) {
            logger.log(System.Logger.Level.ERROR, "Cannot run method " + testName);
            ite.printStackTrace();
        }
        catch (NoSuchMethodException nsme) {
            logger.log(System.Logger.Level.ERROR, "Test: " + testName + " does not exist");
            nsme.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @OnError
    public void onError(Session session, Throwable t) {
        try {
            session.getBasicRemote().sendText("========WSCloseTestServer onError");
            if (session.isOpen()) {
                session.getBasicRemote().sendText("========onError: session from WSCloseTestServer is open=TRUE");
            } else {
                session.getBasicRemote().sendText("========onError: session from WSCloseTestServer is open=FALSE");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        t.printStackTrace();
    }

    @OnClose
    public void onClose() {
        logger.log(System.Logger.Level.INFO, "==From WSCloseTestServer onClose()==");
    }

    public void close1Test(String message, Session session) {
        try {
            session.getBasicRemote().sendText("========WSCloseTestServer received String: " + message);
            session.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void close2Test(String message, Session session) {
        try {
            session.getBasicRemote().sendText("========WSCloseTestServer received String: " + message);
            session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.TOO_BIG, "TCKCloseNowWithReason"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void close3Test(String message, Session session) {
        try {
            session.getBasicRemote().sendText("========WSCloseTestServer received String: " + message);
            session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.TOO_BIG, "TCKCloseNowWithReason"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

