/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.uri;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointDelta;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointListener;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimePlatformURIConverter
extends ExtensibleURIConverterImpl
implements IPlatformExtensionPointListener {
    private Object __lock = new Object();

    public RuntimePlatformURIConverter() {
        EGFPlatformPlugin.getRuntimePlatformManager().addPlatformExtensionPointListener(this);
        this.getURIMap().putAll(this.initializeURIMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void platformExtensionPointChanged(IPlatformExtensionPointDelta delta) {
        Object object = this.__lock;
        synchronized (object) {
            this.loadURIMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI normalize(URI uri) {
        Object object = this.__lock;
        synchronized (object) {
            return super.normalize(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        Object object = this.__lock;
        synchronized (object) {
            return super.createOutputStream(uri, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        Object object = this.__lock;
        synchronized (object) {
            return super.createInputStream(uri, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(URI uri, Map<?, ?> options) throws IOException {
        Object object = this.__lock;
        synchronized (object) {
            super.delete(uri, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        Object object = this.__lock;
        synchronized (object) {
            return super.contentDescription(uri, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(URI uri, Map<?, ?> options) {
        Object object = this.__lock;
        synchronized (object) {
            return super.exists(uri, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        Object object = this.__lock;
        synchronized (object) {
            return super.getAttributes(uri, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        Object object = this.__lock;
        synchronized (object) {
            super.setAttributes(uri, attributes, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.__lock;
        synchronized (object) {
            EGFPlatformPlugin.getRuntimePlatformManager().removePlatformExtensionPointListener(this);
            this.getURIMap().clear();
        }
    }

    private void loadURIMap() {
        this.getURIMap().clear();
        this.getURIMap().putAll(this.initializeURIMap());
    }

    private Map<URI, URI> initializeURIMap() {
        HashMap<URI, URI> urimap = new HashMap<URI, URI>();
        IPlatformBundle[] iPlatformBundleArray = EGFPlatformPlugin.getRuntimePlatformManager().getPlatformBundles();
        int n = iPlatformBundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleId;
            IPlatformBundle bundle = iPlatformBundleArray[n2];
            if (bundle != null && (bundleId = bundle.getBundleId()) != null) {
                urimap.put(URI.createPlatformResourceURI((String)(String.valueOf(bundleId) + "/"), (boolean)false), URI.createPlatformPluginURI((String)(String.valueOf(bundleId) + "/"), (boolean)false));
            }
            ++n2;
        }
        return urimap;
    }
}

