/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.internal.pde;

import org.eclipse.core.runtime.Assert;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.osgi.framework.Bundle;

public abstract class AbstractPlatformExtensionPoint {
    protected String _uniqueIdentifier;
    protected int _handleId = -1;
    protected IPlatformBundle _platformBundle;

    public AbstractPlatformExtensionPoint(IPlatformBundle bundle) {
        Assert.isNotNull((Object)bundle);
        Assert.isNotNull((Object)bundle.getBundleDescription());
        this._platformBundle = bundle;
    }

    public AbstractPlatformExtensionPoint(IPlatformBundle bundle, String uniqueIdentifier, int handleId) {
        Assert.isNotNull((Object)bundle);
        Assert.isNotNull((Object)bundle.getBundleDescription());
        this._platformBundle = bundle;
        this._uniqueIdentifier = uniqueIdentifier != null ? uniqueIdentifier.trim() : null;
        this._handleId = handleId;
    }

    protected void setPlatformBundle(IPlatformBundle bundle) {
        Assert.isNotNull((Object)bundle);
        Assert.isLegal((bundle.getPluginModelBase() == this._platformBundle.getPluginModelBase() ? 1 : 0) != 0);
        this._platformBundle = bundle;
    }

    protected void dispose() {
    }

    public boolean isWorkspace() {
        return this._platformBundle.isWorkspace();
    }

    public boolean isTarget() {
        return this._platformBundle.isTarget();
    }

    public boolean isRuntime() {
        return this._platformBundle.isRuntime();
    }

    public IPluginModelBase getPluginModelBase() {
        return this._platformBundle.getPluginModelBase();
    }

    public Bundle getBundle() {
        return this._platformBundle.getBundle();
    }
}

