/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.nodespacing.internal.algorithm;

import org.eclipse.elk.alg.common.nodespacing.internal.NodeContext;
import org.eclipse.elk.alg.common.nodespacing.internal.algorithm.NodeLabelAndSizeUtilities;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;

public final class NodeSizeCalculator {
    private NodeSizeCalculator() {
    }

    public static void setNodeWidth(NodeContext nodeContext) {
        double width;
        KVector nodeSize = nodeContext.nodeSize;
        if (NodeLabelAndSizeUtilities.areSizeConstraintsFixed(nodeContext)) {
            width = nodeSize.x;
        } else {
            KVector minNodeSize;
            width = nodeContext.nodeContainer.getMinimumWidth();
            if (nodeContext.sizeConstraints.contains(SizeConstraint.NODE_LABELS) && !nodeContext.sizeOptions.contains(SizeOptions.OUTSIDE_NODE_LABELS_OVERHANG)) {
                width = Math.max(width, nodeContext.outsideNodeLabelContainers.get(PortSide.NORTH).getMinimumWidth());
                width = Math.max(width, nodeContext.outsideNodeLabelContainers.get(PortSide.SOUTH).getMinimumWidth());
            }
            if ((minNodeSize = NodeLabelAndSizeUtilities.getMinimumNodeSize(nodeContext)) != null) {
                width = Math.max(width, minNodeSize.x);
            }
        }
        nodeSize.x = (Boolean)nodeContext.node.getGraph().getProperty(CoreOptions.NODE_SIZE_FIXED_GRAPH_SIZE) != false ? Math.max(nodeSize.x, width) : width;
        ElkRectangle nodeCellRectangle = nodeContext.nodeContainer.getCellRectangle();
        nodeCellRectangle.x = 0.0;
        nodeCellRectangle.width = width;
        nodeContext.nodeContainer.layoutChildrenHorizontally();
    }

    public static void setNodeHeight(NodeContext nodeContext) {
        double height;
        KVector nodeSize = nodeContext.nodeSize;
        if (NodeLabelAndSizeUtilities.areSizeConstraintsFixed(nodeContext)) {
            height = nodeSize.y;
        } else {
            KVector minNodeSize;
            height = nodeContext.nodeContainer.getMinimumHeight();
            if (nodeContext.sizeConstraints.contains(SizeConstraint.NODE_LABELS) && !nodeContext.sizeOptions.contains(SizeOptions.OUTSIDE_NODE_LABELS_OVERHANG)) {
                height = Math.max(height, nodeContext.outsideNodeLabelContainers.get(PortSide.EAST).getMinimumHeight());
                height = Math.max(height, nodeContext.outsideNodeLabelContainers.get(PortSide.WEST).getMinimumHeight());
            }
            if ((minNodeSize = NodeLabelAndSizeUtilities.getMinimumNodeSize(nodeContext)) != null) {
                height = Math.max(height, minNodeSize.y);
            }
            if (nodeContext.sizeConstraints.contains(SizeConstraint.PORTS) && (nodeContext.portConstraints == PortConstraints.FIXED_RATIO || nodeContext.portConstraints == PortConstraints.FIXED_POS)) {
                height = Math.max(height, nodeContext.insidePortLabelCells.get(PortSide.EAST).getMinimumHeight());
                height = Math.max(height, nodeContext.insidePortLabelCells.get(PortSide.WEST).getMinimumHeight());
            }
        }
        nodeSize.y = (Boolean)nodeContext.node.getGraph().getProperty(CoreOptions.NODE_SIZE_FIXED_GRAPH_SIZE) != false ? Math.max(nodeSize.y, height) : height;
        ElkRectangle nodeCellRectangle = nodeContext.nodeContainer.getCellRectangle();
        nodeCellRectangle.y = 0.0;
        nodeCellRectangle.height = height;
        nodeContext.nodeContainer.layoutChildrenVertically();
    }
}

