/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.example.workflow.provider;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.glsp.example.workflow.handler.GridSnapper;
import org.eclipse.glsp.example.workflow.wfgraph.TaskNode;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.graph.GNode;
import org.eclipse.glsp.graph.GPoint;
import org.eclipse.glsp.graph.util.GraphUtil;
import org.eclipse.glsp.server.features.commandpalette.CommandPaletteActionProvider;
import org.eclipse.glsp.server.features.directediting.LabeledAction;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.operations.CreateEdgeOperation;
import org.eclipse.glsp.server.operations.CreateNodeOperation;
import org.eclipse.glsp.server.operations.DeleteOperation;
import org.eclipse.glsp.server.types.EditorContext;

public class WorkflowCommandPaletteActionProvider
implements CommandPaletteActionProvider {
    @Inject
    protected GModelState modelState;

    public List<LabeledAction> getActions(EditorContext editorContext) {
        ArrayList<LabeledAction> actions = new ArrayList<LabeledAction>();
        if (this.modelState.isReadonly()) {
            return actions;
        }
        GModelIndex index = this.modelState.getIndex();
        List selectedIds = editorContext.getSelectedElementIds();
        Optional<GPoint> lastMousePosition = GridSnapper.snap(editorContext.getLastMousePosition());
        Set selectedElements = index.getAll((Collection)selectedIds);
        actions.addAll(new HashSet<LabeledAction>(Set.of(new LabeledAction("Create Automated Task", new ArrayList<CreateNodeOperation>(List.of(new CreateNodeOperation("task:automated", lastMousePosition.orElse(GraphUtil.point((double)0.0, (double)0.0)), "fa-plus-square")))), new LabeledAction("Create Manual Task", new ArrayList<CreateNodeOperation>(List.of(new CreateNodeOperation("task:manual", lastMousePosition.orElse(GraphUtil.point((double)0.0, (double)0.0)), "fa-plus-square")))), new LabeledAction("Create Merge Node", new ArrayList<CreateNodeOperation>(List.of(new CreateNodeOperation("activityNode:merge", lastMousePosition.orElse(GraphUtil.point((double)0.0, (double)0.0)), "fa-plus-square")))), new LabeledAction("Create Decision Node", new ArrayList<CreateNodeOperation>(List.of(new CreateNodeOperation("activityNode:decision", lastMousePosition.orElse(GraphUtil.point((double)0.0, (double)0.0)), "fa-plus-square")))), new LabeledAction("Create Category", new ArrayList<CreateNodeOperation>(List.of(new CreateNodeOperation("category", lastMousePosition.orElse(GraphUtil.point((double)0.0, (double)0.0)), "fa-plus-square")))))));
        if (selectedElements.size() == 1) {
            GModelElement element = (GModelElement)selectedElements.iterator().next();
            if (element instanceof GNode) {
                actions.addAll(this.createEdgeActions((GNode)element, index.getAllByClass(TaskNode.class)));
            }
        } else if (selectedElements.size() == 2) {
            Iterator iterator = selectedElements.iterator();
            GModelElement firstElement = (GModelElement)iterator.next();
            GModelElement secondElement = (GModelElement)iterator.next();
            if (firstElement instanceof TaskNode && secondElement instanceof TaskNode) {
                GNode firstNode = (GNode)firstElement;
                GNode secondNode = (GNode)secondElement;
                actions.add(this.createEdgeAction("Connect with Edge", firstNode, secondNode));
                actions.add(this.createWeightedEdgeAction("Connect with Weighted Edge", firstNode, secondNode));
            }
        }
        if (selectedElements.size() == 1) {
            actions.add(new LabeledAction("Delete", new ArrayList<DeleteOperation>(List.of(new DeleteOperation(selectedIds))), "fa-minus-square"));
        } else if (selectedElements.size() > 1) {
            actions.add(new LabeledAction("Delete All", new ArrayList<DeleteOperation>(List.of(new DeleteOperation(selectedIds))), "fa-minus-square"));
        }
        return actions;
    }

    private Set<LabeledAction> createEdgeActions(GNode source, Set<? extends GNode> targets) {
        LinkedHashSet<LabeledAction> actions = new LinkedHashSet<LabeledAction>();
        targets.forEach(node -> {
            boolean bl = actions.add(this.createEdgeAction("Create Edge to " + this.getLabel((GNode)node), source, (GNode)node));
        });
        targets.forEach(node -> {
            boolean bl = actions.add(this.createWeightedEdgeAction("Create Weighted Edge to " + this.getLabel((GNode)node), source, (GNode)node));
        });
        return actions;
    }

    private LabeledAction createWeightedEdgeAction(String label, GNode source, GNode node) {
        return new LabeledAction(label, new ArrayList<CreateEdgeOperation>(List.of(new CreateEdgeOperation("edge:weighted", source.getId(), node.getId()))), "fa-plus-square");
    }

    private LabeledAction createEdgeAction(String label, GNode source, GNode node) {
        return new LabeledAction(label, new ArrayList<CreateEdgeOperation>(List.of(new CreateEdgeOperation("edge", source.getId(), node.getId()))), "fa-plus-square");
    }

    private String getLabel(GNode node) {
        if (node instanceof TaskNode) {
            return ((TaskNode)node).getName();
        }
        return node.getId();
    }
}

