/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.graph.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class PropertyBasedTypeAdapter<T>
extends TypeAdapter<T> {
    private final Gson gson;
    private final String discriminator;

    public PropertyBasedTypeAdapter(Gson gson, String discriminator) {
        this.gson = gson;
        this.discriminator = discriminator;
    }

    public T read(JsonReader in) throws IOException {
        try {
            in.beginObject();
            T result = null;
            HashMap<String, JsonElement> unassignedProperties = null;
            while (in.hasNext()) {
                String propertyName = in.nextName();
                if (propertyName.equals(this.discriminator)) {
                    if (result != null) {
                        throw new IllegalStateException("Property '" + this.discriminator + "' is defined twice.");
                    }
                    result = this.createInstance(in.nextString());
                    if (unassignedProperties == null) continue;
                    for (Map.Entry entry : unassignedProperties.entrySet()) {
                        this.assignProperty(result, (String)entry.getKey(), (JsonElement)entry.getValue());
                    }
                    continue;
                }
                if (result != null) {
                    this.assignProperty(result, propertyName, in);
                    continue;
                }
                if (unassignedProperties == null) {
                    unassignedProperties = new HashMap<String, JsonElement>();
                }
                unassignedProperties.put(propertyName, this.toTree(in));
            }
            in.endObject();
            return result;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract T createInstance(String var1);

    protected void assignProperty(T instance, String propertyName, JsonReader in) throws IllegalAccessException, IOException {
        try {
            Field field = this.findField(instance.getClass(), propertyName);
            Object value = this.gson.fromJson(in, field.getGenericType());
            field.set(instance, value);
        }
        catch (NoSuchFieldException e) {
            in.skipValue();
        }
    }

    protected void assignProperty(T instance, String propertyName, JsonElement element) throws IllegalAccessException {
        try {
            Field field = this.findField(instance.getClass(), propertyName);
            Object value = this.gson.fromJson(element, field.getGenericType());
            field.set(instance, value);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    protected Field findField(Class<?> type, String propertyName) throws NoSuchFieldException {
        try {
            Field field = type.getDeclaredField(propertyName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            Class<?> superType = type.getSuperclass();
            if (superType != null) {
                return this.findField(superType, propertyName);
            }
            throw e;
        }
    }

    protected JsonElement toTree(JsonReader in) throws IOException {
        return JsonParser.parseReader((JsonReader)in);
    }

    protected void transfer(JsonReader in, JsonWriter out) throws IOException {
        JsonToken token = in.peek();
        switch (token) {
            case BEGIN_ARRAY: {
                in.beginArray();
                out.beginArray();
                while (in.hasNext()) {
                    this.transfer(in, out);
                }
                out.endArray();
                in.endArray();
                break;
            }
            case BEGIN_OBJECT: {
                in.beginObject();
                out.beginObject();
                while (in.hasNext()) {
                    out.name(in.nextName());
                    this.transfer(in, out);
                }
                out.endObject();
                in.endObject();
                break;
            }
            case STRING: {
                out.value(in.nextString());
                break;
            }
            case NUMBER: {
                out.value(in.nextDouble());
                break;
            }
            case BOOLEAN: {
                out.value(in.nextBoolean());
                break;
            }
            case NULL: {
                in.nextNull();
                out.nullValue();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void write(JsonWriter out, T value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else {
            try {
                out.beginObject();
                HashSet<String> written = new HashSet<String>();
                this.writeProperties(out, value, value.getClass(), written);
                if (!written.contains(this.discriminator)) {
                    throw new RuntimeException("Object does not contain a field '" + this.discriminator + "'.");
                }
                out.endObject();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void writeProperties(JsonWriter out, T instance, Class<?> type, Set<String> written) throws IOException, IllegalAccessException {
        Field[] fieldArray = type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int modifiers = field.getModifiers();
            if (!Modifier.isTransient(modifiers) && !Modifier.isStatic(modifiers) && written.add(field.getName())) {
                this.writeProperty(out, instance, field);
            }
            ++n2;
        }
        Class<?> superType = type.getSuperclass();
        if (superType != null) {
            this.writeProperties(out, instance, superType, written);
        }
    }

    protected void writeProperty(JsonWriter out, T instance, Field field) throws IOException, IllegalAccessException {
        field.setAccessible(true);
        out.name(field.getName());
        Object value = field.get(instance);
        if (value == null) {
            out.nullValue();
        } else {
            if (value == instance) {
                throw new RuntimeException("Object has a reference to itself.");
            }
            this.gson.toJson(value, value.getClass(), out);
        }
    }
}

