/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.graph.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.glsp.graph.GEdge;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.graph.GraphPackage;

public class GModelIndexImpl
extends ECrossReferenceAdapter
implements GModelIndex {
    protected final Map<String, GModelElement> idToElement = new HashMap<String, GModelElement>();
    protected final Map<EClass, Set<GModelElement>> typeToElements = new HashMap<EClass, Set<GModelElement>>();
    protected final GModelElement root;

    public GModelIndexImpl(EObject target) {
        if (!(target instanceof GModelElement)) {
            throw new IllegalArgumentException();
        }
        this.root = (GModelElement)target;
        this.addIfGModelElement((Notifier)target);
    }

    protected void addAdapter(Notifier notifier) {
        super.addAdapter(notifier);
        this.addIfGModelElement(notifier);
    }

    protected void addIfGModelElement(Notifier notifier) {
        if (notifier instanceof GModelElement) {
            this.notifyAdd((GModelElement)notifier);
        }
    }

    protected void removeAdapter(Notifier notifier) {
        super.removeAdapter(notifier);
        if (notifier instanceof GModelElement) {
            this.notifyRemove((GModelElement)notifier);
        }
    }

    protected void notifyAdd(GModelElement element) {
        if (this.idToElement.put(element.getId(), element) == null) {
            this.getTypeSet(element.eClass()).add(element);
            for (GModelElement child : element.getChildren()) {
                this.notifyAdd(child);
            }
        }
    }

    protected void notifyRemove(GModelElement element) {
        if (this.idToElement.remove(element.getId()) != null) {
            this.getTypeSet(element.eClass()).remove(element);
            for (GModelElement child : element.getChildren()) {
                this.notifyRemove(child);
            }
        }
    }

    public boolean isAdapterForType(Object type) {
        return GModelIndexImpl.class.equals(type);
    }

    protected void handleContainment(Notification notification) {
        super.handleContainment(notification);
        switch (notification.getEventType()) {
            case 4: {
                Notifier oldValue = (Notifier)notification.getOldValue();
                this.removeAdapter(oldValue);
                break;
            }
            case 6: {
                for (Object oldValue : (Collection)notification.getOldValue()) {
                    this.removeAdapter((Notifier)oldValue);
                }
                break;
            }
        }
    }

    @Override
    public Optional<GModelElement> get(String elementId) {
        Optional<GModelElement> indexMatch = Optional.ofNullable(this.idToElement.get(elementId));
        if (!indexMatch.isPresent() && this.isCurrentlyBuildingIndex()) {
            return this.searchInModel(elementId);
        }
        return indexMatch;
    }

    @Override
    public Set<GModelElement> getAll(Collection<String> elementIds) {
        return elementIds.stream().map(this::get).map(Optional::get).collect(Collectors.toSet());
    }

    @Override
    public Collection<GEdge> getIncomingEdges(GModelElement node) {
        return this.getEdgesWithIncomingReference(node, GraphPackage.Literals.GEDGE__TARGET);
    }

    @Override
    public Collection<GEdge> getOutgoingEdges(GModelElement node) {
        return this.getEdgesWithIncomingReference(node, GraphPackage.Literals.GEDGE__SOURCE);
    }

    protected List<GEdge> getEdgesWithIncomingReference(GModelElement node, EReference feature) {
        return this.getNonNavigableInverseReferences(node).stream().filter(s -> feature.equals(s.getEStructuralFeature())).filter(s -> s.getEObject() instanceof GEdge).map(s -> (GEdge)s.getEObject()).collect(Collectors.toList());
    }

    @Override
    public Set<String> allIds() {
        return this.idToElement.keySet();
    }

    @Override
    public int getCounter(EClass eClass, Function<Integer, String> idProvider) {
        String id;
        int i = this.getTypeCount(eClass);
        while (this.get(id = idProvider.apply(i)).isPresent()) {
            ++i;
        }
        return i;
    }

    private Set<GModelElement> getTypeSet(EClass eClass) {
        return this.typeToElements.computeIfAbsent(eClass, t -> new HashSet());
    }

    @Override
    public int getTypeCount(EClass eClass) {
        return this.getTypeSet(eClass).size();
    }

    @Override
    public GModelElement getRoot() {
        return this.root;
    }

    @Override
    public void clear() {
        this.idToElement.clear();
        this.typeToElements.clear();
    }

    public boolean isCurrentlyBuildingIndex() {
        return this.settingTargets;
    }

    public Optional<GModelElement> searchInModel(String elementId) {
        if (elementId.equals(this.root.getId())) {
            return Optional.of(this.root);
        }
        TreeIterator eAllContents = this.root.eAllContents();
        while (eAllContents.hasNext()) {
            GModelElement gModelElement;
            EObject next = (EObject)eAllContents.next();
            if (!(next instanceof GModelElement) || !elementId.equals((gModelElement = (GModelElement)next).getId())) continue;
            return Optional.of(gModelElement);
        }
        return Optional.empty();
    }
}

