/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.gmodel;

import java.util.Optional;
import org.eclipse.emf.common.command.Command;
import org.eclipse.glsp.graph.GEdge;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.server.operations.GModelOperationHandler;
import org.eclipse.glsp.server.operations.ReconnectEdgeOperation;
import org.eclipse.glsp.server.types.GLSPServerException;
import org.eclipse.glsp.server.utils.GModelUtil;

public class GModelReconnectEdgeOperationHandler
extends GModelOperationHandler<ReconnectEdgeOperation> {
    @Override
    public Optional<Command> createCommand(ReconnectEdgeOperation operation) {
        return this.commandOf(() -> this.executeReconnect(operation));
    }

    protected void executeReconnect(ReconnectEdgeOperation operation) {
        if (operation.getEdgeElementId() == null || operation.getSourceElementId() == null || operation.getTargetElementId() == null) {
            throw new IllegalArgumentException("Incomplete reconnect connection action");
        }
        GModelIndex index = this.modelState.getIndex();
        GEdge edge = (GEdge)GLSPServerException.getOrThrow(index.findElementByClass(operation.getEdgeElementId(), GEdge.class), "Invalid edge: edge ID " + operation.getEdgeElementId());
        GModelElement source = (GModelElement)GLSPServerException.getOrThrow(index.findElement(operation.getSourceElementId(), GModelUtil.IS_CONNECTABLE), "Invalid source: source ID " + operation.getSourceElementId());
        GModelElement target = (GModelElement)GLSPServerException.getOrThrow(index.findElement(operation.getTargetElementId(), GModelUtil.IS_CONNECTABLE), "Invalid target: target ID: " + operation.getTargetElementId());
        edge.setSourceId(source.getId());
        edge.setTargetId(target.getId());
        edge.getRoutingPoints().clear();
    }
}

