/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.gmodel.commandstack;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.server.internal.gmodel.commandstack.GModelChangeRecorder;

public class GModelRecordingCommand
extends AbstractCommand {
    private final GModelRoot modelRoot;
    private Runnable runnable;
    private ChangeDescription change;

    public GModelRecordingCommand(GModelRoot root, String label, Runnable runnable) {
        super(label);
        this.modelRoot = root;
        this.runnable = runnable;
    }

    protected boolean prepare() {
        return this.change == null;
    }

    public void execute() {
        GModelChangeRecorder recorder = new GModelChangeRecorder(this.modelRoot).beginRecording();
        try {
            this.runnable.run();
        }
        finally {
            this.change = recorder.endRecording();
            recorder.dispose();
            this.runnable = null;
        }
    }

    public boolean canUndo() {
        return this.change != null;
    }

    public void undo() {
        this.applyChanges();
    }

    public void redo() {
        this.applyChanges();
    }

    protected void applyChanges() {
        GModelChangeRecorder recorder = new GModelChangeRecorder(this.modelRoot).beginRecording();
        try {
            this.change.apply();
        }
        finally {
            this.change = recorder.endRecording();
            recorder.dispose();
        }
    }
}

